//===- aspicere2.h - Common data types for advices -*- C -*-===//
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Aspicere2.
 *
 * The Initial Developer of the Original Code is
 * the Ghislain Hoffman Software Engineering Lab, INTEC, University Ghent.
 * Portions created by the Initial Developer are Copyright (C) 2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Bram Adams <bram_DOT_adams_AT_ugent_DOT_be>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#ifndef ASPICERE2_H
#define ASPICERE2_H

typedef struct JOINPOINT{
  void* cross_advice_context[5];
} JOINPOINT;

typedef struct DUMMY{int d;} DUMMY;//otherwise LLVM confuses DUMMY* with sbyte*

typedef DUMMY* TYPE;
void* proceed();
void* dummy_proceed();//used for temporal around advice

typedef struct ____ASPICERE2_Node{
  void** data;
  struct ____ASPICERE2_Node* prev;
} __ASPICERE2_Node;

typedef __ASPICERE2_Node* __ASPICERE2_NodePtr;

typedef struct{
  __ASPICERE2_NodePtr top;
  /*  int stack_size;//we omit it as we always have a separate counter too*/
  int node_size;
} __ASPICERE2_Stack;

typedef __ASPICERE2_Stack* __ASPICERE2_StackPtr;

void __ASPICERE2_stack_push(__ASPICERE2_StackPtr stack,int size,...);
void __ASPICERE2_stack_pop(__ASPICERE2_StackPtr stack);
void* __ASPICERE2_stack_peek(const __ASPICERE2_StackPtr stack,int index);
/*int __ASPICERE2_stack_size(const __ASPICERE2_StackPtr stack);*/
int __ASPICERE2_node_size(const __ASPICERE2_StackPtr stack);

void** __ASPICERE2_clips_get_current_environment(void);
void __ASPICERE2_clips_destroy_current_environment(void);

 
#endif

