#include "aspicere2.h"
#include "clips.h"

void** __ASPICERE2_clips_get_current_environment(void){
  static void* env=0;

  if(!env){
    env=CreateEnvironment();
    EnvSetFactDuplication(env,1);
    Clear(env);
  }

  return &env;
}

//NO lazy destroy: immediately freed (this function merely avoids double destroy)
void __ASPICERE2_clips_destroy_current_environment(void){
  void** env=__ASPICERE2_clips_get_current_environment();

  if(*env){
    DestroyEnvironment(*env);
    *env=0;
  }

  return;
}
