//===- matcher/JoinPoint.h - Reification of matched join point -*- C++ -*-===//
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Aspicere2.
 *
 * The Initial Developer of the Original Code is
 * the Ghislain Hoffman Software Engineering Lab, INTEC, University Ghent.
 * Portions created by the Initial Developer are Copyright (C) 2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Bram Adams <bram_DOT_adams_AT_ugent_DOT_be>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#ifndef JOINPOINT_H
#define JOINPOINT_H

#include "matcher/Context.h"
#include "weaver/ResidueProcessor.h"
#include "llvm/Constants.h"
#include "llvm/DerivedTypes.h"
#include "llvm/Type.h"
#include "llvm/Value.h"

class Munger;

class JoinPoint{
public:
  typedef std::vector<std::pair<llvm::Value*,ResidueProcessor*> > ResidueMap;

  JoinPoint(const std::string& aspect,const std::string& advice,llvm::Value* shadow,std::vector<std::string>* variables,Context* context,ResidueMap* residues,ResidueMap* miscResidues):_aspect(aspect),_advice(advice),_time("unknown"),_type("unknown"),_shadow(shadow),_variables(variables),_context(context),_residues(residues),_miscResidues(miscResidues),_dummy(false){}
  virtual void accept(Munger* munger) const=0;

  std::string getAspectName() const{
    return _aspect;
  }

  std::string getAdviceName() const{
    return _advice;
  }

  std::string getTime() const{
    return _time;
  }

  std::string getType() const{
    return _type;
  }

  llvm::Value* getShadow() const{
    return _shadow;
  }

  void setShadow(llvm::Value* shadow){
    _shadow=shadow;
  }

  Context* getContext() const{
    return _context;
  }

  ResidueMap* getResidues() const{
    return _residues;
  }

  void setResidues(ResidueMap* res){
    if(_residues) delete _residues;
    _residues=res;
  }

  ResidueMap* getMiscResidues() const{
    return _miscResidues;
  }

  void setMiscResidues(ResidueMap* res){
    if(_miscResidues) delete _miscResidues;
    _miscResidues=res;
  }

  bool isDummy() const{
    return _dummy;
  }

  void setDummy(bool dummy){
    _dummy=dummy;
  }

  /*  int getIntegerValueFor(const std::string& variable) const{
    llvm::ConstantSInt* res=dynamic_cast<llvm::ConstantSInt*>(_context->lookup(llvm::Type::IntTy,variable));
    return res->getValue();
  }

  float getFloatValueFor(const std::string& variable) const{
    llvm::ConstantFP* res=dynamic_cast<llvm::ConstantFP*>(_context->lookup(llvm::Type::FloatTy,variable));
    return res->getValue();
  }

  std::string getStringValueFor(const std::string& variable) const{
    llvm::ConstantArray* res=dynamic_cast<llvm::ConstantArray*>(_context->lookup(llvm::ArrayType::get(llvm::Type::SByteTy, 0),variable));
    return res->getAsString();
    }*/

  std::vector<std::string>* getVariables() const{
    return _variables;
  }

  virtual ~JoinPoint(){
    delete _variables;
    delete _context;
    if(_residues) delete _residues;
    if(_miscResidues) delete _miscResidues;
  }

private:
  std::string _aspect;
  std::string _advice;
  std::string _time;/**< after, after_returning, before, around and intro */
  std::string _type;/**< call, execution, continuation, ... */
  llvm::Value* _shadow;
  std::vector<std::string>* _variables;
  Context* _context;
  ResidueMap* _residues;/**< residues related to this join point's shadow */
  ResidueMap* _miscResidues;/**< residues corresponding to other shadow, but related to this join point (e.g. update shadow of a query shadow) */
  bool _dummy;/**< this join point was only created to let its miscellaneous residues be executed */

protected:
  void setTime(const std::string& time){
    _time=time;
  }
  void setType(const std::string& type){
    _type=type;
  }
};

#endif
