//===- matcher/Matcher.h - Join point matching pass -*- C++ -*-===//
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Aspicere2.
 *
 * The Initial Developer of the Original Code is
 * the Ghislain Hoffman Software Engineering Lab, INTEC, University Ghent.
 * Portions created by the Initial Developer are Copyright (C) 2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Bram Adams <bram_DOT_adams_AT_ugent_DOT_be>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#ifndef MATCHER_H
#define MATCHER_H

#include "matcher/Director.h"
#include "llvm/Module.h"
#include "llvm/Pass.h"
#include <map>
#include <vector>

struct Matcher: public llvm::ModulePass{
 public:
  static char ID;
  Matcher():llvm::ModulePass((intptr_t)&ID),matches(0),cross_advice_context(0){}
  //  virtual ~Matcher(){}
  virtual void getAnalysisUsage(llvm::AnalysisUsage &AU) const;
  virtual bool runOnModule(llvm::Module &M);
  std::vector<Director*>* getMatches() const{
    return matches;
  }
  std::multimap<llvm::Value*,std::pair<llvm::Value*,int> >* getCrossAdviceContext() const{
    return cross_advice_context;
  }
  //  void RunOptimizations(llvm::PassManager& mgr,...);//cl::opt<OptimizationLevels>& optLevel);
 private:
  std::vector<Director*>* matches;/**< resulting matches (list of Directors, each guarding a JoinPoint) */
  std::multimap<llvm::Value*,std::pair<llvm::Value*,int> >* cross_advice_context;/**< mapping of shadows to cross-advice context */
};

llvm::ModulePass* createMatcherPass();

#endif
