//===-- prolog/MetaFactBase.h - Declaration of the MetaFactBase class ------*- C++ -*-===//
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Aspicere2.
 *
 * The Initial Developer of the Original Code is
 * the Ghislain Hoffman Software Engineering Lab, INTEC, University Ghent.
 * Portions created by the Initial Developer are Copyright (C) 2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Bram Adams <bram_DOT_adams_AT_ugent_DOT_be>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#ifndef METAFACTBASE_H
#define METAFACTBASE_H

#include "prolog/DebugInfo.h"
#include "llvm/Type.h"
#include "llvm/Value.h"
#include <map>
#include <set>
#include <vector>

/**
 * To reduce stack space needed by SWI engine (limited to 128 MB on 32 bit systems), we store the extra-ordinary huge amount of debuginfo here, as well as mappings from SWI pointer representation to the C++ one. Normally, this object can be destroyed once matching is finished.
 */
class MetaFactBase{
public:
 MetaFactBase():debugFacts(),valuePointers(),typePointers(){}
  virtual ~MetaFactBase();

  void addDebugFact(llvm::Value* val,DebugInfo* info);
  DebugInfo* getDebugFact(llvm::Value* val);//return 0-pointer if nothing found
  void dumpDebugFacts() const;

  bool isPointer(void* ptr) const;
  bool isValuePointer(void* ptr) const;
  bool isTypePointer(void* ptr) const;

  void addValuePointer(llvm::Value* val);
  void addTypePointer(llvm::Type* val);
private:
  std::map<llvm::Value*,DebugInfo*> debugFacts;//DebugInfo* are owned by MetaFactBase-instance
  std::set<llvm::Value*> valuePointers;
  std::set<llvm::Type*> typePointers;
};

#endif
