//===-- prolog/QueryEngine.h - Declaration of the QueryEngine class ------*- C++ -*-===//
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Aspicere2.
 *
 * The Initial Developer of the Original Code is
 * the Ghislain Hoffman Software Engineering Lab, INTEC, University Ghent.
 * Portions created by the Initial Developer are Copyright (C) 2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Bram Adams <bram_DOT_adams_AT_ugent_DOT_be>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#ifndef QUERYENGINE_H
#define QUERYENGINE_H

#include "prolog/QueryEngineException.h"
#include "matcher/Director.h"
#include "prolog/MetaFactBase.h"
//#include "llvm/Module.h"
#include "llvm/Analysis/CallGraph.h"
#include "llvm/Type.h"
#include "llvm/Value.h"
#ifndef SWI_CPP_H
#define SWI_CPP_H
#include "SWI-cpp.h"
#endif
#include <map>
#include <vector>

class QueryEngine{
public:
  QueryEngine() throw (QueryEngineException);
  virtual ~QueryEngine();
  void insert(const std::string& functor,const std::vector<llvm::Value*>& ptr_args,const std::vector<llvm::Type*>& type_args,const std::vector<int>& int_args,const std::vector<std::string>& string_args);
  std::vector<Director*>* query();
  std::multimap<llvm::Value*,std::pair<llvm::Value*,int> >* getCrossAdviceContext();
  void addCallGraph(llvm::CallGraph& callGraph);

  /*DANGEROUS, but for efficiency reasons!*/
  MetaFactBase* getMetaBase(){
    return metaBase;
  }

  /*DANGEROUS, but for efficiency reasons!*/
  /*  std::vector<std::pair<llvm::Instruction*,ResidueProcessor*> >* getResidues(){
    return residues;
    }*/

  /*  static llvm::Module* getCurrentModule(){
    return module;
  }

  static void setCurrentModule(llvm::Module* m){
    module=m;
    }*/
private:
  PlEngine* engine;
  MetaFactBase* metaBase;
  //  std::vector<std::pair<llvm::Instruction*,ResidueProcessor*> >* residues;
  ///  static llvm::Module* module;//necessary to find out if context gathered during matching is a Type or a Value (we only know it's void*!)
};

#endif
