#include "aspicere2.h"
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>

void __ASPICERE2_stack_push(__ASPICERE2_StackPtr stack,int size,...){
  int i=0;

  if(size<=0){
    printf("__ASPICERE2_Stack expects nodes with size bigger than 0, but received size %d...\n",size);
    exit(1);
  }
  if(stack->top!=0 && stack->node_size!=size){
    printf("__ASPICERE2_Stack expects all nodes to have same size, but received size %d whereas size %d was required...\n",size,stack->node_size);
    exit(1);
  }

  void** data=malloc(size*sizeof(void*));

  va_list ap;
  va_start(ap,size);
  for(i=0;i<size;i++){
    data[i]=va_arg(ap,void*);
  }
  va_end(ap);
  
  __ASPICERE2_Node* node=(__ASPICERE2_Node*)malloc(sizeof(__ASPICERE2_Node));
  node->data=data;
  node->prev=stack->top;

  stack->top=node;
  /*  stack->stack_size++;*/
  stack->node_size=size;
}

void __ASPICERE2_stack_pop(__ASPICERE2_StackPtr stack){
  if(stack->top==0){
    printf("__ASPICERE2_Stack should at least contain one node when popping...\n");
    exit(1);
  }

  __ASPICERE2_NodePtr oldTop=stack->top;
  stack->top=stack->top->prev;

  free(oldTop->data);
  free(oldTop);

  /*  stack->stack_size--;*/
}

void* __ASPICERE2_stack_peek(const __ASPICERE2_StackPtr stack,int index){
  if(stack->top==0){
    printf("__ASPICERE2_Stack should at least contain one node when peeking...\n");
    exit(1);
  }
  if(index<0 || stack->node_size<=index){
    printf("Provided index should be bigger than zero and smaller than __ASPICERE2_Stack's node size, but is %d...\n",index);
    exit(1);
  }

  return stack->top->data[index];
}

/*int __ASPICERE2_stack_size(const __ASPICERE2_StackPtr stack){
  return stack->stack_size;
  }*/

int __ASPICERE2_node_size(const __ASPICERE2_StackPtr stack){
  return stack->node_size;
}
