//===- stripdebug/StripDebugVisitor.h - Strips unnecessary debug info from IR -*- C++ -*-===//
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Aspicere2.
 *
 * The Initial Developer of the Original Code is
 * the Ghislain Hoffman Software Engineering Lab, INTEC, University Ghent.
 * Portions created by the Initial Developer are Copyright (C) 2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Bram Adams <bram_DOT_adams_AT_ugent_DOT_be>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#ifndef STRIPDEBUGVISITOR_H
#define STRIPDEBUGVISITOR_H

#include "prolog/QueryEngine.h"
#include "llvm/IntrinsicInst.h"
#include "llvm/Support/InstVisitor.h"

/**
 * Strips debugging info from bitcode if "-debug-only=no" is NOT set. Also, annotation info (line/column number and directory/file name) is asserted into a MetaFactBase-instance and also (for Functions) directory and file name are stored into a new DebugAnnotation-object attached to the Function. Stripping occurs in two phases:
 * <ol>
 *  <li>false: individual debug statements are removed (if desired) after extracting relevant annotation code</li>
 *  <li>true: debugging global variable declartions and function definitions are stripped</li>
 * </ol>
 */
class StripDebugVisitor: public llvm::InstVisitor<StripDebugVisitor> {
 public:
  StripDebugVisitor(QueryEngine* eng,bool phase=false);

  virtual ~StripDebugVisitor(){}

  /**
   * Cleans up: "alloca point" = cast int 0 to int		; <int> [#uses=0]
   */
  void visitCastInst(llvm::CastInst &I);

  void visitInstruction(llvm::Instruction &I);

  /**
   * Cleans up debugging variables.
   */
  void visitModule(llvm::Module &F);

  /**
   * Cleans up debugging Function objects.
   */
  void visitFunction(llvm::Function &F);

  bool inFirstPhase() const{
    return !_phase;
  }

  bool inSecondPhase() const{
    return _phase;
  }

  void togglePhase(){
    _phase=!_phase;
  }

 private:
  MetaFactBase* metaBase;/**< to add debugging info */
  bool _phase;/**< false: remove debugging calls; true: remove debugging Functions */
};

#endif
