//===- utility/Cloning.h - Utility functions for cloning things -*- C++ -*-===//
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Aspicere2.
 *
 * The Initial Developer of the Original Code is
 * the Ghislain Hoffman Software Engineering Lab, INTEC, University Ghent.
 * Portions created by the Initial Developer are Copyright (C) 2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Bram Adams <bram_DOT_adams_AT_ugent_DOT_be>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#ifndef CLONING_H
#define CLONING_H

#include "llvm/Function.h"
#include "llvm/Instructions.h"
#include "llvm/Type.h"
#include "llvm/Value.h"
#include "llvm/Transforms/Utils/Cloning.h"
#include <map>
#include <set>

/**
 * Number of utility functions concerned with cloning of various LLVM entities.
 */

llvm::Function* cloneFunctionSignature(const llvm::Function* const oldFunction,std::map<llvm::Value*, llvm::Value*> &ValueMap,bool clone_var_arg_flag=true,bool add_join_point_struct_in_front=false);
llvm::Function* cloneFunctionSignatureFromCall(llvm::CallInst* call,const std::string& name,llvm::Type* returnType,bool addJoinPointStructArgument=false);
llvm::Function* cloneFunctionWithOtherReturnType(const llvm::Function *F,llvm::Type* returnType,const std::string& name,llvm::DenseMap<const llvm::Value*, llvm::Value*> &ValueMap,std::vector<std::pair<std::string,llvm::Type*> >& extraArgs,llvm::ClonedCodeInfo *CodeInfo,std::map<llvm::Type*,llvm::Type*>& dummyTypeToContextType,std::set<std::string>& typeArgumentNames);
void transferBasicBlocks(llvm::Function* newFunction,llvm::Function* oldFunction,std::map<llvm::Value*, llvm::Value*> &ValueMap);
void transferBasicBlocks(llvm::Function* function,llvm::BasicBlock* basic,std::map<llvm::Value*, llvm::Value*> &ValueMap);
llvm::CallInst* addCallFromTo(llvm::Function* from,llvm::Function* to);
llvm::Type* cloneAndChangeElementType(llvm::Type* t,const std::map<llvm::Type*,llvm::Type*>& typeMap);

#endif
