//===- weaver/Utils.h - Utility functions for weaving -*- C++ -*-===//
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Aspicere2.
 *
 * The Initial Developer of the Original Code is
 * the Ghislain Hoffman Software Engineering Lab, INTEC, University Ghent.
 * Portions created by the Initial Developer are Copyright (C) 2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Bram Adams <bram_DOT_adams_AT_ugent_DOT_be>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#ifndef UTILS_H
#define UTILS_H

#include "matcher/Context.h"
#include "matcher/JoinPoint.h"
#include "llvm/Function.h"
#include "llvm/Instructions.h"
#include "llvm/Type.h"
#include <map>
#include <vector>

bool isParameterisedAdvice(llvm::Function* advice);
bool is_vararg_manipulating_function(JoinPoint* jp);
llvm::Function* cloneParameterisedAdvice(llvm::Function* advice,llvm::Instruction* shadow,Context* context,std::map<llvm::Type*,llvm::Type*>& dummyTypeToContextType,std::vector<llvm::Value*>* extra_advice_args=0,bool shadow_actuals_need_to_be_added=true);

/*
 * Used by \see{CrossAdviceContextExtracter} to add glue code to Functions after body extraction which have an introduction attached to it (\see{tie_variable_to_join_point}).
 */
void insertCrossAdviceContext(llvm::Function* F);

/**
 * Generates code for retrieval of context variables depending on their kind.
 */
llvm::Value* getActualForContextVariable(JoinPoint* jp,const std::string& varName,llvm::Function* advice,llvm::Instruction* locationBeforeWhichToWeave);

/*
 * Deals with type parameterised context variables, normal ones (dispatched to \see{getActualForContextVariable}) and reuse of an existing thisJoinPoint-struct.
 */
std::vector<llvm::Value*> get_context_actuals(JoinPoint* jp,llvm::Function* enclosingFunction,llvm::Function* advice,llvm::Function* advice_stub,Context* context,std::map<llvm::Type*,llvm::Type*>& dummyTypeToContextType,llvm::Instruction* locationBeforeWhichToWeave);

/*
 * Coordinates retrieval of advice actuals (dispatch to \see{get_context_actuals}) and completes it with extra actuals (e.g. after returning) and call shadows.
 */
std::vector<llvm::Value*> get_advice_actuals(JoinPoint* jp,llvm::Function* enclosingFunction,llvm::Function* advice,llvm::Function* advice_stub,Context* context,std::map<llvm::Type*,llvm::Type*>& dummyTypeToContextType,llvm::Instruction* locationBeforeWhichToWeave,std::vector<llvm::Value*>* extra_advice_args=0,bool shadow_actuals_need_to_be_added=true);

/**
 * Repairs uses of type parameters in body by replacing them with values of right type.
 */
bool repairTypeParameterisedVariable(llvm::Instruction* instruction,std::map<llvm::Type*,llvm::Type*>& dummyTypeToContextType);

/*
 * Initialises an after-returning shadow's context and advice markers.
 */
void init_markers(llvm::Instruction* shadow);

/**
 * Replace all uses of first argument by second argument, but only for users following the latter. CAVEAT: both arguments should reside in same basic block!
 */
void replaceAllUsesAfterWith(llvm::Instruction* shadow,llvm::Instruction* newReturnValue);

#endif
