/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Aspicere2.
 *
 * The Initial Developer of the Original Code is
 * the Ghislain Hoffman Software Engineering Lab, INTEC, University Ghent.
 * Portions created by the Initial Developer are Copyright (C) 2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Bram Adams <bram_DOT_adams_AT_ugent_DOT_be>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#define DEBUG_TYPE "native"

#include "matcher/Context.h"
#include "prolog/QueryEngine.h"
#include "prolog/MetaFactBase.h"
#include "prolog/NativePublicAPI.h"
#include "stripdebug/CrossAdviceContextAnnotation.h"
#include "stripdebug/DebugAnnotation.h"
#include "utility/Naming.h"
#include "utility/Util.h"
#include "weaver/CflowQueryShadowResidueProcessor.h"
#include "weaver/CflowCounterUpdateShadowResidueProcessor.h"
#include "weaver/CflowStackUpdateShadowResidueProcessor.h"
#include "weaver/Munger.h"
#include "weaver/Utils.h"
#ifndef SWI_CPP_H
#define SWI_CPP_H
#include "SWI-cpp.h"
#endif
#include "llvm/Analysis/Dominators.h"
#include "llvm/Argument.h"
#include "llvm/Constants.h"
#include "llvm/Function.h"
#include "llvm/Instructions.h"
#include "llvm/Module.h"
#include "llvm/DerivedTypes.h"
//#include "llvm/SymbolTable.h"
#include "llvm/Support/Debug.h"
#include "llvm/Type.h"

#include <boost/regex.hpp>
#include <iostream>
#include <map>

using namespace llvm;
using namespace std;

namespace{
  // Helper method to alleviate problems when one function needs more than one query to perform: PlQuery's destructor needs to close things apparently...
  void do_query(const char* predicate,const PlTermv& args,const char* error_msg){
    PlQuery q(predicate, args);
    assert(q.next_solution() && error_msg );
  }

  // Helper method to alleviate problems when one function needs more than one query to perform: PlQuery's destructor needs to close things apparently...
  bool check_query(const char* predicate,const PlTermv& args){
    PlQuery q(predicate, args);
    return q.next_solution();
  }
}

static MetaFactBase* metaBase;//does NOT need to be cleaned up; initialised by init_meta_base
static CallGraph* callGraph;//does NOT need to be cleaned up; initialised by init_call_graph
static map<Value*,vector<Value*> > residueMap;//query shadow to list of update shadows; will be filled during matching and on a full match the corresponding shadow's entry will be erased <--> why *vector* of int? query shadow can be in cflow of more than one update shadow
static map<Value*,GlobalVariable*> updateShadowToCounter;//update shadow to counter; will be filled during matching and cleaned up afterwards
static multimap<GlobalVariable*,Value*> countersToProcess;//mapping of counters to update shadow; counters need to be passed to some query shadow to process their residue; will be filled during matching and on a full match the corresponding shadow's entries will all be erased, i.e. the set will be empty until matches for other advices will need it; mapping to update shadow to make sure that each update shadow gets counter updating code
static vector<GlobalVariable*> currentCounters;//one entry per cflow-construct
static int currentCountersIndex=-1;//used to know during Prolog matching the index of the cflow in the list of all cflows in a pointcut; lot of machinery needed to handle this right (aka "paradigm leak": Prolog <--> C++)
static map<Value*,map<string,Value*> > crossFunctionContext;//mapping of shadow to vector of cross-function context (e.g. for cflow) which will at most contain one entry, as make_context() will (possibly) add something and make_residues will in that case pop it
//DEBUG//static map<GlobalVariable*,GlobalVariable*> counterToStack;//if stack needed next to counter
//DEBUG//static multimap<Value*,GlobalVariable*> queryShadowsProcessed;//query to counters

static map<string,map<Value*,vector<Value*> > > adviceToResidueMap;
static map<string,vector<GlobalVariable*> > adviceToCurrentCounters;
static map<string,map<Value*,GlobalVariable*> > adviceToUpdateShadowToCounter;
static map<string,multimap<GlobalVariable*,Value*> > adviceToCountersToProcess;
static std::string currentAspect("");
static std::string currentAdvice("");

void print(vector<JoinPoint*>& jps){
  std::cout << "Group: " << std::endl;

  for(unsigned int advicej=0;advicej<jps.size();advicej++){
    JoinPoint* jp=jps[advicej];
    std::cout << jp->getAspectName() << "#" << jp->getAdviceName() << " @ " <<  jp->getTime() << " of " << jp->getType() << " (" << jp->getShadow() << ")" << std::endl;
  }

  std::cout << "-------------" << std::endl;
}

void print2(std::vector<Director*>* matches){
  std::cout << "Original: " << std::endl;

  for(unsigned int advicej=0;advicej<matches->size();advicej++){
    JoinPoint* jp=(*matches)[advicej]->getJoinPoint();
    std::cout << jp->getAspectName() << "#" << jp->getAdviceName() << " @ " <<  jp->getTime() << " of " << jp->getType() << " (" << jp->getShadow() << ")" << std::endl;
  }

  std::cout << "-------------" << std::endl;
}

void storeData(std::string& aspect,std::string& advice){
  string adviceID=aspect+"#"+advice;

  if(residueMap.size()>0){//only if there is a residue
    adviceToResidueMap[adviceID]=residueMap;
    adviceToCurrentCounters[adviceID]=currentCounters;
    adviceToUpdateShadowToCounter[adviceID]=updateShadowToCounter;
    adviceToCountersToProcess[adviceID]=countersToProcess;
  }

  residueMap.clear();
  currentCounters.clear();
  updateShadowToCounter.clear();
  countersToProcess.clear();
}

void clearData(){
  adviceToResidueMap.clear();
  adviceToCurrentCounters.clear();
  adviceToUpdateShadowToCounter.clear();
  adviceToCountersToProcess.clear();
}

/**
 * Checks whether something (no global or constant) is in scope of actor.
 */
/*static bool is_in_scope_of(Value* something,Value* actor){
  Function* fun=getEnclosingFunction(actor);

  DominatorTree doms;
  doms.runOnFunction(*fun);

  
  for(Value::use_iterator usit=context->use_begin();usit!=context->use_end();usit++){
    has_at_least_one_use=true;
    
    if((ins=dyn_cast<Instruction>(*usit))&&(fun==ins->getParent()->getParent())){
      crossFunction=false;
      break;
    }
  }
  }*/

/**
 * Expects query shadow and its accompanying update shadow and will decide whether the context is cross-function or not. What should happen based on this decision is up to the caller.
 */
/*static bool is_cross_context(Value* updateShadow,Value* queryShadow,Value* context){
  if(updateShadow==queryShadow){
    

    return true;
  }
  }*/

/*static void print(){
  std::cout << "queryShadowsProcessed (query -> counter):" << std::endl;

  for(multimap<Value*,GlobalVariable*>::iterator it=queryShadowsProcessed.begin();it!=queryShadowsProcessed.end();it++){      
      std::cout << it->first << " => " << it->second << std::endl;
    }
	
	std::cout << "-------" << std::endl
	<< "updateShadowToCounter (update -> counter):" << std::endl;
      
      for(map<Value*,GlobalVariable*>::iterator it=updateShadowToCounter.begin();it!=updateShadowToCounter.end();it++){
	std::cout << it->first << " => " << it->second << std::endl;
      }
	
	std::cout << "-------" << std::endl
	<< "countersToProcess (counter -> update)" << std::endl;
      for(multimap<GlobalVariable*,Value*>::iterator it=countersToProcess.begin();it!=countersToProcess.end();it++){
	std::cout << it->first << " => " << it->second << std::endl;
      }
      }*/

  /**
   * Returns 0 if not processed, 1 if not completely processed (dummy query shadow) and 2 if completely processed.
   */
static bool updateShadowProcessed(multimap<Value*,GlobalVariable*>& updateShadowToCounterProcessed,Value* updateShadow,GlobalVariable* counter){
  pair<multimap<Value*,GlobalVariable*>::iterator,multimap<Value*,GlobalVariable*>::iterator> iterators=updateShadowToCounterProcessed.equal_range(updateShadow);

  if(iterators.first==iterators.second) return false;

  for(multimap<Value*,GlobalVariable*>::iterator it=iterators.first;it!=iterators.second;it++){
    if(it->second==counter){
      return true;
    }
  }

  return false;
}

static void process_call_graph(CallGraphNode* updateShadow,set<CallGraphNode*>& visitedFunctions,vector<Value*>& queryShadows){
  if(!updateShadow) return;

  set<CallGraphNode*>::iterator it=visitedFunctions.find(updateShadow);
  if(it!=visitedFunctions.end()) return;//already visited
  else{
    visitedFunctions.insert(updateShadow);
    Function* fun=updateShadow->getFunction();
    if(fun) queryShadows.push_back(fun);

    //    std::cout << "Visiting ..." << std::endl;
    //    updateShadow->print(std::cout);
    //    std::cout << "..." << std::endl;
    
    if(updateShadow!=callGraph->getExternalCallingNode()){
      for(CallGraphNode::iterator cit=updateShadow->begin();cit!=updateShadow->end();cit++){
	Value* val=cit->first.getInstruction();
	queryShadows.push_back(val);
	process_call_graph(cit->second,visitedFunctions,queryShadows);
      }
    }
  }
}

static void addToResidueMap(Value* shadow,Value* updateShadow){
  map<Value*,vector<Value*> >::iterator it=residueMap.find(shadow);
  if(it!=residueMap.end()){
    it->second.push_back(updateShadow);
  }else{
    vector<Value*> tmp;
    tmp.push_back(updateShadow);
    residueMap.insert(make_pair(shadow,tmp));
  }
}

/**
 * Returns index of context in list of cross-function context parameters. Overwrites previous entries for same \p name.
 */
static int addToCrossFunctionContext(Value* shadow,string& name,Value* context){
  int res=0;
  map<Value*,map<string,Value*> >::iterator it=crossFunctionContext.find(shadow);

  if(it!=crossFunctionContext.end()){
    res=it->second.size();
    (it->second).insert(make_pair(name,context));
  }else{
    map<string,Value*> tmp;
    tmp.insert(make_pair(name,context));
    crossFunctionContext.insert(make_pair(shadow,tmp));
  }

  return res;
}

PREDICATE(decrement_cflow_index, 0)
{ 
  currentCountersIndex--;  
  return TRUE;
}

//erase_cflow_counters_and_stacks(+AspectName,+AdviceName)
//invoked at beginning of match-predicate
PREDICATE(erase_cflow_counters_and_stacks, 2)
{ 
  string aspect((char*)A1);
  string advice((char*)A2);

  if(currentAspect!=aspect || currentAdvice!=advice){
    if(currentAspect.length()>0){
      storeData(currentAspect,currentAdvice);

      currentAspect=aspect;
      currentAdvice=advice;
    }else{
      currentAspect=aspect;
      currentAdvice=advice;
    }

    //  residueMap.clear();
    //  countersToProcess.clear();
    //  updateShadowToCounter.clear();
    //  currentCounters.clear();  
    currentCountersIndex=-1;
    //  queryShadowsProcessed.clear();
    crossFunctionContext.clear();
    //  counterToStack.clear();
  }

  return TRUE;
}

PREDICATE(init_meta_base, 1)
{ 
  metaBase=(MetaFactBase*)((void*)A1);
  return TRUE;
}

PREDICATE(init_call_graph, 1)
{ 
  callGraph=(CallGraph*)((void*)A1);
  return TRUE;
}

void add_type_context(PlTerm& value,char* key,Context* t){  
  switch(value.type()){
  case PL_INTEGER:
    {
      //      PlTermv args(2);
      //      args[0]=value;
      //      bool is_type_pointer=check_query("ptr",args);
      bool is_type_pointer=metaBase->isTypePointer((void*)value);
      //      PlQuery q("ptr", args);
      DEBUG(std::cout << "[TYPE_CONTEXT] Checking whether we have a Type* pointer..." << std::endl);
      //      if( q.next_solution() ){
      if(is_type_pointer){
	//	if(args[1]=="type"){
	  DEBUG(std::cout << "[TYPE_CONTEXT] OK..." << std::endl);
	  DEBUG(std::cout << "Type*" << std::endl);
	  t->insert(key,(Type*)((void*)value));
	  /*      }else{
	  //do nothing
	  DEBUG(std::cout << "[TYPE_CONTEXT] not OK..." << std::endl);
	  }*/
      }else{
	//do nothing
	std::cout << "HELP: should not arrive here for key " << key << " in NativePredicates.cpp, as I expected a Type*!" << std::endl << flush;
	exit(1);
      }
    }
    break;
  default:
    //do nothing
    std::cout << "HELP: should not arrive here for key " << key << " in NativePredicates.cpp, as I expected a Type*!" << std::endl << flush;
    exit(1);
  }
}

void add_context(PlTerm& value,char* key,Context* t,Value* shadow){  
  string keyStr(key);

  switch(value.type()){
  case PL_FLOAT:
    {
      DEBUG(std::cout << "PL_FLOAT" << std::endl);
      Value* v=ConstantFP::get(Type::FloatTy,double(value));
      //v->setName(key);
      t->insert(key,v,Context::CONSTANT);
    }
    break;
  case PL_INTEGER:
    {
      DEBUG(std::cout << "[TYPE_CONTEXT] Checking whether we have a Type* or Value* pointer..." << std::endl);
      map<Value*,vector<Value*> >::iterator resiter=residueMap.find(shadow);
      bool isQueryShadow=(resiter!=residueMap.end());

      if(metaBase->isTypePointer((void*)value)){
	DEBUG(std::cout << "[CONTEXT] OK..." << std::endl);
	DEBUG(std::cout << "Type*" << std::endl);
	t->insert(key,(Type*)((void*)value));
      }else if(metaBase->isValuePointer((void*)value)){
	DEBUG(std::cout << "[CONTEXT] OK..." << std::endl);
	DEBUG(std::cout << "Value*" << std::endl);
	Value* val=(Value*)((void*)value);
	
	//detection of cross-advice context, i.e. context possibly used by more than one advice on same join point shadow, not including method args, call actuals and/or constants
	//we will put this kind of context in a struct and pass it to all advice, as the place of its use more than likely lies outside its original scope
	if(dyn_cast<Constant>(val)){
	  t->insert(key,val,Context::CONSTANT);
	}else if(dyn_cast<GlobalValue>(val)){
	  t->insert(key,val,Context::GLOBAL);
	}else if(dyn_cast<Argument>(val)){
	  int index_of_argument=0;
	  Argument* tmp=cast<Argument>(val);
	  
	  Function* parent=tmp->getParent();
	  bool found=false;
	  for(Function::arg_iterator argiter=parent->arg_begin();argiter!=parent->arg_end();argiter++){
	    if(tmp==&*argiter){
	      found=true;
	      break;
	    }else index_of_argument++;
	  }
	  
	  if(!found){
	    std::cout << "Checking for Argument context parameter, but Argument does NOT appear in Function's signature..." << endl << flush;
	    exit(1);
	  }
	  
	  bool isCrossFunction=false;
	  if(isQueryShadow){
	    Function* funShadow=0;
	    CallInst* callShadow=0;
	    InvokeInst* invokeShadow=0;

	    //first check update shadows
	    //	    map<Value*,vector<GlobalVariable*> >::iterator resiter=residueMap.find(shadow);
	    vector<Value*> updateShadows=resiter->second;
	    for(unsigned int i=0;i<updateShadows.size();i++){
	      Value* updateShadow=updateShadows[i];

	      if(((funShadow=dyn_cast<Function>(updateShadow))&&(parent==funShadow))||((callShadow=dyn_cast<CallInst>(updateShadow))&&(parent==callShadow->getParent()->getParent()))||((invokeShadow=dyn_cast<InvokeInst>(updateShadow))&&(parent==invokeShadow->getParent()->getParent()))){//reachable from update shadow
		isCrossFunction=true;//we should note which update shadow(s) caused this => solution for "where did this context came from"-problem? <--> how to know from which one to peek?
		break;
	      }
	    }

	    if(!isCrossFunction){
	      if(((funShadow=dyn_cast<Function>(shadow))&&(parent==funShadow))||((callShadow=dyn_cast<CallInst>(shadow))&&(parent==callShadow->getParent()->getParent()))||((invokeShadow=dyn_cast<InvokeInst>(shadow))&&(parent==invokeShadow->getParent()->getParent()))) isCrossFunction=false;
	      else isCrossFunction=true;//<--> illegal: can't access this context?
	    }
	  }

	  if(isCrossFunction) t->insert(key,val,Context::CROSSFUNCTION,addToCrossFunctionContext(shadow,keyStr,val));
	  else t->insert(key,val,Context::ARGUMENT,index_of_argument);
	}else{
	  //is it an actual?
	  PlTermv av(4);
	  av[0]=val;
	  
	  bool is_actual=check_query("callActual",av);

	  Instruction* ins=cast<Instruction>(val);

	  if(is_actual){
	    //actual
	    int index_of_actual=int(av[2]);

	    bool isCrossFunction=false;
	    if(isQueryShadow){

	      Function* parent=ins->getParent()->getParent();

	      Function* funShadow=0;
	      CallInst* callShadow=0;
	      InvokeInst* invokeShadow=0;
	      
	      //first check update shadows
	      //	      map<Value*,vector<GlobalVariable*> >::iterator resiter=residueMap.find(shadow);
	      vector<Value*> updateShadows=resiter->second;
	      for(unsigned int i=0;i<updateShadows.size();i++){
		Value* updateShadow=updateShadows[i];
		
		//checking funShadow is not useful in this case
		if(((callShadow=dyn_cast<CallInst>(updateShadow))&&(parent==callShadow->getParent()->getParent()))||((invokeShadow=dyn_cast<InvokeInst>(updateShadow))&&(parent==invokeShadow->getParent()->getParent()))){
		  isCrossFunction=true;//we should note which update shadow(s) caused this => solution for "where did this context came from"-problem? <--> how to know from which one to peek?
		  break;
		}
	      }
	      
	      if(!isCrossFunction){
		if(((funShadow=dyn_cast<Function>(shadow))&&(parent==funShadow))||((callShadow=dyn_cast<CallInst>(shadow))&&(parent==callShadow->getParent()->getParent()))||((invokeShadow=dyn_cast<InvokeInst>(shadow))&&(parent==invokeShadow->getParent()->getParent()))) isCrossFunction=false;
		else isCrossFunction=true;//<--> illegal: can't access this context?
	      }
	    }

	    if(isCrossFunction) t->insert(key,val,Context::CROSSFUNCTION,addToCrossFunctionContext(shadow,keyStr,val));
	    else t->insert(key,val,Context::ACTUAL,index_of_actual);
	  }else{
	    /*CHECK if shadow is in same scope as val or no scope yet (parent==0, hence join point property): if so, CROSSADVICE, otherwise stack
	      <--> if parent==0 and property will be in scope of update shadow: ERROR!!!*/
	    bool isCrossFunction=false;
	    BasicBlock* tmpPar=ins->getParent();
	    bool has_at_least_one_use=((tmpPar==0)&&(val->getNumUses()>0));//introduced AllocaInst is associated with Function, but has no uses

	    Function* parent=(tmpPar)?ins->getParent()->getParent():0;

	    if(has_at_least_one_use && isQueryShadow){
	      Function* funShadow=0;
	      CallInst* callShadow=0;
	      InvokeInst* invokeShadow=0;
	      
	      //first check update shadows
	      //	      map<Value*,vector<GlobalVariable*> >::iterator resiter=residueMap.find(shadow);
	      vector<Value*> updateShadows=resiter->second;
	      for(unsigned int i=0;i<updateShadows.size();i++){
		Value* updateShadow=updateShadows[i];
		
		if(((funShadow=dyn_cast<Function>(updateShadow))&&(parent==funShadow))||((callShadow=dyn_cast<CallInst>(updateShadow))&&(parent==callShadow->getParent()->getParent()))||((invokeShadow=dyn_cast<InvokeInst>(updateShadow))&&(parent==invokeShadow->getParent()->getParent()))){
		  isCrossFunction=true;//we should note which update shadow(s) caused this => solution for "where did this context came from"-problem? <--> how to know from which one to peek?
		  break;
		}
	      }
	      
	      if(!isCrossFunction){
		if(((funShadow=dyn_cast<Function>(shadow))&&(parent==funShadow))||((callShadow=dyn_cast<CallInst>(shadow))&&(parent==callShadow->getParent()->getParent()))||((invokeShadow=dyn_cast<InvokeInst>(shadow))&&(parent==invokeShadow->getParent()->getParent()))) isCrossFunction=false;
		else isCrossFunction=true;//<--> illegal: can't access this context?
	      }
	    }

	    if(has_at_least_one_use && isCrossFunction) t->insert(key,val,Context::CROSSFUNCTION,addToCrossFunctionContext(shadow,keyStr,val));
	    else{ //cross-advice context
	      t->insert(key,val,Context::CROSSADVICE);

	      PlTermv args_term(2);
	      args_term[0]=shadow;
	      args_term[1]=val;

	      do_query("assert_cross_advice_context",args_term,"Asserting cross-advice context fails...");
	    }
	  }
	}
      }else{
	DEBUG(std::cout << "PL_INTEGER" << std::endl);
	Type* type=(Type*)(Type::Int32Ty);
	Value* v=ConstantInt::get(type,int(value));
	t->insert(key,v,Context::CONSTANT);
      }
 
    }
    break;
  case PL_STRING:
    { 
      DEBUG(std::cout << "PL_STRING" << std::endl);
      std::string Str(value);
      std::vector<Constant*> ElementVals;
      for (unsigned i = 0; i < Str.length(); ++i)
	ElementVals.push_back(ConstantInt::get(Type::Int8Ty, Str[i]));
      
      // Add a null terminator to the string...
      ElementVals.push_back(ConstantInt::get(Type::Int8Ty, 0));
      
      //      ArrayType *ATy = ArrayType::get(Type::Int8Ty, 0);//choose length 0, otherwise impossible to know at lookup-time
      ArrayType *ATy = ArrayType::get(Type::Int8Ty, ElementVals.size());
      Value* v=ConstantArray::get(ATy, ElementVals);
      //v->setName(key);
      //      DEBUG(std::cout << "NAME set? " << v->hasName() << std::endl);
      t->insert(key,v,Context::CONSTANT);
    }
    break;
  case PL_ATOM: 
    {
      DEBUG(std::cout << "PL_ATOM" << std::endl);
      //      PlAtom atom(value);
      std::string Str(value);
      std::vector<Constant*> ElementVals;
      for (unsigned i = 0; i < Str.length(); ++i)
	ElementVals.push_back(ConstantInt::get(Type::Int8Ty, Str[i]));
      
      // Add a null terminator to the string...
      ElementVals.push_back(ConstantInt::get(Type::Int8Ty, 0));
      
      //      ArrayType *ATy = ArrayType::get(Type::Int8Ty, 0);//choose length 0, otherwise impossible to know at lookup-time
      ArrayType *ATy = ArrayType::get(Type::Int8Ty, ElementVals.size());
      Value* v=ConstantArray::get(ATy, ElementVals);
      //v->setName(key);
      //      DEBUG(std::cout << "NAME set? " << v->hasName() << std::endl);
      t->insert(key,v,Context::CONSTANT);
    }
    break;
  case PL_TERM: 
    {
      DEBUG(std::cout << "PL_TERM" << std::endl);
      //is it a string disguised as list of ASCII?
      PlTermv av(2);
      av[1]=value;
      
      PlQuery q("string_to_list", av);
      if( q.next_solution() ){
	//string
	std::string Str(av[0]);
	std::vector<Constant*> ElementVals;
	for (unsigned i = 0; i < Str.length(); ++i)
	  ElementVals.push_back(ConstantInt::get(Type::Int8Ty, Str[i]));
	
	// Add a null terminator to the string...
	ElementVals.push_back(ConstantInt::get(Type::Int8Ty, 0));
	
	//      ArrayType *ATy = ArrayType::get(Type::Int8Ty, 0);//choose length 0, otherwise impossible to know at lookup-time
	ArrayType *ATy = ArrayType::get(Type::Int8Ty, ElementVals.size());
	Value* v=ConstantArray::get(ATy, ElementVals);
	//v->setName(key);
	//      DEBUG(std::cout << "NAME set? " << v->hasName() << std::endl);
	t->insert(key,v,Context::CONSTANT);
      }else{
	//ordinary term
	PlTail tail(value);
	PlTerm e;
	
	while(tail.next(e)){
	  add_context(e,key,t,shadow);
	}
      }
    }
    break;
  default:
    if(strcmp(key,"ASPICERE2_rules_fired")){
      std::cout << "HELP: should not arrive here for key " << key << " in NativePredicates.cpp!" << std::endl << flush;
      exit(1);
    }else{
      Type* type=(Type*)(Type::Int32Ty);
      Value* v=ConstantInt::get(type,int(value));
      t->insert(key,v,Context::CONSTANT);
    }
  };
}

PREDICATE(make_context, 4)
{ 
  PlTail tail(A4);
  PlTerm e;
  vector<string>* variables=new vector<string>();
  Context* res=new Context();
  Value* shadow=(Value*)((void*)A1);

  DEBUG(std::cout << "[NATIVEPREDICATES] Entering into make_context/4." << std::endl);

  while(tail.next(e)){
    //    DEBUG(cout << "0" << endl);
    PlTail pair(e);
    //    DEBUG(cout << "1" << endl);
    PlTerm pair_head;
    PlTerm pair_tail;
    pair.next(pair_head);
    //    DEBUG(cout << "2" << endl);
    pair.next(pair_tail);
    //    DEBUG(cout << "3" << endl);
    char* variable_name=(char*)pair_head;
    variables->push_back(string(variable_name));
    DEBUG(std::cout << "[NATIVEPREDICATES] Context variable <" << variable_name << "> ..." << endl);
    //    PlString var(variable_name);
    add_context(pair_tail,variable_name,res,shadow);
    //    DEBUG(std::cout << " OK" << std::endl);
  }

  DEBUG(std::cout << "[NATIVEPREDICATES] Exiting from make_context/4." << std::endl);

  A2=variables;
  A3=res;

  return TRUE;
}

PREDICATE(add_type_context, 4)
{ 
  PlTail tail(A4);
  PlTerm e;
  vector<string>* variables=(vector<string>*)((void*)A2);
  Context* res=(Context*)((void*)A3);

  DEBUG(std::cout << "[NATIVEPREDICATES] Entering into add_type_context/4." << std::endl);

  while(tail.next(e)){
    //    DEBUG(cout << "0" << endl);
    PlTail pair(e);
    //    DEBUG(cout << "1" << endl);
    PlTerm pair_head;
    PlTerm pair_tail;
    pair.next(pair_head);
    //    DEBUG(cout << "2" << endl);
    pair.next(pair_tail);
    //    DEBUG(cout << "3" << endl);
    char* variable_name=(char*)pair_head;
    variables->push_back(string(variable_name));
    DEBUG(std::cout << "[NATIVEPREDICATES] Context variable <" << variable_name << "> ..." << endl);
    //    PlString var(variable_name);
    add_type_context(pair_tail,variable_name,res);
    //    DEBUG(std::cout << " OK" << std::endl);
  }

  DEBUG(std::cout << "[NATIVEPREDICATES] Exiting from add_type_context/4." << std::endl);

  A2=variables;
  A3=res;

  return TRUE;
}

//make_residues(+Jp,?JpSpecificResidueContext,?MiscResidueContext,+Context,?Dummy)
/*PREDICATE(make_residues, 5)
{ 
  //look at residueMap and if counters still in countersToProcess extract them
  Value* queryShadow=(Value*)((void*)A1);
  Context* context=(Context*)((void*)A4);

  //  std::cerr << "RESIDUE for:";
  //  queryShadow->dump();

  map<Value*,vector<Value*> >::iterator resiter=residueMap.find(queryShadow);
  if(resiter!=residueMap.end()){//query shadows
    JoinPoint::ResidueMap* misc_residues=0;

    //  std::cout << "Current shadow:\t" << shadow << std::endl;

    bool isDummyShadow=true;
    bool skipShadow=true;
    //  map<Value*,vector<Value*> >::iterator resiter=residueMap.find(shadow);
    //  if(resiter!=residueMap.end()){//remove duplicate matches for same advice on same (query shadow,update shadow)-pair
    //    duplicateShadow=true;

    vector<Value*> updateShadows=resiter->second;
    for(unsigned int i=0;i<updateShadows.size();i++){
      map<Value*,GlobalVariable*>::iterator tmpiter=updateShadowToCounter.find(updateShadows[i]);
      
      //      std::cout << "Update shadow:\t" << updateShadows[i] << std::endl;
      
      if(tmpiter!=updateShadowToCounter.end()){
	int res=queryShadowProcessed(queryShadow,tmpiter->second);//as long as shadow not handled for at least one counter, we should continue
	//avoid more than one match for same query shadow for one and the same advice if all its required counter query code has been managed and all its update shadows processed
	if(res==0){
	  isDummyShadow=false;
	  skipShadow=false;
	  break;
	}else if(res==1){
	  skipShadow=false;
	}
	//	break;
      }
    }
  

    if(skipShadow){
      std::cout << "Duplicate shadow..." << std::endl;
      return FALSE;
    }
    
    A5=(isDummyShadow)?PlTerm(long(1)):PlTerm(long(0));
 

  //    vector<Value*> updateShadows=resiter->second;
    bool stackUpdateNeeded=false;

    for(vector<Value*>::iterator updateter=updateShadows.begin();updateter!=updateShadows.end();updateter++){//iterate through all update shadows
      map<Value*,GlobalVariable*>::iterator tmpiter=updateShadowToCounter.find(*updateter);
    
      if(tmpiter==updateShadowToCounter.end()) continue;
      
      pair<multimap<GlobalVariable*,Value*>::iterator,multimap<GlobalVariable*,Value*>::iterator> iterators=countersToProcess.equal_range(tmpiter->second);//iterate through all update shadows associated with current update shadow's counter to avoid that removing a redundant query shadows makes an update shadow unreachable, and hence would prevent addition of counter/stack update code

      multimap<GlobalVariable*,Value*>::iterator ot=iterators.first;
      for(;ot!=iterators.second;ot++){//if update shadow of query shadow not yet processed, do this now
	//	if(ot->second==*updateter){
	  if(!misc_residues) misc_residues=new JoinPoint::ResidueMap;
	  misc_residues->push_back(make_pair(ot->second,new CflowCounterUpdateShadowResidueProcessor(ot->first)));

	  if(ot->first==currentCounters[0]) stackUpdateNeeded=true;
	  //	  queryShadowsProcessed.insert(make_pair(queryShadow,ot->first));
	  //	  break;
	  //	}

	//	countersToProcess.erase(ot);//unique identifiers throughout weaving process, so does not need cleanup

	//	std::cerr << "\tmisc:\t";
	//	(*itt)->dump();
	//	val->dump();
      }

      //      if(ot!=iterators.second) countersToProcess.erase(ot);//unique identifiers throughout weaving process, so does not need cleanup; erase after for-loop to avoid problems with iteration
      countersToProcess.erase(iterators.first,iterators.second);//unique identifiers throughout weaving process, so does not need cleanup; erase after for-loop to avoid problems with iteration
    }

    map<Value*,map<string,Value*> >::iterator crossiter=crossFunctionContext.find(queryShadow);
    if(crossiter!=crossFunctionContext.end()){ //found cross-function context (and we assume it's from first cflow, i.e. at most one cflow construct has associated state BECAUSE without Prolog meta-interpreter we cannot know where context originates from, i.e. to which cflow variables are attached!)
	map<string,Value*> crossFunctionContextVars=crossiter->second;
	GlobalVariable* stack=0;
	GlobalVariable* counter=currentCounters[0];

	map<GlobalVariable*,GlobalVariable*>::iterator stackiter=counterToStack.find(counter);
	if(stackiter!=counterToStack.end()){
	  stack=stackiter->second;
	}else{
	  //allocate stack
	  Module* module=getEnclosingModule(queryShadow);
	  const Type* stackType=module->getTypeByName("struct.__ASPICERE2_Stack");
	  stack=new GlobalVariable (stackType, false, GlobalValue::InternalLinkage, Constant::getNullValue(stackType), "stack", module,false);

	  //add stack to counterToStack
	  counterToStack[counter]=stack;
	}

	if(stackUpdateNeeded){
	  //add new misc_residue
	  if(!misc_residues) misc_residues=new JoinPoint::ResidueMap;

	  vector<Value*> processorArgs(crossFunctionContextVars.size());
	  for(multimap<string,Value*>::iterator contextiter=crossFunctionContextVars.begin();contextiter!=crossFunctionContextVars.end();contextiter++){
	    processorArgs[context->index(contextiter->first)]=contextiter->second;
	  } 

	  for(vector<Value*>::iterator updateter=updateShadows.begin();updateter!=updateShadows.end();updateter++){//iterate through all update shadows
	    map<Value*,GlobalVariable*>::iterator tmpiter=updateShadowToCounter.find(*updateter);

	    if((tmpiter!=updateShadowToCounter.end())&& tmpiter->second==counter){
	      misc_residues->push_back(make_pair(*updateter,new CflowStackUpdateShadowResidueProcessor(stack,processorArgs)));
	      break;
	    }
	  }

	}

	//add stack to context
	for(multimap<string,Value*>::iterator contextiter=crossFunctionContextVars.begin();contextiter!=crossFunctionContextVars.end();contextiter++){
	  context->addStack(contextiter->first,stack);
	}	

	//erase this entry: previous query shadow entries did not need to peek from stack, hence their context did not need to be updated
	crossFunctionContext.erase(crossiter);
	
    }

    JoinPoint::ResidueMap* jp_specific_residues=0;
    if(!isDummyShadow){
      //      std::cerr << "\tspecific:\t";
      //      (*itt)->dump();
      //      it->first->dump();      
      set<GlobalVariable*> visitedCounters;
      GlobalVariable* counter=0;
      jp_specific_residues=new JoinPoint::ResidueMap;
      for(vector<Value*>::iterator updateter=updateShadows.begin();updateter!=updateShadows.end();updateter++){//iterate through all update shadows to check all counters
	map<Value*,GlobalVariable*>::iterator tmpiter=updateShadowToCounter.find(*updateter);
	
	if(tmpiter!=updateShadowToCounter.end()){
	  counter=tmpiter->second;
	  if(visitedCounters.find(counter)==visitedCounters.end()){
	    visitedCounters.insert(counter);
	  }
	}
      }
      
      assert(visitedCounters.size()==1 && "ERROR: query shadow corresponding to update shadows of more than one cflow-construct in same pointcut not yet supported!!!");
      jp_specific_residues->push_back(make_pair(queryShadow,new CflowQueryShadowResidueProcessor(counter)));	
      queryShadowsProcessed.insert(make_pair(queryShadow,counter));
    }
    
    residueMap.erase(resiter);//remove this solution's entry <--> problems if something entered into list but no solution found/backtracking!!!

    A2=(void*)jp_specific_residues;
    A3=(void*)misc_residues;
    return TRUE;
}

A2=(void*)0;
A3=(void*)0;
A5=PlTerm(long(0));
  return TRUE;
}*/

//wildcard(pattern,line)
PREDICATE(wildcard,2)
{
  string pattern(((char*)A1));
  string line(((char*)A2));
  const boost::regex e(pattern);

  if(regex_match(line, e)) return TRUE;
  else return FALSE;
}

//type_name(+Type*,?string)
PREDICATE(type_name, 2)
{ 
  Type* type=(Type*)((void*)A1);
  string tName(type->getDescription().c_str());
  PlTerm s(A2);

  switch(s.type()){
  case PL_TERM:
    {
      PlTermv av(2);
      av[1]=s;
      
      PlQuery q("string_to_list", av);
      if( q.next_solution() ){
	//string
	std::string Str(av[0]);
	if(Str==tName) return TRUE;
	else return FALSE;
      }else return FALSE;
    }
    break;
  case PL_STRING:
  case PL_ATOM: 
    { 
      std::string Str(s);
      if(Str==tName) return TRUE;
      else return FALSE;
    }
    break;
  default:
    //unbound variable
    PlString typeName(tName.c_str());
    return A2=typeName;
  };
  //PlString typeName(type->getDescription().c_str());
  //  char* typeName=(char*)type->getDescription().c_str();
  //  return A2=typeName;
  return FALSE;
}

//string_or_atom_or_char_list_to_atom(+Value*,?atom)
PREDICATE(value_to_atom, 2)
{
  PlTerm s(A1);
  char* res=0;

  switch(s.type()){
  case PL_INTEGER:
    {
	ConstantArray* val=(ConstantArray*)((void*)s);
	val->dump();
	res=(char*)(val->getAsString()).c_str();
	break;
    }
    default:
      return FALSE;
    }

      return A2=PlAtom(res);
}

//string_or_atom_or_char_list_to_atom(+char*/atom/string,?atom)
PREDICATE(string_or_atom_or_char_list_to_atom, 2)
{ 
  PlTerm s(A1);
  char* res=0;

  switch(s.type()){
  case PL_TERM:
    {
      PlTermv av(2);
      av[1]=s;
      
      PlQuery q("string_to_list", av);
      if( q.next_solution() ){
	//string
	std::string Str(av[0]);
	res=(char*)Str.c_str();
      }else return FALSE;
      //      res=(char*)((void*)s);
    }
    break;
  case PL_INTEGER:
    {
      res=(char*)((void*)s);
    }
    break;
  case PL_STRING:
    { 
      std::string Str(s);
      res=(char*)Str.c_str();
    }
    break;
  case PL_ATOM: 
    {
      std::string Str(s);
      res=(char*)Str.c_str();
    }
    break;
  default:
    return FALSE;
  };

  return A2=PlAtom(res);
}

//is_void_type(+Type*)
PREDICATE(is_void_type, 1)
{ 
  Type* type=(Type*)((void*)A1);
  if(type==Type::VoidTy) return TRUE;
  else return FALSE;
}

//debug_info(+Function*,?DirName,?FileName)
//DEPRECATED: use dinfo(+Value*,?DirName,?FileName,?LineNr,?ColNr)
PREDICATE(debug_info,3)
{
  Function* f=(Function*)((void*)A1);
  DebugAnnotation* d=dynamic_cast<DebugAnnotation*>(f->getAnnotation(DebugAnnotation::debugID));

  A2=d->getDirName().c_str();
  A3=d->getFileName().c_str();

  return TRUE;
}

//dinfo(+Value*,?DirName,?FileName,?LineNr,?ColNr)
PREDICATE(dinfo,5)
{
  Value* val=(Value*)((void*)A1);
  DebugInfo* info=metaBase->getDebugFact(val);

  PlTerm s(A2);

  switch(s.type()){
  case PL_TERM:
    {
      PlTermv av(2);
      av[1]=s;
      
      PlQuery q("string_to_list", av);
      if( q.next_solution() ){
	//string
	std::string Str(av[0]);
	if(Str!=info->dirName) return FALSE;
      }else return FALSE;
    }
    break;
  case PL_STRING:
  case PL_ATOM: 
    { 
      std::string Str(s);
      if(Str!=info->dirName) return FALSE;
    }
    break;
  default:
    //unbound variable
    A2=PlCodeList(info->dirName.c_str());
  };

  PlTerm ss(A3);

  switch(ss.type()){
  case PL_TERM:
    {
      PlTermv av(2);
      av[1]=ss;
      
      PlQuery q("string_to_list", av);
      if( q.next_solution() ){
	//string
	std::string Str(av[0]);
	if(Str!=info->fileName) return FALSE;
      }else return FALSE;
    }
    break;
  case PL_STRING:
  case PL_ATOM: 
    { 
      std::string Str(ss);
      if(Str!=info->fileName) return FALSE;
    }
    break;
  default:
    //unbound variable
    A3=PlCodeList(info->fileName.c_str());
  };

  PlTerm t(A4);

  switch(t.type()){
  case PL_INTEGER:
    {
      int tmp=(int)t;
      if(tmp!=info->lineNr) return FALSE;
    }
    break;
  default:
    A4=info->lineNr;    
  };

  PlTerm tt(A5);

  switch(tt.type()){
  case PL_INTEGER:
    {
      int tmp=(int)tt;
      if(tmp!=info->colNr) return FALSE;
    }
    break;
  default:
    A5=info->colNr;    
  };

  return TRUE;
}

//clone_prototype(-ClonedVariable,+VariableName,+Module*)
PREDICATE(clone_prototype,3)
{
  //  cout << "CLONE_PROTOTYPE" << endl;
  char* variableName=(char*)A2;
  string varName(variableName);
  Module* module=(Module*)((void*)A3);
  GlobalVariable* g=module->getNamedGlobal(varName);
  SequentialType* ty=cast<SequentialType>((Type*)g->getType());
  AllocaInst* res=new AllocaInst(ty->getElementType(),string("intro"));//global variable's type is pointer to actual introduced variable's type

  /*  PlTermv args(2);
  args[0]="value";
  args[1]=res;
  do_query("assert_pointer",args,"Asserting newly allocated variable as a Value* did NOT succeed.");*/
  metaBase->addValuePointer(res);

  return A1=res;
}

//generate_var(-GeneratedVariable,+Type*)
PREDICATE(generate_var,2)
{
  //  cout << "GENERATE_VAR" << endl;
  Type* type=(Type*)((void*)A2);
  AllocaInst* res=new AllocaInst(type,string("intro"));

  /*  PlTermv args(2);
  args[0]="value";
  args[1]=res;
  do_query("assert_pointer",args,"Asserting newly allocated variable as a Value* did NOT succeed.");*/
  metaBase->addValuePointer(res);

  return A1=res;
}

//tie_variable_to_join_point(+ExecutionJp,+ClonedOrGeneratedVariable)
PREDICATE(tie_variable_to_join_point,2)
{
  //  cout << "TIE_VARIABLE_TO_JOIN_POINT" << endl;
  Function* f=(Function*)((void*)A1);
  Value* context=(Value*)((void*)A2);
  CrossAdviceContextAnnotation::addContext(f,context);
  return TRUE;
}

//get_enclosing_module_of_method(+Jp,?Module)
PREDICATE(get_enclosing_module_of_method,2)
{
  //  cout << "GET_ENCLOSING_MODULE_OF_METHOD" << endl;
  Function* f=(Function*)((void*)A1);
  return A2=f->getParent();
}

//ptr_type(+Type,?PtrType)
PREDICATE(ptr_type,2)
{
  //  cout << "GET_ENCLOSING_MODULE_OF_METHOD" << endl;
  const Type* t=(const Type*)((void*)A1);
  Type* res=PointerType::get(t);

  metaBase->addTypePointer(res);
  /*  PlTermv args(2);
  args[0]="type";
  args[1]=res;
  do_query("assert_pointer",args,"Asserting pointer type as a Type* did NOT succeed.");*/

  return A2=res;
}

//type_of_value(+JpID,?Type)
PREDICATE(type_of_value,2)
{
  Type* res=0;
  PlTerm value(A1);

  switch(value.type()){
  case PL_FLOAT:
    {
      DEBUG(std::cout << "PL_FLOAT" << std::endl);
      res=(Type*)(Type::FloatTy);
    }
    break;
  case PL_INTEGER:
    {
      /*      PlTermv args(2);
      args[0]=value;
      bool is_ptr=check_query("ptr",args);*/
      //      PlQuery q("ptr", args);
      DEBUG(std::cout << "[TYPE_CONTEXT] Checking whether we have a Type* or Value* pointer..." << std::endl);
      //      if( q.next_solution() ){
      //      if(is_ptr){
      //	if(args[1]=="type"){
      if(metaBase->isTypePointer((void*)value)){
	DEBUG(std::cout << "Type*" << std::endl);
	return A2=res;//Type representing Type does NOT exist :-(
	//	}else if(args[1]=="value"){
      }else if(metaBase->isValuePointer((void*)value)){
	DEBUG(std::cout << "Value*" << std::endl);
	Value* val=(Value*)((void*)value);
	res=((Type*)val->getType());
	/*	}else{
	//do nothing
	DEBUG(std::cout << "What is this?..." << std::endl);
	return A2=res;//Type representing Type does NOT exist :-(
	}*/
      }else{
	DEBUG(std::cout << "PL_INTEGER" << std::endl);
	res=(Type*)(Type::Int32Ty);
      }
    }
    break;
  case PL_STRING:
    { 
      DEBUG(std::cout << "PL_STRING" << std::endl);
      res=PointerType::get(Type::Int8Ty);
    }
    break;
  case PL_ATOM: 
    {
      DEBUG(std::cout << "PL_ATOM" << std::endl);
      res=PointerType::get(Type::Int8Ty);
    }
    break;
  case PL_TERM: 
    {
      //is it a string disguised as list of ASCII?
      PlTermv av(2);
      av[1]=value;
      
      PlQuery q("string_to_list", av);
      if( q.next_solution() ){
	DEBUG(std::cout << "string-list" << std::endl);
	res=PointerType::get(Type::Int8Ty);
      }else{
	DEBUG(std::cout << "List" << std::endl);
	return A2=res;
      }
    }
    break;
  default:
    //do nothing
    DEBUG(std::cout << "HELP: should not arrive here in NativePredicates.cpp line 628!" << std::endl);
    return A2=res;
    break;
  };

  /*  PlTermv args(2);
  args[0]="type";
  args[1]=res;
  do_query("assert_pointer",args,"Asserting pointer type as a Type* did NOT succeed.");*/
  metaBase->addTypePointer(res);

  return A2=res;
}

//called_function(+Jp,?Function)
PREDICATE(called_function,2)
{
  CallInst* f=(CallInst*)((void*)A1);
  return A2=f->getCalledFunction();
}

static void traverse(Value* v,PlTermv& fact_term){
  set<CallGraphNode*> visitedFunctions;
  vector<Value*> queryShadows;

  std::cout << "Starting to process call graph..." << std::endl;
  Function* f=0;
  CallInst* c=0;
  if((c=dyn_cast<CallInst>(v))){
    f=c->getCalledFunction();
    queryShadows.push_back(c);//registering in visitedFunctions is redundant (once called Function is reached, algorithm will stop)
  }else f=dyn_cast<Function>(v);
  CallGraphNode* node=(*callGraph)[f];
  process_call_graph(node,visitedFunctions,queryShadows);
  std::cout << "DONE" << std::endl;

  //TODO: optimise here (must, may and ...)

  int nr_of_query_shadows=queryShadows.size();
  currentCountersIndex++;

  GlobalVariable* counter=0;
  if(nr_of_query_shadows>0){//could be obsolete if extra condition next to cflow in pcd decides there is no join point in cflow <--> will be cleaned up as there are no uses!!!
    if(currentCountersIndex==(int)currentCounters.size()){//did not allocate counter and stack yet
      counter=new GlobalVariable(Type::Int32Ty,false,GlobalValue::InternalLinkage,ConstantInt::get(Type::Int32Ty,0),"counter",f->getParent(),false);//thread local does not work yet on OSX and gives errors!!!
      currentCounters.push_back(counter);
    }else{
      counter=currentCounters[currentCountersIndex];
    }

    countersToProcess.insert(make_pair(counter,v));
    updateShadowToCounter.insert(make_pair(v,counter));//TODO: mapping of update shadow to positive/negative-ness cflow check?
    //associate counter to update shadow by instantiating processors
    //associate processors to update shadow and query shadows (static multimap in this .cpp file, assert and retract facts, modify ac2c.pl, ... <--> LOOK OUT: some query shadows will be ruled out by e.g. "&& invocation(QueryJp,_)")
    //separate residuer-pass after weaving
  }

  PlTail ta(fact_term[0]);
  for(int i=0;i<nr_of_query_shadows;i++){
    ta.append((void*)queryShadows[i]);
    addToResidueMap(queryShadows[i],v);
  }

  ta.close();
}

//traverse_call_graph_from_function(+Function,?List)
PREDICATE(traverse_call_graph_from_function,2)
{
  Function* f=(Function*)((void*)A1);
  PlTermv fact_term(1);

  traverse(f,fact_term);

  return A2=PlCompound("res",fact_term);
}

//traverse_call_graph_from_function(+Function,?List)
PREDICATE(traverse_call_graph_from_call,2)
{
  CallInst* f=(CallInst*)((void*)A1);
  PlTermv fact_term(1);

  traverse(f,fact_term);

  return A2=PlCompound("res",fact_term);
}

void make_residues(std::vector<Director*>* matches){
  bool firstIteration=true;
  string current_advice_name("");
  string current_aspect_name("");
  vector<JoinPoint*> jpsOfOneAdvice;

  if(currentAspect.length()>0) storeData(currentAspect,currentAdvice);//not backed up during last match

  print2(matches);

  unsigned int nr_of_matches=matches->size();

  for(unsigned int i=0;i<=nr_of_matches;i++){//iterate up to size of matches to make sure that last group gets treated as well!
    JoinPoint* jp=0;
    bool lastIteration=(i==nr_of_matches);
    if(!lastIteration) jp=(*matches)[i]->getJoinPoint();
    string advice=(jp)?jp->getAdviceName():"";
    string aspect=(jp)?jp->getAspectName():"";

    if((jp && current_aspect_name==aspect && current_advice_name==advice)||(firstIteration)){
      jpsOfOneAdvice.push_back(jp);
      firstIteration=false;
    }else{
      //process data join points matched in previous aspect/advice combination iterations
      string adviceID=current_aspect_name+"#"+current_advice_name;
      map<string,map<Value*,vector<Value*> > >::iterator it=adviceToResidueMap.find(adviceID);
      if(it!=adviceToResidueMap.end()){//there are shadows with residues for this advice
	set<Value*> visitedShadows;
	map<Value*,vector<Value*> > residueMap=it->second;//query shadow to list of update shadows
	map<Value*,GlobalVariable*> updateShadowToCounter=adviceToUpdateShadowToCounter[adviceID];
	multimap<Value*,GlobalVariable*> updateShadowToCounterProcessed;
	multimap<GlobalVariable*,Value*> countersToProcess=adviceToCountersToProcess[adviceID];
	vector<GlobalVariable*> currentCounters=adviceToCurrentCounters[adviceID];
	map<GlobalVariable*,GlobalVariable*> counterToStack;//initially empty --> should this be visible across all advice in this function?

	print(jpsOfOneAdvice);	
	for(unsigned int advicej=0;advicej<jpsOfOneAdvice.size();advicej++){
	  jp=jpsOfOneAdvice[advicej];
	  
	  //look at residueMap and if counters still in countersToProcess extract them
	  Value* queryShadow=jp->getShadow();
	  Context* context=jp->getContext();
	  
	  map<string,Value*> crossFunctionContextVars;
	  //iterate through context of all join points to obtain names of common cross function context to avoid that some shadow will only push one thing, while others need more
	  //<--> first: trust that this problem does not occur
	  for(Context::v_iterator contextiter=context->v_begin();contextiter!=context->v_end();contextiter++){
	    if(contextiter->second.second==Context::CROSSFUNCTION) crossFunctionContextVars[contextiter->first]=contextiter->second.first;
	  }
	  
	  if(visitedShadows.find(queryShadow)!=visitedShadows.end()){
	    jp->setDummy(true);//no miscellaneous residues to check anymore, so this join point is actually disabled!
	    continue;
	  }else visitedShadows.insert(queryShadow);
	  
	  map<Value*,vector<Value*> >::iterator resiter=residueMap.find(queryShadow);//query shadow can be shadow in more than one advice
	  if(resiter!=residueMap.end()){//query shadows
	    JoinPoint::ResidueMap* misc_residues=0;
	    
	    vector<Value*> updateShadows=resiter->second;
	    //	      bool stackUpdateNeeded=false;
	    
	    for(vector<Value*>::iterator updateter=updateShadows.begin();updateter!=updateShadows.end();updateter++){//iterate through all update shadows
	      map<Value*,GlobalVariable*>::iterator tmpiter=updateShadowToCounter.find(*updateter);
	      
	      assert(tmpiter!=updateShadowToCounter.end() && "Strange, no counter associated to update shadow...");
	      
	      pair<multimap<GlobalVariable*,Value*>::iterator,multimap<GlobalVariable*,Value*>::iterator> iterators=countersToProcess.equal_range(tmpiter->second);//iterate through all update shadows associated with current update shadow's counter to avoid that removing a redundant query shadow makes an update shadow unreachable, and hence would prevent addition of counter/stack update code
	      
	      multimap<GlobalVariable*,Value*>::iterator ot=iterators.first;
	      for(;ot!=iterators.second;ot++){//if update shadow of query shadow not yet processed, do this now
		if(ot->second==*updateter){
		  if(!misc_residues) misc_residues=new JoinPoint::ResidueMap;
		  misc_residues->push_back(make_pair(ot->second,new CflowCounterUpdateShadowResidueProcessor(ot->first)));
		  break;
		}		
	      }
	      
	      if(ot!=iterators.second) countersToProcess.erase(ot);//unique identifiers throughout weaving process, so does not need cleanup; erase after for-loop to avoid problems with iteration
	      //countersToProcess.erase(iterators.first,iterators.second);//unique identifiers throughout weaving process, so does not need cleanup; erase after for-loop to avoid problems with iteration
	    }
	    
	    //map<Value*,map<string,Value*> >::iterator crossiter=crossFunctionContext.find(queryShadow);
	    if(crossFunctionContextVars.size()>0){
	      //    if(crossiter!=crossFunctionContext.end()){ //found cross-function context (and we assume it's from first cflow, i.e. at most one cflow construct has associated state BECAUSE without Prolog meta-interpreter we cannot know where context originates from, i.e. to which cflow variables are attached!)
	      //		map<string,Value*> crossFunctionContextVars=crossiter->second;
	      GlobalVariable* stack=0;
	      GlobalVariable* counter=currentCounters[0];
	      
	      map<GlobalVariable*,GlobalVariable*>::iterator stackiter=counterToStack.find(counter);
	      if(stackiter!=counterToStack.end()){
		stack=stackiter->second;
	      }else{
		//allocate stack
		Module* module=getEnclosingModule(queryShadow);
		const Type* stackType=module->getTypeByName("struct.__ASPICERE2_Stack");
		stack=new GlobalVariable (stackType, false, GlobalValue::InternalLinkage, Constant::getNullValue(stackType), "stack", module,false);
		
		//add stack to counterToStack
		counterToStack[counter]=stack;
	      }


	      std::cout << "[" << queryShadow << "] Stack for counter: " << stack << " -> " << counter << std::endl;
	      for(vector<Value*>::iterator updateter=updateShadows.begin();updateter!=updateShadows.end();updateter++){//iterate through all update shadows
		map<Value*,GlobalVariable*>::iterator tmpiter=updateShadowToCounter.find(*updateter);
		
		if((tmpiter!=updateShadowToCounter.end())){
		  std::cout << "Update shadow " << tmpiter->first << " -> " << tmpiter->second << std::endl;
		}
	      }
	      
	      /*	bool stackUpdateNeeded=false;
			for(unsigned int i=0;i<updateShadows.size();i++){
			map<Value*,GlobalVariable*>::iterator tmpiter=updateShadowToCounter.find(updateShadows[i]);
			
			if((tmpiter!=updateShadowToCounter.end())&&(tmpiter->second==counter)){
			stackUpdateNeeded=true;
			break;
			}
			}*/
	      
	      //	if(stackUpdateNeeded){
	      //add new misc_residue
	      if(!misc_residues) misc_residues=new JoinPoint::ResidueMap;
	      
	      //compose context data to be pushed on stack
	      vector<Value*> processorArgs(crossFunctionContextVars.size());
	      for(multimap<string,Value*>::iterator contextiter=crossFunctionContextVars.begin();contextiter!=crossFunctionContextVars.end();contextiter++){
		processorArgs[context->index(contextiter->first)]=contextiter->second;
	      } 
	      
	      for(vector<Value*>::iterator updateter=updateShadows.begin();updateter!=updateShadows.end();updateter++){//iterate through all update shadows
		map<Value*,GlobalVariable*>::iterator tmpiter=updateShadowToCounter.find(*updateter);
		
		if((tmpiter!=updateShadowToCounter.end())&& tmpiter->second==counter && !updateShadowProcessed(updateShadowToCounterProcessed,*updateter,counter)){
		  Value* updateShadow=*updateter;

		  for(vector<Value*>::iterator argsiter=processorArgs.begin();argsiter!=processorArgs.end();argsiter++){
		    Value* val=*argsiter;
		    Argument* arg=0;

		    if((arg=dyn_cast<Argument>(val))){
		      int index_of_argument=0;
		      
		      Function* parent=arg->getParent();
		      for(Function::arg_iterator argiter=parent->arg_begin();argiter!=parent->arg_end();argiter++){
			if(arg==&*argiter){
			  break;
			}else index_of_argument++;
		      }

		      Function* funShadow=0;
		      CallInst* callShadow=0;
		      InvokeInst* invokeShadow=0;

		      if((funShadow=dyn_cast<Function>(updateShadow))){
			if(parent!=funShadow){//take updateShadow's nth actual
			  Function::arg_iterator funargit=funShadow->arg_begin();
			  for(int k=0;k<index_of_argument;k++) funargit++;
			  *argsiter=&(*funargit);
			}
		      }else if((callShadow=dyn_cast<CallInst>(updateShadow))){
			if(parent!=callShadow->getParent()->getParent()){//take updateShadow's nth actual
			  *argsiter=callShadow->getOperand(index_of_argument+1);
			}
		      }else if((invokeShadow=dyn_cast<InvokeInst>(updateShadow))){
			if(parent!=invokeShadow->getParent()->getParent()){////reachable from update shadow
			  *argsiter=invokeShadow->getOperand(index_of_argument+1);
			}
		      }//else: everything OK?
		    }else{
		      //is it an actual?
		      PlTermv av(4);
		      av[0]=val;
	  
		      bool is_actual=check_query("callActual",av);

		      if(is_actual){
			//			Instruction* ins=cast<Instruction>(val);
			//			Function* parent=ins->getParent()->getParent();
			int index_of_actual=int(av[2]);
			
			CallInst* callShadow=0;
			InvokeInst* invokeShadow=0;

			if((callShadow=dyn_cast<CallInst>(updateShadow))){
			  //this will NOT work if the actual should not be the update shadow's one, but rather a previous (in the same Function I mean) call's actuals; in that case, one should use the dominator tree
			  //			  if(parent!=callShadow->getParent()->getParent()){//take updateShadow's nth actual
			    *argsiter=callShadow->getOperand(index_of_actual+1);
			    //			  }
			}else if((invokeShadow=dyn_cast<InvokeInst>(updateShadow))){
			  //idem
			  //			  if(parent!=invokeShadow->getParent()->getParent()){////reachable from update shadow
			    *argsiter=invokeShadow->getOperand(index_of_actual+1);
			    //			  }
			}//else: everything OK?
		      }//else assume everything is OK
		    }
		  } 

		  misc_residues->push_back(make_pair(*updateter,new CflowStackUpdateShadowResidueProcessor(stack,processorArgs)));
		  updateShadowToCounterProcessed.insert(make_pair(*updateter,counter));
		  std::cout << "[FINISHED] Update shadow " << tmpiter->first << " -> " << tmpiter->second << std::endl;
		  //		  break;//problem: processing all update shadows <--> giving them context they can reach (e.g.: Argument* of query shadow could be invisible to one of its update shadows => there, it should be 1st actual instead e.g.)
		}
	      }
	      
	      //add stack to context
	      for(multimap<string,Value*>::iterator contextiter=crossFunctionContextVars.begin();contextiter!=crossFunctionContextVars.end();contextiter++){
		context->addStack(contextiter->first,stack);
	      }	
	      
	    }
	    
	    //erase this entry: previous query shadow entries did not need to peek from stack, hence their context did not need to be updated
	    //	crossFunctionContext.erase(crossiter);
	    
	    //    }
	    
	    JoinPoint::ResidueMap* jp_specific_residues=0;
	    //	      if(!isDummyShadow){
	    //      std::cerr << "\tspecific:\t";
	    //      (*itt)->dump();
	    //      it->first->dump();      
	    set<GlobalVariable*> visitedCounters;
	    GlobalVariable* counter=0;
	    jp_specific_residues=new JoinPoint::ResidueMap;
	    for(vector<Value*>::iterator updateter=updateShadows.begin();updateter!=updateShadows.end();updateter++){//iterate through all update shadows to check all counters
	      map<Value*,GlobalVariable*>::iterator tmpiter=updateShadowToCounter.find(*updateter);
	      
	      if(tmpiter!=updateShadowToCounter.end()){
		counter=tmpiter->second;
		  if(visitedCounters.find(counter)==visitedCounters.end()){
		    visitedCounters.insert(counter);
		  }
	      }
	    }
	    
	    assert(visitedCounters.size()==1 && "ERROR: query shadow corresponding to update shadows of more than one cflow-construct in same pointcut in one advice not yet supported!!!");
	    jp_specific_residues->push_back(make_pair(queryShadow,new CflowQueryShadowResidueProcessor(counter)));	
	    //queryShadowsProcessed.insert(make_pair(queryShadow,counter));
	    //residueMap.erase(resiter);//remove this solution's entry <--> problems if something entered into list but no solution found/backtracking!!!

	    jp->setResidues(jp_specific_residues);
	    jp->setMiscResidues(misc_residues);
	  }
	 
	}
      }
      
      //clean up
      jpsOfOneAdvice.clear();
      if(!lastIteration){
	jpsOfOneAdvice.push_back((*matches)[i]->getJoinPoint());
      }
    }

    current_aspect_name=aspect;
    current_advice_name=advice;
  } 
}

PREDICATE(dereference,2)
{
  Instruction* oldReturnAlloca=(Instruction*)((void*)A1);
  //  LoadInst* newReturnValue=0;
  //  LoadInst* tmpReturnValue=0;
  Instruction* res=0;

  //  if((newReturnValue=dyn_cast<LoadInst>(getNextNextInstruction(oldReturnAlloca)))&&(newReturnValue->getPointerOperand()==oldReturnAlloca)){
  //    if(!((tmpReturnValue=dyn_cast<LoadInst>(getNextNextNextInstruction(oldReturnAlloca)))&&(tmpReturnValue->getPointerOperand()==oldReturnAlloca))){
  res=new LoadInst(oldReturnAlloca,create_unique_name("dummie"),getNextInstruction(getNextStoreInstruction(oldReturnAlloca)));
  metaBase->addValuePointer(res);
      //    }else res=newReturnValue;
      //  }else{
      //    Instruction* locationBeforeWhichToWeave=getNextNextInstruction(oldReturnAlloca);
      //    res=new LoadInst(oldReturnAlloca,"retval",locationBeforeWhichToWeave);
      //    new LoadInst(oldReturnAlloca,"tmp",locationBeforeWhichToWeave);
      //
      //    metaBase->addValuePointer(res);
      //  }

  return A2=res;//load behind store
}

/*Store return value A1 into A2 (which is pointer to the return value).*/
PREDICATE(store_return_value_into_var,2)
{
  Instruction* shadow=(Instruction*)((void*)A1);
  init_markers(shadow);
  Instruction* locationBeforeWhichToWeave=Munger::getContextMarker(shadow);//getNextInstruction(shadow);

  //  AllocaInst* oldReturnAlloca=0;
  //  StoreInst* oldReturnStore=0;
  AllocaInst* res=0;
  
  //if there is already an appropriate alloc - store - load behind the shadow, use this
  //  if((oldReturnAlloca=dyn_cast<AllocaInst>(locationBeforeWhichToWeave))&&(oldReturnStore=dyn_cast<StoreInst>(getNextInstruction(locationBeforeWhichToWeave)))&&(oldReturnAlloca->getAllocatedType()==shadow->getType())&&(oldReturnStore->getOperand(0)==shadow)&&(oldReturnStore->getOperand(1)==oldReturnAlloca)){
    //found right instructions
  //    res=oldReturnAlloca;
  //  }else{
  res=new AllocaInst((Type*)shadow->getType(),"retval",locationBeforeWhichToWeave);
  new StoreInst(shadow,res,locationBeforeWhichToWeave);
  //  }

  metaBase->addValuePointer(res);

  return A2=res;
}

/*Get pointer to local variable in scope of A1 with name A2.*/
PREDICATE(get_local_variable_ref_native,3)
{
  Instruction* shadow=(Instruction*)((void*)A1);
  string variableName=string((char*)A2);

  Function* fun=shadow->getParent()->getParent();
  AllocationInst* var=0;
  for(Function::iterator it=fun->begin();it!=fun->end();it++){
    BasicBlock* bb=&(*it);

    for(BasicBlock::iterator itt=bb->begin();itt!=bb->end();itt++){
      if((var=dyn_cast<AllocationInst>(&(*itt)))){
	if(variableName==var->getName()){
	  metaBase->addValuePointer(var);
	  return A3=var;
	}
      }
    }
  }

  return FALSE;
}

