/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Aspicere2.
 *
 * The Initial Developer of the Original Code is
 * the Ghislain Hoffman Software Engineering Lab, INTEC, University Ghent.
 * Portions created by the Initial Developer are Copyright (C) 2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Bram Adams <bram_DOT_adams_AT_ugent_DOT_be>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "matcher/CallDirector.h"
#include "matcher/ContinuationDirector.h"
#include "matcher/ExecutionDirector.h"
#include "matcher/JoinPoint.h"
#include "stripdebug/DebugAnnotation.h"
#include "utility/Cloning.h"
#include "weaver/BodyExtracter.h"
#include "weaver/Munger.h"
#include "llvm/Analysis/Dominators.h"
#include "llvm/Function.h"
#include "llvm/Instructions.h"
#include "llvm/IntrinsicInst.h"
#include "llvm/Module.h"
//#include "llvm/SymbolTable.h"
#include "llvm/Transforms/Utils/Cloning.h"
#include "llvm/Transforms/Utils/FunctionUtils.h"
#include "llvm/../../lib/Transforms/Utils/ValueMapper.h"
#include <iostream>
#include <sstream>

using namespace std;
using namespace llvm;

namespace{
  const string create_unique_name(const string& name){
    int counter=Munger::getUniqueInteger();
    stringstream ss;
    ss << name << "_" << counter;
    return ss.str();
  }

  CallInst* getCallToExtractedFunction(Function* oldFunction,std::map<llvm::Function*,llvm::CallInst*>& functions_extracted){
      std::map<llvm::Function*,llvm::CallInst*>::iterator itt=functions_extracted.find(oldFunction);
      if(itt==functions_extracted.end()){//haven't processed this Function yet, so extract it
	std::map<Value*, Value*> ValueMap;

	//1. extract everything into new Function F in module M + switch names for readibility
	Function* F=cloneFunctionSignature(oldFunction,ValueMap,false,true);
	string oldName(oldFunction->getName());
	/*if(oldName=="main"){
	  Munger::aliasMainMethod(oldFunction,F);
	  }*/
	string newName(string("ASPICERE2_EXTRACTED_")+oldName);
	F->setName(newName);
	//oldFunction->setName(newName);
	//F->setName(oldName);

	DebugAnnotation* d=dynamic_cast<DebugAnnotation*>(oldFunction->getAnnotation(DebugAnnotation::debugID));
	if(d){//why d? if(d){/*non-stdlib function*/}else{/*stdlib-function*/}
	  F->addAnnotation(new DebugAnnotation(d->getDirName(),d->getFileName()));
	}else{//stdlib-functions
	  F->addAnnotation(new DebugAnnotation(string("system-dependent"),string("system-dependent")));
	}
	std::cout << "[EXTRACTER] Extracting " << oldName << " to " << newName << endl;

	transferBasicBlocks(F,oldFunction,ValueMap);

	//2. add call C from old function to new F
	CallInst* C=addCallFromTo(oldFunction,F);

	//	insertCrossAdviceContext(oldFunction);

	//CallInst* C=cast<CallInst>(F->use_begin());
	functions_extracted.insert(make_pair(oldFunction,C));
	return C;
      }else{//already encountered Function, so reuse CallInst*
	return itt->second;
      }
  }
}

void BodyExtracter::extract(std::vector<Director*>& matches){
  for(std::vector<Director*>::iterator it=matches.begin();it!=matches.end();it++){
    Director* dir=0;
    JoinPoint* jp=(*it)->getJoinPoint();

    //the residue can contain code to be executed on other shadow (e.g. update shadow of cflow should be modified once), but if this is a Function, then it should be remapped to the extracted call
    JoinPoint::ResidueMap* residues=jp->getMiscResidues();
    if(residues){
      Function* fun=0;
      for(JoinPoint::ResidueMap::iterator iter=residues->begin();iter!=residues->end();iter++){
	Value* tmp=iter->first;
	if((fun=dynamic_cast<Function*>(tmp))){
	  iter->first=getCallToExtractedFunction(fun,functions_extracted);
	}
      }
    }

    if((dir=(dynamic_cast<ExecutionDirector*>(*it)))||((dir=(dynamic_cast<ContinuationDirector*>(*it)))&&(dynamic_cast<Function*>(dir->getJoinPoint()->getShadow())))){
      Function* oldFunction=static_cast<Function*>(jp->getShadow());
      CallInst* C=getCallToExtractedFunction(oldFunction,functions_extracted);
   
      /*      std::pair<std::multimap<llvm::Value*,std::pair<llvm::Value*,int> >::iterator,std::multimap<llvm::Value*,std::pair<llvm::Value*,int> >::iterator> test=Munger::getCrossAdviceContext(jp->getShadow());
      for(std::multimap<llvm::Value*,std::pair<llvm::Value*,int> >::iterator ittt=test.first;ittt!=test.second;ittt++){
	cout << "BB" << ittt->first << " -> " << ittt->second.first << " (" << ittt->second.second << ")" << endl;
	}*/

      //Replace old shadow by new one in cross-advice context
      Munger::updateCrossAdviceContext(jp->getShadow(),C);
      Munger::eraseMarkers(jp->getShadow());

      //3. change jp's shadow to C
      jp->setShadow(C);

      if(dynamic_cast<ExecutionDirector*>(dir)){
	//4. clone dir to CallDirector D
	dir->setJoinPoint(0);
	CallDirector* D=new CallDirector(jp);
	
	//5. replace *it by D
	*it=D;
	
	//6. delete dir
	delete dir;
      }
    }
  }
}
