/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Aspicere2.
 *
 * The Initial Developer of the Original Code is
 * the Ghislain Hoffman Software Engineering Lab, INTEC, University Ghent.
 * Portions created by the Initial Developer are Copyright (C) 2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Bram Adams <bram_DOT_adams_AT_ugent_DOT_be>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "matcher/Context.h"
#include "stripdebug/DebugAnnotation.h"
#include "utility/Cloning.h"
#include "utility/Naming.h"
#include "utility/Util.h"
#include "weaver/CallMunger.h"
#include "weaver/Utils.h"
#include "llvm/DerivedTypes.h"
#include "llvm/Instructions.h"
#include "llvm/Module.h"
#include "llvm/Transforms/Utils/Cloning.h"
#include "llvm/Type.h"
#include <iostream>
#include <sstream>

using namespace std;
using namespace llvm;

namespace{
  //when after_returning calls are woven, either the direct return value should be passed as an argument to the advice (after storing it in alloca-ed variable), or the alloca-ed variable introduced by previous after_returning calls
  map<CallInst*,Instruction*> after_returning_call_to_allocad_return_value,after_returning_call_to_load_of_return_value;

  Instruction* getAllocadReturnValue(CallInst* call){
    map<CallInst*,Instruction*>::iterator it=after_returning_call_to_allocad_return_value.find(call);
    if(it!=after_returning_call_to_allocad_return_value.end()) return it->second;
    else return 0;
  }

  Instruction* getLoadOfReturnValue(CallInst* call){
    map<CallInst*,Instruction*>::iterator it=after_returning_call_to_load_of_return_value.find(call);
    if(it!=after_returning_call_to_load_of_return_value.end()) return it->second;
    else return 0;
  }

  void setAllocadAndLoadOfReturnValue(CallInst* call,Instruction* returnValue,Instruction* load){
    after_returning_call_to_allocad_return_value[call]=returnValue;
    after_returning_call_to_load_of_return_value[call]=load;
  }

  Function* extractProceedStub(CallInst* shadow,Function* enclosingFunction){
    bool join_point_struct_needed=(Munger::isCallToExtractedMethod(shadow))?false:true;
    Function* proceed_stub=cloneFunctionSignatureFromCall(shadow,create_unique_name(string("proceed")),(Type*) (shadow->getCalledFunction()->getReturnType()),join_point_struct_needed);//don't clone proceed-call itself, as it has NO args!!! + we need a joinpoint struct as first argument
    DebugAnnotation* d=dynamic_cast<DebugAnnotation*>(enclosingFunction->getAnnotation(DebugAnnotation::debugID));
    proceed_stub->addAnnotation(new DebugAnnotation(d->getDirName(),d->getFileName()));
    
    //move shadow into it
    BasicBlock* entry=new BasicBlock("",proceed_stub);
    entry->getInstList().push_back(shadow);
    entry->getInstList().push_back(new ReturnInst(shadow));
	  
    //put shadow's new args in
    Function::arg_iterator arg_it=proceed_stub->arg_begin();
    unsigned int i=1;
    if(join_point_struct_needed) arg_it++;//walk past join point struct argument IFF no body extraction took place
    //	  else i++;
    for(;i<shadow->getNumOperands();i++){
      shadow->setOperand(i,&*arg_it);
      arg_it++;
    }

    Munger::eraseMarkers(shadow);

    return proceed_stub;
  }

  void weave_before(const JoinPoint* jp,Instruction* locationBeforeWhichToWeave,Function* advice,Function* calledFunction,Function* enclosingFunction,Module* module,vector<Value*>* extra_advice_args=0){
    //1. create fresh advice stub with unique name
    //   use original address of advised call in name? <--> multiple advice at same join point 
    //   => use static counter in Munger
    // UNNECESSARY IF NO TYPE PARAMETERS!
    //  Function* advice_stub=CloneFunction(advice);
    //  advice_stub->setName(create_unique_name(advice->getName()));
    //  advice->viewCFG();
    //  advice_stub->viewCFG();

    //TODO: more fine-grained using indices in struct (look if jp->Args is done or jp->fileName or ...)
    CallInst* shadow=cast<CallInst>(jp->getShadow());
    Context* context=jp->getContext();

    std::map<llvm::Type*,llvm::Type*> dummyTypeToContextType;
    if(isParameterisedAdvice(advice)){
      std::cout << "[BEFORE/AFTER] Parameterised advice..." << endl;
      advice=cloneParameterisedAdvice(advice,shadow,context,dummyTypeToContextType,extra_advice_args,false);
      //      advice->dump();
      for(Function::iterator block=advice->begin();block!=advice->end();block++){
	BasicBlock::iterator instruction_end=block->end();
	for(BasicBlock::iterator instruction=block->begin();instruction!=instruction_end;instruction++) repairTypeParameterisedVariable(&*instruction,dummyTypeToContextType);
      }
    }else Munger::reconsiderUnusedAdvice(advice);//no type parameter => original advice used

    //dummy around which query code is woven, and before which actual retrieval code and advice call are placed (both for before and after advice)
    AllocaInst* dummy_allo=new AllocaInst(Type::Int32Ty,"",locationBeforeWhichToWeave);

    vector<Value*> processorArgs;
    processorArgs.push_back(dummy_allo);

    JoinPoint::ResidueMap* residues=jp->getResidues();
    if(residues){
      for(JoinPoint::ResidueMap::iterator iter=residues->begin();iter!=residues->end();iter++){
	//residue for this shadow => process current advice match
	iter->second->process(processorArgs);
      }
    }

    locationBeforeWhichToWeave=dummy_allo;

    //following puts everything before shadow (before) or successor (after)
    vector<Value*> arg_actuals=get_advice_actuals((JoinPoint*)jp,shadow->getParent()->getParent(),advice,advice,context,dummyTypeToContextType,locationBeforeWhichToWeave,extra_advice_args,false);

    //locationbeforeWhichToWeave is either shadow (before) or successor (after)
    new CallInst(advice,arg_actuals.begin(),arg_actuals.end(),"",locationBeforeWhichToWeave);//CallInst* advice_call=

    dummy_allo->eraseFromParent();
  }
}

void CallMunger::weave(const AfterJoinPoint* jp){
  //TODO: sharing of advice stubs
  //TODO: replace generic types in advice code by proper value
  if(!Munger::init((JoinPoint*)jp)) return;

  CallInst* shadow=cast<CallInst>(jp->getShadow());
  Function* enclosingFunction=shadow->getParent()->getParent();
  Function* calledFunction=shadow->getCalledFunction();
  Module* module=enclosingFunction->getParent();
  Function* advice=module->getFunction(mangle_advice_name(jp->getAdviceName(),jp->getTime()));

  vector<Value*> extra_advice_args;

  //  Instruction* locationBeforeWhichToWeave=Munger::getAdviceMarker(shadow);//getNextInstruction(shadow);
  Instruction* locationBeforeWhichToWeave=getNextInstruction(Munger::getContextMarker(shadow));//getNextInstruction(shadow);

  if(jp->isAfterReturning()){
    Instruction* oldReturnValue=getAllocadReturnValue(shadow);
    if(!oldReturnValue){//no allocated variable yet in which return value of shadow is stored
      //      AllocaInst* oldReturnAlloca=0;
      LoadInst* newReturnValue=0;
      Instruction* contextMarker=Munger::getContextMarker(shadow);
      //      LoadInst* tmpReturnValue=0;
      //      StoreInst* oldReturnStore=0;

      //if there is already an appropriate alloc - store - load - load behind the shadow, use this (temporal after_returning relies on the two identic load's)
      //      if((oldReturnAlloca=dyn_cast<AllocaInst>(locationBeforeWhichToWeave))&&(oldReturnStore=dyn_cast<StoreInst>(getNextInstruction(locationBeforeWhichToWeave)))&&(newReturnValue=dyn_cast<LoadInst>(getNextNextInstruction(locationBeforeWhichToWeave)))&&(oldReturnAlloca->getAllocatedType()==calledFunction->getReturnType())&&(oldReturnStore->getOperand(0)==shadow)&&(oldReturnStore->getOperand(1)==oldReturnAlloca)&&(newReturnValue->getPointerOperand()==oldReturnAlloca)){
	//found right instructions
      //	oldReturnValue=oldReturnAlloca;

      //	if(!((tmpReturnValue=dyn_cast<LoadInst>(getNextNextNextInstruction(locationBeforeWhichToWeave)))&&(tmpReturnValue->getPointerOperand()==oldReturnAlloca))){
      //	  new LoadInst(oldReturnValue,create_unique_name("dummy"),newReturnValue);
      //	}
      //      }else{
	// %res_12 = alloca int		; <int*> [#uses=2]
	// store int %tmp9, int* %res_12  ; %tmp_9 is original return value
	// call void %ASPICERE2_after_returning_printf_status_print2( %struct.JOINPOINT* null, int 4, int* %res_12 )
      oldReturnValue=new AllocaInst(calledFunction->getReturnType(),create_unique_name("res"),contextMarker);
      
      //make sure that all uses of the original return value are replaced by the value of oldReturnValue
      //      Instruction* dummy=new LoadInst(oldReturnValue,create_unique_name("tmp"),locationBeforeWhichToWeave);
      newReturnValue=new LoadInst(oldReturnValue,create_unique_name("tmp"),getNextInstruction(Munger::getAdviceMarker(shadow)));//load should be after the store and also after all after_returning's, because modified return value should be seen, not the original one!!!
      //      shadow->replaceAllUsesWith(newReturnValue);
      replaceAllUsesAfterWith(shadow,newReturnValue);
      new StoreInst(shadow,oldReturnValue,false,contextMarker);//add unique use (storing) of oldReturnValue now
      //      }

      setAllocadAndLoadOfReturnValue(shadow,oldReturnValue,0);
      //locationBeforeWhichToWeave=newReturnValue;
    }//else locationBeforeWhichToWeave=getNextNextNextInstruction(oldReturnValue);//necessary, otherwise after-calls using oldReturnValue would be inserted BEFORE definition of %res_12 (this would keep shifting backwards); on the other hand, they still need to be inserted BEFORE the load of oldReturnValue

    extra_advice_args.push_back(oldReturnValue);
  }

  weave_before(jp,locationBeforeWhichToWeave,advice,calledFunction,enclosingFunction,module,&extra_advice_args);

  std::cout << "--------------------------------" << endl;
}

void CallMunger::weave(const AroundJoinPoint* jp){
  //TODO: sharing of advice stubs
  //TODO: replace generic types in advice code by proper value
  if(!Munger::init((JoinPoint*)jp)) return;

  CallInst* shadow=cast<CallInst>(jp->getShadow());
  Function* enclosingFunction=shadow->getParent()->getParent();
  Function* calledFunction=shadow->getCalledFunction();
  Module* module=enclosingFunction->getParent();
  Function* advice=module->getFunction(mangle_advice_name(jp->getAdviceName(),jp->getTime()));
  string fName=calledFunction->getName();
  /*  if(Munger::isZombie(shadow)){
    cout << "Avoiding advice " << jp->getAdviceName() << " " << jp->getTime() << " call to " << fName << " in " << enclosingFunction->getName() << ", as it is ZOMBIE shadow." << endl;
    return;
  }else if(fName=="llvm.va_start"){
    cout << "[REIFIER] Skipping advice around llvm.va_start" << endl;
    return;
  }else if(fName=="llvm.va_end"){
    cout << "[REIFIER] Skipping advice around llvm.va_end" << endl;
    return;
  }else{
    cout << "Weaving advice " << jp->getAdviceName() << " " << jp->getTime() << " call to " << fName << " in " << enclosingFunction->getName() << "." << endl;
    }*/

  //  cout << "Context:" << endl;
  //  vector<string>* variableNames=jp->getVariables();
  Context* context=jp->getContext();
  context->dump();

  const FunctionType* fType=calledFunction->getFunctionType();
  std::cout << "Number of shadow actuals: " << fType->getNumParams() << "." << endl;
  for(FunctionType::param_iterator it=fType->param_begin();it!=fType->param_end();it++){
    Type* argType=*it;
    std::cout << "\tType of actual: " << (displayable_type(argType)?argType->getDescription():"<too complex to print out>") << endl;
  }

  const FunctionType* adviceType=advice->getFunctionType();
  std::cout << "Number of advice parameters: " << adviceType->getNumParams() << "." << endl;
  for(FunctionType::param_iterator it=adviceType->param_begin();it!=adviceType->param_end();it++){
    Type* argType=*it;
    std::cout << "\tType of parameter: " << (displayable_type(argType)?argType->getDescription():"<too complex to print out>") << endl;
  }

  //1. create fresh advice stub with unique name
  map<Type*,Type*> dummyTypeToContextType;
  Function* advice_stub=cloneParameterisedAdvice(advice,shadow,context,dummyTypeToContextType);

  //1b. find all advice actuals 
  Instruction* peekMarker=BinaryOperator::create(Instruction::Add,Constant::getNullValue(Type::Int32Ty),Constant::getNullValue(Type::Int32Ty),"peek_marker",shadow);
  vector<Value*> advice_actuals=get_advice_actuals((JoinPoint*)jp,enclosingFunction,advice,advice_stub,context,dummyTypeToContextType,shadow);

  //2. call advice stub and let advice_call replace shadow (but don't erase shadow, as in the worst case it will become a zombie)
  //  Value** advice_actuals_array=new Value*[advice_actuals.size()];
  //  for(unsigned int iter=0;iter<advice_actuals.size();iter++) advice_actuals_array[iter]=advice_actuals[iter];
  CallInst* advice_call=new CallInst(advice_stub,advice_actuals.begin(),advice_actuals.end(),"",shadow);
  //  delete[] advice_actuals_array;
  shadow->uncheckedReplaceAllUsesWith(advice_call);
  shadow->removeFromParent();

  //3. process advice stub
  bool shadow_is_zombie_now=true;
  Function* proceed_stub=0;
  Function* tmpFunction=0;
  CallInst* proceed=0;
  for(Function::iterator block=advice_stub->begin();block!=advice_stub->end();block++){
    BasicBlock::iterator instruction_end=block->end();
    for(BasicBlock::iterator instruction=block->begin();instruction!=instruction_end;instruction++){
      if(repairTypeParameterisedVariable(&*instruction,dummyTypeToContextType)){
	//do nothing (everything happened during the check)
      }else if((proceed=dyn_cast<CallInst>(&*instruction))&&((tmpFunction=proceed->getCalledFunction()))&&(tmpFunction->getName()==string("proceed"))){
	//b. replace proceeds with call to clone (lazily constructed) containing the original call shadow => no map necessary pointing from call to other call aliases, check in all weave-methods whether alternatives exist, ...
	//<--> look out for use of actuals that are inaccessible now by constantly moving around)
	shadow_is_zombie_now=false;

	if(!proceed_stub){
	  //clone called function
	  //	  proceed_stub=cloneFunctionSignatureFromCall(proceed,create_unique_name(string("proceed")));
	  proceed_stub=extractProceedStub(shadow,enclosingFunction);
	}

	//construct call to proceed_stub with right arguments!
	vector<Value*> proceed_call_actuals;
	unsigned int nr_of_advice_args=advice->arg_size();
	Function::arg_iterator arg_it=advice_stub->arg_begin();
	proceed_call_actuals.push_back(&*arg_it);//put join point struct first

	//if(proceed did NOT have any args){
	//  if(nr_of_shadow_actuals==0){
	//    no args necessary
	//  }else{
	//    use original arguments passes as last arguments of advice
	//  }
	//}else{
	//  use these as new arguments of proceed_call_stub
	//}
	unsigned int nr_of_proceed_actuals=proceed->getNumOperands()-1;
	if(nr_of_proceed_actuals==0){
	  for(unsigned int i=0;i<nr_of_advice_args;i++) arg_it++;//skip past other advice arguments
	  for(;arg_it!=advice_stub->arg_end();arg_it++){
	    proceed_call_actuals.push_back(&*arg_it);//add actuals of join point shadow
	  }
	}else{
	  for(unsigned int i=0;i<nr_of_proceed_actuals;i++){
	    proceed_call_actuals.push_back(proceed->getOperand(i+1));
	  }
	}

	//	Value** proceed_call_actuals_array=new Value*[proceed_call_actuals.size()];
	//	for(unsigned int iter=0;iter<proceed_call_actuals.size();iter++) proceed_call_actuals_array[iter]=proceed_call_actuals[iter];
	CallInst* proceed_call_stub=new CallInst(proceed_stub,proceed_call_actuals.begin(),proceed_call_actuals.end(),"",proceed);
	//	delete[] proceed_call_actuals_array;
	
	//replace proceed with call to proceed_stub
	//	proceed->replaceAllUsesWith(proceed_call_stub);
	proceed->uncheckedReplaceAllUsesWith(proceed_call_stub);
	proceed->eraseFromParent();

	//fix problems due to dummy proceed() in source code returning a void* while real stub can return something else
	CastInst* castInst=0;
	vector<Instruction*> toCleanUp;
	for(Value::use_iterator use_iter=proceed_call_stub->use_begin();use_iter!=proceed_call_stub->use_end();use_iter++){
	  if((castInst=dyn_cast<CastInst>((*use_iter)))&&!(castInst->getDestTy()->getTypeID()==Type::PointerTyID)&&!(CastInst::castIsValid(castInst->getOpcode(),castInst->getOperand(0),castInst->getDestTy()))){
	    CastInst* newCast=0;

	    if(castInst->getSrcTy()->isInteger()){
	      newCast=CastInst::createIntegerCast(castInst->getOperand(0),castInst->getDestTy(),((IntegerType*)castInst->getSrcTy())->getSignBit(),"",castInst);
	    }else{//floating point
	      newCast=CastInst::createFPCast(castInst->getOperand(0),castInst->getDestTy(),"",castInst);
	    }
	    
	    castInst->replaceAllUsesWith(newCast);
	    toCleanUp.push_back(castInst);
	  }
	}

	for(vector<Instruction*>::iterator ins_iter=toCleanUp.begin();ins_iter!=toCleanUp.end();ins_iter++){
	  (*ins_iter)->eraseFromParent();
	}
      }else if((proceed=dyn_cast<CallInst>(&*instruction))&&((tmpFunction=proceed->getCalledFunction()))&&(tmpFunction->getName()==string("dummy_proceed"))){
	shadow_is_zombie_now=false;

	//construct call to proceed_stub with right arguments!
	vector<Value*> proceed_call_actuals;
	unsigned int nr_of_advice_args=advice->arg_size();
	Function::arg_iterator arg_it=advice_stub->arg_begin();
	//	proceed_call_actuals.push_back(&*arg_it);//put join point struct first

	//if(proceed did NOT have any args){
	//  if(nr_of_shadow_actuals==0){
	//    no args necessary
	//  }else{
	//    use original arguments passes as last arguments of advice
	//  }
	//}else{
	//  use these as new arguments of proceed_call_stub
	//}
	unsigned int nr_of_proceed_actuals=proceed->getNumOperands()-1;
	for(unsigned int i=0;i<nr_of_proceed_actuals;i++){//always add dummy_proceed's actuals (context vars)
	  proceed_call_actuals.push_back(proceed->getOperand(i+1));
	}

	if(nr_of_proceed_actuals==nr_of_advice_args){//we need to add shadow actuals
	  for(unsigned int i=0;i<nr_of_advice_args;i++) arg_it++;//skip past other advice arguments
	  for(;arg_it!=advice_stub->arg_end();arg_it++){
	    proceed_call_actuals.push_back(&*arg_it);//add actuals of join point shadow
	  }
	}

	CallInst* dummy_proceed_call_stub=new CallInst(advice_stub,proceed_call_actuals.begin(),proceed_call_actuals.end(),"",proceed);

	//replace proceed with call to proceed_stub
	//	proceed->replaceAllUsesWith(proceed_call_stub);
	proceed->uncheckedReplaceAllUsesWith(dummy_proceed_call_stub);
	proceed->eraseFromParent();

	//fix problems due to dummy proceed() in source code returning a void* while real stub can return something else
	CastInst* castInst=0;
	vector<Instruction*> toCleanUp;
	for(Value::use_iterator use_iter=dummy_proceed_call_stub->use_begin();use_iter!=dummy_proceed_call_stub->use_end();use_iter++){
	  if((castInst=dyn_cast<CastInst>((*use_iter)))&&!(castInst->getDestTy()->getTypeID()==Type::PointerTyID)&&!(CastInst::castIsValid(castInst->getOpcode(),castInst->getOperand(0),castInst->getDestTy()))){
	    CastInst* newCast=0;

	    if(castInst->getSrcTy()->isInteger()){
	      newCast=CastInst::createIntegerCast(castInst->getOperand(0),castInst->getDestTy(),((IntegerType*)castInst->getSrcTy())->getSignBit(),"",castInst);
	    }else{//floating point
	      newCast=CastInst::createFPCast(castInst->getOperand(0),castInst->getDestTy(),"",castInst);
	    }
	    
	    castInst->replaceAllUsesWith(newCast);
	    toCleanUp.push_back(castInst);
	  }
	}

	for(vector<Instruction*>::iterator ins_iter=toCleanUp.begin();ins_iter!=toCleanUp.end();ins_iter++){
	  (*ins_iter)->eraseFromParent();
	}
      }
    }
  }

  JoinPoint::ResidueMap* residues=jp->getResidues();
  if(residues){
    vector<Value*> processorArgs;
    processorArgs.push_back(advice_call);
    
    //now compose a proceed-call with same arguments as shadow call
    shadow_is_zombie_now=false;
    
    if(!proceed_stub){
      //clone called function
      //	  proceed_stub=cloneFunctionSignatureFromCall(proceed,create_unique_name(string("proceed")));
      proceed_stub=extractProceedStub(shadow,enclosingFunction);
    }
    
    vector<Value*> proceed_call_actuals;
    unsigned int nr_of_advice_args=advice->arg_size();
    proceed_call_actuals.push_back(advice_call->getOperand(1));//put join point struct first

    //if(proceed did NOT have any args){
    //  if(nr_of_shadow_actuals==0){
    //    no args necessary
    //  }else{
    //    use original arguments passes as last arguments of advice
    //  }
    //}else{
    //  use these as new arguments of proceed_call_stub
    //}
    unsigned int indexOfActual=0;
    for(;indexOfActual<nr_of_advice_args;indexOfActual++);//skip past other advice arguments
    for(unsigned int j=0;j<(shadow->getNumOperands())-1;j++){
      proceed_call_actuals.push_back(advice_actuals[indexOfActual++]);//add actuals of join point shadow
    }

    //construct call to proceed_stub with right arguments!
    CallInst* cflow_proceed_call_stub=new CallInst(proceed_stub,proceed_call_actuals.begin(),proceed_call_actuals.end(),"",getNextInstruction(advice_call));
    processorArgs.push_back(cflow_proceed_call_stub);

    processorArgs.push_back(peekMarker);
    
    for(JoinPoint::ResidueMap::iterator iter=residues->begin();iter!=residues->end();iter++){
      //residue for this shadow => process current advice match
      iter->second->process(processorArgs);
    }
  }

  if(shadow_is_zombie_now){
    std::cout << "Found ZOMBIE...";
    /*    shadow->print(std::cout);*/
    std::cout << std::endl;
    Munger::addZombie(shadow);
  }

  std::cout << "--------------------------------" << endl;
}

void CallMunger::weave(const BeforeJoinPoint* jp){
  //static int first_weave=0;
  //if(first_weave++ >1) return;
  //TODO: replace generic types in advice code by proper value
  //TODO: recycle JP_struct <--> number of args can differ
  if(!Munger::init((JoinPoint*)jp)) return;

  CallInst* shadow=cast<CallInst>(jp->getShadow());
  Function* enclosingFunction=shadow->getParent()->getParent();
  Function* calledFunction=shadow->getCalledFunction();
  Module* module=enclosingFunction->getParent();
  Function* advice=module->getFunction(mangle_advice_name(jp->getAdviceName(),jp->getTime()));
  /*  if(Munger::isZombie(shadow)){
    cout << "Avoiding advice " << jp->getAdviceName() << " " << jp->getTime() << " call to " << calledFunction->getName() << " in " << enclosingFunction->getName() << ", as it is ZOMBIE shadow." << endl;
    return;
  }else{
    cout << "Weaving advice " << jp->getAdviceName() << " " << jp->getTime() << " call to " << calledFunction->getName() << " in " << enclosingFunction->getName() << "." << endl;
    }*/

  weave_before(jp,shadow,advice,calledFunction,enclosingFunction,module);

  std::cout << "--------------------------------" << endl;
}

void CallMunger::weave(const IntroJoinPoint* jp){
  if(!Munger::init((JoinPoint*)jp)) return;

  //initialize introduced variable to zero
  Instruction* var=cast<Instruction>(jp->getShadow());
  //  Function* enclosingFunction=var->getParent()->getParent();
  //  insertCrossAdviceContext(enclosingFunction);//necessary to insert var into entry basic block if not yet happened before (when execution is advised by other advices already)
  SequentialType* ty=cast<SequentialType>((Type*)var->getType());
  new StoreInst(Constant::getNullValue(ty->getElementType()),var,getNextInstruction(var));
  //  cout << "[INTRO] store " << ty->getElementType()->getDescription() << " into " << var->getType()->getDescription() << endl;
}
