/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Aspicere2.
 *
 * The Initial Developer of the Original Code is
 * the Ghislain Hoffman Software Engineering Lab, INTEC, University Ghent.
 * Portions created by the Initial Developer are Copyright (C) 2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Bram Adams <bram_DOT_adams_AT_ugent_DOT_be>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "utility/Util.h"
#include "weaver/CflowQueryShadowResidueProcessor.h"
#include "llvm/Constants.h"
#include "llvm/DerivedTypes.h"
#include "llvm/Instructions.h"

using namespace std;
using namespace llvm;

CflowQueryShadowResidueProcessor::~CflowQueryShadowResidueProcessor(){
}

//only works if before-advice?
void CflowQueryShadowResidueProcessor::process(std::vector<Value*>& vals){
  Instruction* ins=cast<Instruction>(vals[0]);

  if(vals.size()==1){ //before/after: create three basic blocks from one: B1 -> B2 -> B3 with B2 containing vals[0] (advice) and B1 ends in a jump to either B2 or B3 based on cflow counter
    //check if _counter>1:
    // - true: call ins (i.e. advice)
    // - false: skip advice (special case: around advice! after returning?)
    BasicBlock* B1=ins->getParent();
    
    BasicBlock* B3=B1->splitBasicBlock(getNextInstruction(ins));//there's now a jump after ins to B3
    
    BasicBlock* B2=B1->splitBasicBlock(ins);//there's now a jump in front of ins to B2
    //  new BranchInst(B3,B2);//unnecessary, as it's already in B2 after first split

    B1->getTerminator()->eraseFromParent();
    new BranchInst(B2,B3,new ICmpInst(ICmpInst::ICMP_UGT,new LoadInst(_counter,"",B1),ConstantInt::get(Type::Int32Ty,0),"",B1),B1);
  }else{ //around-advice: create four basic blocks from one: B1 -> B2 | B3 -> B4 where B2 calls the around advice (preceded by allocations of context vars) and then B4; B3 just calls proceed and B4
    //ins is advice call + rest of Function uses its return value => we need to introduce a PhiNode!
    //ins2 is proceed call which denotes normal flow of control (advice not matched)
    Instruction* ins2=cast<Instruction>(vals[1]);
    Instruction* peek=cast<Instruction>(vals[2]);

    BasicBlock* B1=ins->getParent();//== ins2->getParent()

    BasicBlock* B4=B1->splitBasicBlock(getNextInstruction(ins2));//there's now a jump after ins2 to B4
    BasicBlock* B3=B1->splitBasicBlock(getNextInstruction(ins));//there's now a jump after ins to B3 (which contains ins2)
    
    BasicBlock* B2=B1->splitBasicBlock(peek);//there's now a jump in front of ins to B2 (which contains peek-calls and ins)
    //    BasicBlock* B2=B1->splitBasicBlock(ins);//there's now a jump in front of ins to B2 (which contains ins)
    //  new BranchInst(B3,B2);//unnecessary, as it's already in B2 after first split

    //B2 should jump to B4
    B2->getTerminator()->eraseFromParent();
    new BranchInst(B4,B2);

    //B1 should branch either to B2 or B3
    B1->getTerminator()->eraseFromParent();
    new BranchInst(B2,B3,new ICmpInst(ICmpInst::ICMP_UGT,new LoadInst(_counter,"",B1),ConstantInt::get(Type::Int32Ty,0),"",B1),B1);

    Type* insType=(Type*)ins->getType();
    if(insType!=Type::VoidTy){ //B2 and B3 both jump to B4, so in case ins' return type is not void we need a phi node to reconcile the two possible return values (ins' and ins2's)
      AllocaInst* dummy=new AllocaInst(insType,"",B1);//this step is needed to avoid that phi node's use of ins will also be replaced by use of itself
      ins->uncheckedReplaceAllUsesWith(dummy);

      Instruction& entry=B4->front();
      PHINode* phi=new PHINode(ins->getType(),"around_cflow",&entry);
      phi->reserveOperandSpace(2);
      phi->addIncoming(ins,B2);
      phi->addIncoming(ins2,B3);
      
      dummy->uncheckedReplaceAllUsesWith(phi);
      dummy->eraseFromParent();
    }

  }
}
