/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Aspicere2.
 *
 * The Initial Developer of the Original Code is
 * the Ghislain Hoffman Software Engineering Lab, INTEC, University Ghent.
 * Portions created by the Initial Developer are Copyright (C) 2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Bram Adams <bram_DOT_adams_AT_ugent_DOT_be>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "utility/Util.h"
#include "weaver/CflowStackUpdateShadowResidueProcessor.h"
#include "llvm/Constants.h"
#include "llvm/DerivedTypes.h"
#include "llvm/Instructions.h"

using namespace std;
using namespace llvm;

CflowStackUpdateShadowResidueProcessor::~CflowStackUpdateShadowResidueProcessor(){}

void CflowStackUpdateShadowResidueProcessor::process(std::vector<Value*>& vals){

  //  assert(false && "Stack updating not yet implemented...");
  Instruction* ins=cast<Instruction>(vals[0]);
  Module* module=ins->getParent()->getParent()->getParent();

  //push all relevant context on stack
  
  vector<Value*> actuals;
  actuals.push_back(_stack);
  actuals.push_back(ConstantInt::get( Type::Int32Ty, _contextVars.size() ));
  for(vector<Value*>::iterator it=_contextVars.begin();it!=_contextVars.end();it++){
    AllocaInst* allo=new AllocaInst((*it)->getType(),"",ins);
    new StoreInst(*it,allo,ins);
    actuals.push_back(allo);
  }
  new CallInst(module->getFunction("__ASPICERE2_stack_push"),actuals.begin(),actuals.end(),"",ins);

  //find next instruction (won't change original ins!)
  ins=getNextInstruction(ins);

  //pop context
  new CallInst(module->getFunction("__ASPICERE2_stack_pop"),_stack,"",ins);

      /*
  //1. increment _counter
  new StoreInst(BinaryOperator::create(Instruction::Add,new LoadInst(_counter,"",ins),ConstantInt::get(Type::Int32Ty,1),"",ins),_counter,false,ins);
  
  //2. decrement _counter
  new StoreInst(BinaryOperator::create(Instruction::Sub,new LoadInst(_counter,"",ins),ConstantInt::get(Type::Int32Ty,1),"",ins),_counter,false,ins);*/
}
