/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Aspicere2.
 *
 * The Initial Developer of the Original Code is
 * the Ghislain Hoffman Software Engineering Lab, INTEC, University Ghent.
 * Portions created by the Initial Developer are Copyright (C) 2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Bram Adams <bram_DOT_adams_AT_ugent_DOT_be>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "utility/Cloning.h"
#include "utility/Naming.h"
#include "utility/Util.h"
#include "weaver/ContinuationMunger.h"
#include "weaver/Utils.h"
#include "llvm/Instructions.h"
#include "llvm/Module.h"
#include "llvm/Support/CFG.h"
#include "llvm/Type.h"
#include <iostream>

using namespace std;
using namespace llvm;

void ContinuationMunger::weave(const AfterJoinPoint* jp){
  if(!Munger::init((JoinPoint*)jp)) return;
}

/**
 * Naive implementation of continuation munger:
 * - at most one proceed per advice flow
 * - at most one continuation advice per shadow
 * - no advice execution after proceed (aka tail proceed call)
 * Basically:
 * - shadow's basic block is split after the shadow and shadow's new block ends with jump to advice
 * - proceeds become jumps to next base instruction
 * - base returns remain => no advice execution after proceed (aka tail proceed call)
 * - advice returns become stores of return value and jumps back to either previous continuation advice or to new exit node (returning the return variable)
 */
void ContinuationMunger::weave(const AroundJoinPoint* jp){
  if(!Munger::init((JoinPoint*)jp)) return;

  CallInst* shadow=cast<CallInst>(jp->getShadow());
  BasicBlock* enclosingBlock=shadow->getParent();
  Function* enclosingFunction=enclosingBlock->getParent();
  //  Function* calledFunction=shadow->getCalledFunction();
  Module* module=enclosingFunction->getParent();
  Function* advice=module->getFunction(mangle_advice_name(jp->getAdviceName(),jp->getTime()));
  Context* context=jp->getContext();
  Type* retType=(Type*)enclosingFunction->getReturnType();
  bool is_void=(retType==Type::VoidTy);

  //split basic block right after shadow in B1 and B2
  BasicBlock* B1=enclosingBlock;
  B1->setName(create_unique_name("B1"));
  BasicBlock* B2=B1->splitBasicBlock(getNextInstruction(shadow));//there's now a jump after shadow to B2
  B2->setName(create_unique_name("B2"));
  
  //clone basic blocks of advice + replace usage of arguments by actuals directly (see ValueMap)
  std::map<llvm::Type*,llvm::Type*> dummyTypeToContextType;
  llvm::Function* advice_clone=cloneParameterisedAdvice(advice,shadow,context,dummyTypeToContextType);  
  vector<Value*> advice_actuals=get_advice_actuals((JoinPoint*)jp,enclosingFunction,advice,advice_clone,context,dummyTypeToContextType,shadow);

  /*  for(unsigned int i=0;i<advice_actuals.size();i++){
    cout << "TEST:\t" << advice_actuals[i]->getType()->getDescription() << endl;
    }*/

  vector<CallInst*> proceeds;
  CallInst* proceed=0;
  vector<ReturnInst*> rets;
  ReturnInst* ret=0;
  for(Function::iterator block=advice_clone->begin();block!=advice_clone->end();block++){
    BasicBlock::iterator instruction_end=block->end();
    for(BasicBlock::iterator instruction=block->begin();instruction!=instruction_end;instruction++){
      if(repairTypeParameterisedVariable(&*instruction,dummyTypeToContextType)){
	//do nothing (everything is done during check)
      }else if((proceed=dyn_cast<CallInst>(&*instruction))&&(proceed->getCalledFunction()->getName()==string("proceed"))){
	proceeds.push_back(proceed);
      }
      else if(is_void&&(ret=dyn_cast<ReturnInst>(&*instruction))){
	rets.push_back(ret);
      }
    }
  }

  BasicBlock& advice_entry=advice_clone->getEntryBlock();

  std::map<Value*, Value*> ValueMap;//arg -> actual
  Function::arg_iterator it=advice_clone->arg_begin();
  for(unsigned int i=0;i<advice_actuals.size();i++){
    ValueMap.insert(make_pair(&*it,advice_actuals[i]));
    //    cout << "TEST:\t" << advice_actuals[i]->getType()->getDescription() << endl;
    it++;
  }
  transferBasicBlocks(advice_clone,B1,ValueMap);
  advice_clone->eraseFromParent();

  //add jump at end of B1 to advice's entry block
  Instruction* jumpToB2=B1->getTerminator();
  new BranchInst(&advice_entry,jumpToB2);

  if(proceeds.size()>1) throw "Currently only one proceed is allowed in continuation advice!";

  //  for(unsigned int i=0;i<proceeds.size();i++){
  proceed=proceeds[0];
  
  //split basic block of proceed in B3 and B4
  BasicBlock* B3=proceed->getParent();
  B3->setName(create_unique_name("B3"));
  BasicBlock* B4=B3->splitBasicBlock(getNextInstruction(proceed));//there's now a jump after proceed to B4
  
  //replace proceed by jump to B2
  Instruction* tmp=B3->getTerminator();
  jumpToB2->moveBefore(tmp);
  tmp->eraseFromParent();

  //optimisation: B4 never reached!
  B4->eraseFromParent();
  
  //erase proceed
  //  proceed->replaceAllUsesWith(Constant::getNullValue(proceed->getCalledFunction()->getReturnType()));
  //  if(retType!=Type::VoidTy){
  //    proceed->uncheckedReplaceAllUsesWith(new LoadInst(retVar,"",&*(B4->begin())));
  //  }else{
  proceed->replaceAllUsesWith(Constant::getNullValue(proceed->getCalledFunction()->getReturnType()));
    //  }
  proceed->eraseFromParent();

  if(is_void){
    for(unsigned int i=0;i<rets.size();i++){
      ret=rets[i];
      BasicBlock* retBlock=ret->getParent();
      new ReturnInst(retBlock);
      ret->eraseFromParent();
    }
  }
  
  //HACK: B4 can contain "store void bla", so we need to erase those stores
  /*  BasicBlock::iterator instruction_end=B4->end();
  for(BasicBlock::iterator instruction=B4->begin();instruction!=instruction_end;instruction++){
    StoreInst* storeInst=0;
    if((storeInst=dyn_cast<StoreInst>(&*instruction))){
      //a. remove all uses of TYPE-parameters: loop over all stores and replace them with alloca of right type
      Value* firstOperand=storeInst->getOperand(0);
      Type* storeType=(Type*)firstOperand->getType();
	if(storeType==Type::VoidTy){
	  storeInst->eraseFromParent();
	}
    }
    }*/
  //  }

}

void ContinuationMunger::weave(const BeforeJoinPoint* jp){
  if(!Munger::init((JoinPoint*)jp)) return;
}

void ContinuationMunger::weave(const IntroJoinPoint* jp){
  if(!Munger::init((JoinPoint*)jp)) return;
}
