/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Aspicere2.
 *
 * The Initial Developer of the Original Code is
 * the Ghislain Hoffman Software Engineering Lab, INTEC, University Ghent.
 * Portions created by the Initial Developer are Copyright (C) 2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Bram Adams <bram_DOT_adams_AT_ugent_DOT_be>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "matcher/Matcher.h"
#include "matcher/JoinPointShadowSorter.h"
#include "reifier/Reifier.h"
#include "weaver/Munger.h"
#include <iostream>
//#include "llvm/PassManager.h"
//#include "llvm/Support/CommandLine.h"

using namespace llvm;
using namespace std;

namespace {
  char Matcher::ID=0;//value NOT important; address used as ID for pass

  void Matcher::getAnalysisUsage(AnalysisUsage &AU) const{
    //    AU.setPreservesAll();
    AU.addRequired<Reifier>();
  }

  bool Matcher::runOnModule(Module &M) {
    if(Munger::nrOfUnusedAdvice()==0){
      std::cout << "No advice: skipping matching..." << endl;
      return false;
    }

    std::cout << "[MATCHER] Waiting for reifier..." << endl;
    Reifier& reifier = getAnalysis<Reifier>();
    std::cout << "[MATCHER] Matching..." << endl;
     //call match(...) on engine and return results
    QueryEngine* reifiedSystem=reifier.getReification();
    matches=reifiedSystem->query();
    cross_advice_context=reifiedSystem->getCrossAdviceContext();

    Sorter* sorter=new JoinPointShadowSorter;
    sorter->sort(matches);
    delete sorter;

    //cross-advice!!!

    //    matches=reifier.getMatches();
    std::cout << "[MATCHER] Found " << matches->size() << " matches." << endl;
    //    cout << *matches << endl;
    return false;//nothing modified in IR
  }
  
  RegisterPass<Matcher> X("match", "Matches join points with advices' PCDs");
  //  RegisterOpt<Matcher> X("match", "Matches join points with advices' PCDs");

  /*  enum OptimizationLevels {
    OPT_FAST_COMPILE         = 1,
    OPT_SIMPLE               = 2,
    OPT_AGGRESSIVE           = 3,
    OPT_LINK_TIME            = 4,
    OPT_AGGRESSIVE_LINK_TIME = 5
    };*/
}

ModulePass* createMatcherPass() {
  return new Matcher();
}
/*extern "C"  void RunOptimizations(PassManager& mgr,...){//cl::opt<OptimizationLevels>& optLevel){
    mgr.add(new Matcher());
    }*/

