/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Aspicere2.
 *
 * The Initial Developer of the Original Code is
 * the Ghislain Hoffman Software Engineering Lab, INTEC, University Ghent.
 * Portions created by the Initial Developer are Copyright (C) 2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Bram Adams <bram_DOT_adams_AT_ugent_DOT_be>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "prolog/MetaFactBase.h"
#include "llvm/Function.h"
#include <iostream>

using namespace std;
using namespace llvm;

namespace{

  MetaFactBase::~MetaFactBase(){
    for(std::map<llvm::Value*,DebugInfo*>::iterator it=debugFacts.begin();it!=debugFacts.end();it++){
      delete it->second;
    }
  }

  void MetaFactBase::addDebugFact(llvm::Value* val,DebugInfo* info){
    debugFacts[val]=info;//assume that unique debug info per val!
  }

  DebugInfo* MetaFactBase::getDebugFact(llvm::Value* val){
    std::map<llvm::Value*,DebugInfo*>::iterator it=debugFacts.find(val);
    if(it!=debugFacts.end()) return it->second;
    else return 0;
  }

  void MetaFactBase::dumpDebugFacts() const{
    for(std::map<llvm::Value*,DebugInfo*>::const_iterator it=debugFacts.begin();it!=debugFacts.end();it++){
      if(dyn_cast<Function>(it->first)){
	std::cout << "----------" << endl;
	std::cout << ((Function*)it->first)->getName() << " -> " << it->second->fileName << endl;
	std::cout << "----------" << endl;
      }
    }
  }

  bool MetaFactBase::isPointer(void* ptr) const{
    return isValuePointer(ptr)||isTypePointer(ptr);
  }

  bool MetaFactBase::isValuePointer(void* ptr) const{
    std::set<llvm::Value*>::iterator it=valuePointers.find((Value*)ptr);
    return (it!=valuePointers.end());
  }

  bool MetaFactBase::isTypePointer(void* ptr) const{
    std::set<llvm::Type*>::iterator it=typePointers.find((Type*)ptr);
    return (it!=typePointers.end());
  }

  void MetaFactBase::addValuePointer(Value* val){
    valuePointers.insert(val);
  }

  void MetaFactBase::addTypePointer(Type* val){
    typePointers.insert(val);
  }
}
