/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Aspicere2.
 *
 * The Initial Developer of the Original Code is
 * the Ghislain Hoffman Software Engineering Lab, INTEC, University Ghent.
 * Portions created by the Initial Developer are Copyright (C) 2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Bram Adams <bram_DOT_adams_AT_ugent_DOT_be>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "stripdebug/CrossAdviceContextAnnotation.h"
#include "utility/Naming.h"
#include "utility/Util.h"
#include "weaver/Munger.h"
#include "weaver/Utils.h"
#include "llvm/Instructions.h"
#include "llvm/Module.h"
#include <iostream>

using namespace std;
using namespace llvm;

int Munger::unique_integer=0;
set<llvm::Value*> Munger::zombie_shadows;
llvm::Function* Munger::_realMain=0;
llvm::Function* Munger::_extractedMain=0;
std::map<llvm::Value*,std::pair<bool,llvm::Function*> > Munger::jpToExistenceOfStruct;
std::multimap<llvm::Value*,std::pair<llvm::Value*,int> >* Munger::crossAdviceContext=0;//owned by Weaver
std::map<llvm::Value*,llvm::Value*> Munger::processedCrossAdviceContext;
std::set<llvm::Instruction*> Munger::callsToExtractedMethods;
std::map<llvm::Value*,std::pair<llvm::Instruction*,llvm::Instruction*> > Munger::shadowToMarkers;
std::set<llvm::Function*> Munger::unusedAdvice;

namespace{
  //true if zombie
  bool check_zombie_status(JoinPoint* jp){
    CallInst* shadow=0;

    if((shadow=dyn_cast<CallInst>(jp->getShadow()))){//check for intro
      Function* enclosingFunction=shadow->getParent()->getParent();
      Function* calledFunction=shadow->getCalledFunction();
      
      if(Munger::isZombie(shadow)){
	std::cout << "Avoiding advice " << jp->getAdviceName() << " " << jp->getTime() << " call to " << calledFunction->getName() << " in " << enclosingFunction->getName() << ", as it is ZOMBIE shadow." << endl;
	return true;
      }else{
	std::cout << "Weaving advice " << jp->getAdviceName() << " " << jp->getTime() << " call to " << calledFunction->getName() << " in " << enclosingFunction->getName() << "." << endl;
	return false;
      }
    }else{
      std::cout << "Weaving advice " << jp->getAdviceName() << " of advice type " << jp->getTime() << "." << endl;
    }

    return false;
  }

  /*Find out if cross-advice context is already packed into a join point struct, and if not do this now.*/
  void Munger::processCrossAdviceContext(JoinPoint* jp){
    CallInst* shadow=0;
    if(!(shadow=dyn_cast<CallInst>(jp->getShadow()))) return;//intro
    Function* enclosingFunction=shadow->getParent()->getParent();
    Module* module=enclosingFunction->getParent();

    Instruction* placeToPrependThings=0;
    if(jp->getTime()=="after_returning"){//allow to juggle with return value in pcd context
      placeToPrependThings=Munger::getContextMarker(shadow);//getNextInstruction(getNextNextNextInstruction(shadow));
    }else{
      placeToPrependThings=shadow;
    }

    if(!Munger::isCrossAdviceContextProcessed(shadow)){
      std::pair<std::multimap<Value*,std::pair<llvm::Value*,int> >::iterator,std::multimap<Value*,std::pair<llvm::Value*,int> >::iterator> crossContext=Munger::getCrossAdviceContext(shadow);

      const Type* jp_type=module->getTypeByName(string("struct.JOINPOINT"));
      Value* jp_var=0;

      if(crossContext.first==crossContext.second){//no cross-advice context (empty range)
	jp_var=Constant::getNullValue(PointerType::get(jp_type));
      }else{
	//create joinpoint struct
	//	%j = alloca %struct.newjp, align 16		; <%struct.newjp*> [#uses=2]
	jp_var=new AllocaInst(jp_type,create_unique_name("jp"),shadow);
	
	//	%tmp = getelementptr %struct.newjp* %j, int 0, uint 0		; <[5 x sbyte*]*> [#uses=1]
	
	vector<Value*> index_vector;
	index_vector.push_back( ConstantInt::get( Type::Int32Ty, 0 ));
	index_vector.push_back( ConstantInt::get( Type::Int32Ty, 0 ));
	Instruction* elementPtr=new GetElementPtrInst( jp_var,index_vector.begin(),index_vector.end(),create_unique_name("tmp"),shadow);
	
	if(is_extracted_method(enclosingFunction)){//check whether some context isn't passed through the extracted method's first argument (join point struct)
	  std::pair<std::multimap<Value*,std::pair<llvm::Value*,int> >::iterator,std::multimap<Value*,std::pair<llvm::Value*,int> >::iterator> extractedMethodCrossContext=Munger::getCrossAdviceContext(enclosingFunction);

	  map<llvm::Value*,int> extractedMethodContextToIndex;
	  for(std::multimap<Value*,std::pair<llvm::Value*,int> >::iterator itmp=extractedMethodCrossContext.first;itmp!=extractedMethodCrossContext.second;itmp++){
	    extractedMethodContextToIndex[itmp->second.first]=itmp->second.second;
	  }
	  
	  //  %tmp_136 = getelementptr %struct.JOINPOINT* %Jp, int 0, uint 0          ; <[5 x sbyte*]*> [#uses=1]
	  index_vector.clear();
	  index_vector.push_back( ConstantInt::get( Type::Int32Ty, 0 ));
	  index_vector.push_back( ConstantInt::get( Type::Int32Ty, 0 ));
	  Instruction* extractedMethodStructElementPtr=new GetElementPtrInst(&*(enclosingFunction->arg_begin()),index_vector.begin(),index_vector.end(),create_unique_name("extjp"),shadow);

	  for(std::multimap<Value*,std::pair<llvm::Value*,int> >::iterator it=crossContext.first;it!=crossContext.second;it++){
	    Value* context=it->second.first;
	    int index=it->second.second;

	    //if context is in fact passed through the enclosing Function's first arg (join point struct), load context from this struct as it is NOT directly accessible from the current scope (due to body extraction process!)
	    map<llvm::Value*,int>::iterator correspondingExtractedMethodContext=extractedMethodContextToIndex.find(context);
	    if(correspondingExtractedMethodContext!=extractedMethodContextToIndex.end()){
	      int correspondingExtractedMethodContextIndex=correspondingExtractedMethodContext->second;

	      index_vector.clear();
	      index_vector.push_back( ConstantInt::get( Type::Int32Ty, 0 ));
	      index_vector.push_back( ConstantInt::get( Type::Int32Ty, correspondingExtractedMethodContextIndex ));
	      context=new LoadInst(CastInst::createPointerCast(new LoadInst(new GetElementPtrInst( extractedMethodStructElementPtr,index_vector.begin(),index_vector.end(),create_unique_name("tmp"),shadow),"",shadow),PointerType::get(context->getType()),"",shadow),"",shadow);
	    }
	    
	    //	%tmp = getelementptr [5 x sbyte*]* %tmp, int 0, int 0		; <sbyte**> [#uses=1]
	    index_vector.clear();
	    index_vector.push_back( ConstantInt::get( Type::Int32Ty, 0 ));
	    index_vector.push_back( ConstantInt::get( Type::Int32Ty, index ));
	    Instruction* newElementPtr=new GetElementPtrInst( elementPtr,index_vector.begin(),index_vector.end(),create_unique_name("tmp"),shadow);
	    
	    //create AllocaInst
	    //	%a_addr = alloca int		; <int*> [#uses=3]
	    //	store int %a, int* %a_addr
	    AllocaInst* alloc=new AllocaInst(context->getType(),create_unique_name("jp"),shadow);
	    new StoreInst(context,alloc,placeToPrependThings);
	    
	    //add it to struct
	    //	%a_addr = cast int* %a_addr to sbyte*		; <sbyte*> [#uses=1]
	    //	store sbyte* %a_addr, sbyte** %tmp
	    CastInst* castIn=CastInst::createPointerCast(alloc,PointerType::get(Type::Int8Ty),"",placeToPrependThings);
	    new StoreInst(castIn,newElementPtr,placeToPrependThings);
	  }
	}else{
	  for(std::multimap<Value*,std::pair<llvm::Value*,int> >::iterator it=crossContext.first;it!=crossContext.second;it++){
	    Value* context=it->second.first;
	    int index=it->second.second;
	    
	    //	%tmp = getelementptr [5 x sbyte*]* %tmp, int 0, int 0		; <sbyte**> [#uses=1]
	    index_vector.clear();
	    index_vector.push_back( ConstantInt::get( Type::Int32Ty, 0 ));
	    index_vector.push_back( ConstantInt::get( Type::Int32Ty, index ));
	    Instruction* newElementPtr=new GetElementPtrInst( elementPtr,index_vector.begin(),index_vector.end(),create_unique_name("tmp"),shadow);
	    
	    //create AllocaInst
	    //	%a_addr = alloca int		; <int*> [#uses=3]
	    //	store int %a, int* %a_addr
	    AllocaInst* alloc=new AllocaInst(context->getType(),create_unique_name("jp"),shadow);
	    new StoreInst(context,alloc,placeToPrependThings);
	    
	    //add it to struct
	    //	%a_addr = cast int* %a_addr to sbyte*		; <sbyte*> [#uses=1]
	    //	store sbyte* %a_addr, sbyte** %tmp
	    CastInst* castIn=CastInst::createPointerCast(alloc,PointerType::get(Type::Int8Ty),"",placeToPrependThings);
	    new StoreInst(castIn,newElementPtr,placeToPrependThings);
	  }
	}
      }

      Munger::crossAdviceContextProcessed(shadow,jp_var);
    }

    return;
  }

  /*Find out if cross-advice context of call to extracted method is already packed into a join point struct, and if not do this now.*/
  void Munger::processCrossAdviceContextOfCallToExtractedMethod(Instruction* jp){
    CallInst* shadow=0;
    if(!(shadow=dyn_cast<CallInst>(jp))) return;//intro
    Function* enclosingFunction=shadow->getParent()->getParent();
    Function* calledFunction=shadow->getCalledFunction();//this is the extracted method (has NO cross-advice context yet!)
    Module* module=enclosingFunction->getParent();

    if(!Munger::isCrossAdviceContextProcessed(shadow)){
      int counter=0;

      //gather and store cross-advice context of call shadow (as Munger::getCrossAdviceContext() returns iterators, we need to copy to an intermediate map)
      std::pair<std::multimap<Value*,std::pair<llvm::Value*,int> >::iterator,std::multimap<Value*,std::pair<llvm::Value*,int> >::iterator> shadowCrossContext=Munger::getCrossAdviceContext(shadow);

      std::multimap<llvm::Value*,int> shadowCrossContextMap;

      for(std::multimap<Value*,std::pair<llvm::Value*,int> >::iterator it=shadowCrossContext.first;it!=shadowCrossContext.second;it++){
	shadowCrossContextMap.insert(make_pair(it->second.first,it->second.second));
	counter++;
      }

      for(std::multimap<llvm::Value*,int>::iterator it=shadowCrossContextMap.begin();it!=shadowCrossContextMap.end();it++){
	Munger::addCrossAdviceContext(calledFunction,it->first,it->second);
      }

      //now gather and store cross-advice context of the enclosing function (again, as Munger::getCrossAdviceContext() returns iterators, we need to copy to an intermediate map)
      std::pair<std::multimap<Value*,std::pair<llvm::Value*,int> >::iterator,std::multimap<Value*,std::pair<llvm::Value*,int> >::iterator> enclosingFunctionCrossContext=Munger::getCrossAdviceContext(enclosingFunction);

      std::multimap<llvm::Value*,int> enclosingFunctionCrossContextMap;

      for(std::multimap<Value*,std::pair<llvm::Value*,int> >::iterator it=enclosingFunctionCrossContext.first;it!=enclosingFunctionCrossContext.second;it++){
	enclosingFunctionCrossContextMap.insert(make_pair(it->second.first,it->second.second));
	counter++;
      }

      for(std::multimap<llvm::Value*,int>::iterator it=enclosingFunctionCrossContextMap.begin();it!=enclosingFunctionCrossContextMap.end();it++){
	Munger::addCrossAdviceContext(calledFunction,it->first,it->second);
      }

      //finally, gather and store cross-advice context stored in the enclosing function's annotations
      Annotation* anno=enclosingFunction->getAnnotation(CrossAdviceContextAnnotation::crossID);

      if(anno){
	CrossAdviceContextAnnotation* cAnno=cast<CrossAdviceContextAnnotation>(anno);

	vector<Value*> context=cAnno->getAllContext();
	for(unsigned int i=0;i<context.size();i++){
	  Munger::addCrossAdviceContext(calledFunction,context[i],counter+i);
	}
      }

      std::pair<std::multimap<Value*,std::pair<llvm::Value*,int> >::iterator,std::multimap<Value*,std::pair<llvm::Value*,int> >::iterator> calledFunctionCrossContext=Munger::getCrossAdviceContext(calledFunction);//now it contains all necessary context + the correct indices!
      std::multimap<Value*,std::pair<llvm::Value*,int> > crossContext(calledFunctionCrossContext.first,calledFunctionCrossContext.second);

      const Type* jp_type=module->getTypeByName(string("struct.JOINPOINT"));
      Value* jp_var=0;

      if(crossContext.size()==0){//no cross-advice context (empty range)
	jp_var=Constant::getNullValue(PointerType::get(jp_type));
      }else{
	//create joinpoint struct
	//	%j = alloca %struct.newjp, align 16		; <%struct.newjp*> [#uses=2]
	jp_var=new AllocaInst(jp_type,create_unique_name("jp"),shadow);
	
	//	%tmp = getelementptr %struct.newjp* %j, int 0, uint 0		; <[5 x sbyte*]*> [#uses=1]
	
	vector<Value*> index_vector;
	index_vector.push_back( ConstantInt::get( Type::Int32Ty, 0 ));
	index_vector.push_back( ConstantInt::get( Type::Int32Ty, 0 ));
	Instruction* elementPtr=new GetElementPtrInst( jp_var,index_vector.begin(),index_vector.end(),create_unique_name("tmp"),shadow);
	

	//	int counter=0;
	for(std::multimap<Value*,std::pair<llvm::Value*,int> >::iterator it=crossContext.begin();it!=crossContext.end();it++){
	  Value* context=it->second.first;
	  //	  int index=(counter>=shadowCrossContextSize)?shadowCrossContextSize+it->second.second:it->second.second;//append cross-advice context of enclosing function to that of shadow itself, as we can always query for the shadow's number of cross-advice context
	  int index=it->second.second;
	  
	  //	%tmp = getelementptr [5 x sbyte*]* %tmp, int 0, int 0		; <sbyte**> [#uses=1]
	  index_vector.clear();
	  index_vector.push_back( ConstantInt::get( Type::Int32Ty, 0 ));
	  index_vector.push_back( ConstantInt::get( Type::Int32Ty, index ));
	  Instruction* newElementPtr=new GetElementPtrInst( elementPtr,index_vector.begin(),index_vector.end(),create_unique_name("tmp"),shadow);
	  
	  //create AllocaInst
	  //	%a_addr = alloca int		; <int*> [#uses=3]
	  //	store int %a, int* %a_addr
	  AllocaInst* alloc=new AllocaInst(context->getType(),create_unique_name("jp"),shadow);
	  new StoreInst(context,alloc,shadow);
	  
	  //add it to struct
	  //	%a_addr = cast int* %a_addr to sbyte*		; <sbyte*> [#uses=1]
	  //	store sbyte* %a_addr, sbyte** %tmp
	  CastInst* castIn=CastInst::createPointerCast(alloc,PointerType::get(Type::Int8Ty),"",shadow);
	  new StoreInst(castIn,newElementPtr,shadow);

	  //	  counter++;
	}
      }

      Munger::crossAdviceContextProcessed(shadow,jp_var);
    }

    return;
  }

  void Munger::cleanUp(){
    if(_realMain && _extractedMain){
      std::string extractedName(_realMain->getName());//this looks like "ASPICERE2_EXTRACTED_..."
      _extractedMain->setName(extractedName);
      _realMain->setName("main");
    }

    Munger::flushZombies();
    Munger::flushUnusedAdvice();
  }

  void Munger::flushUnusedAdvice(){
    for(std::set<llvm::Function*>::iterator it=unusedAdvice.begin();it!=unusedAdvice.end();it++){
      (*it)->eraseFromParent();
    }
  }
}

void Munger::flushZombies(){
  Instruction* ins=0;

  for(set<Value*>::iterator it=zombie_shadows.begin();it!=zombie_shadows.end();it++){
    if((ins=dyn_cast<Instruction>(*it))){
      delete ins;
      //      ins->removeFromParent();
      //      ins->eraseFromParent();
    }
  }
}

bool Munger::init(JoinPoint* jp){
  if(check_zombie_status(jp)) return false;
  if(is_vararg_manipulating_function(jp)) {
    //why? these functions are tied to the vararg passed to the enclosing function, and this could be damaged during weaving (extraction, proceed functions, ...)
    std::cout << "[MUNGER] Skipping advice around llvm.va_start or llvm.va_end" << endl;    
    return false;
  }
  if((jp->getTime()=="after_returning")||(jp->getTime()=="after")){
    init_markers(dyn_cast<Instruction>(jp->getShadow()));
  }
  processCrossAdviceContext(jp);
  return true;
}

void Munger::weave(const AfterJoinPoint* jp){
  throw std::string("No implementation yet for weaving after a ")+(this->getDescription())+std::string(" join point!");
}

void Munger::weave(const AroundJoinPoint* jp){
  throw std::string("No implementation yet for weaving around a ")+(this->getDescription())+std::string(" join point!");
}

void Munger::weave(const BeforeJoinPoint* jp){
  throw std::string("No implementation yet for weaving before a ")+(this->getDescription())+std::string(" join point!");
}

void Munger::weave(const IntroJoinPoint* jp){
  throw std::string("No implementation yet for weaving an introduction into a ")+(this->getDescription())+std::string(" join point!");
}
