/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Aspicere2.
 *
 * The Initial Developer of the Original Code is
 * the Ghislain Hoffman Software Engineering Lab, INTEC, University Ghent.
 * Portions created by the Initial Developer are Copyright (C) 2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Bram Adams <bram_DOT_adams_AT_ugent_DOT_be>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "utility/Naming.h"
#include "weaver/Munger.h"
#include <sstream>

using namespace std;
using namespace llvm;

string get_name(Argument* arg,int len){
  string s(arg->getName());
  return s.substr(0,s.size()-len);
}

string extract_variable_name(Argument* arg){
  //  string name=arg->getName();
  string name=get_name(arg);
  unsigned int start=name.find("TYPE__");
  if(start != string::npos){
    unsigned int end=name.rfind("__TYPE",name.length()-1);
    if(end != string::npos){
      start+=6;//length of "TYPE__"
      return name.substr(start,end-start);
    }else return string("");
  }else return string("");
}

const string mangle_advice_name(const string& name,const string& type){
  return string("ASPICERE2__"+name);
}

const string unmangle_advice_name(const string& name){
  int second_underscore=10;//name.find("_",10);
  //    int last_underscore=name.rfind("_",name.length());
  return name.substr(second_underscore+1,name.length());
}

const string create_unique_name(const string& name){
  int counter=Munger::getUniqueInteger();
  stringstream ss;
  ss << name << "_" << counter;
  return ss.str();
}

bool is_advice(const llvm::Function* f){
  return (f->getName().find("ASPICERE2_") != string::npos)&&(f->getName().find("ASPICERE2_stack") == string::npos)&&(f->getName().find("ASPICERE2_clips") == string::npos);
}

bool is_proceed(const llvm::Function* f){
  return f->getName().find("proceed_") != string::npos;
}

bool is_extracted_method(const llvm::Function* f){
  /*  string tmp(f->getName());
      cout << "[CHECK] " << tmp << ":\t" << ((f->getName().find("ASPICERE2_EXTRACTED_") != string::npos)?"YES":"NO") << endl;*/
  return f->getName().find("ASPICERE2_EXTRACTED_") != string::npos;
}
