/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Aspicere2.
 *
 * The Initial Developer of the Original Code is
 * the Ghislain Hoffman Software Engineering Lab, INTEC, University Ghent.
 * Portions created by the Initial Developer are Copyright (C) 2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Bram Adams <bram_DOT_adams_AT_ugent_DOT_be>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#define DEBUG_TYPE "matcher"

#include "reifier/Reifier.h"
#include "reifier/ReifyingVisitor.h"
#include "stripdebug/StripDebugVisitor.h"
#include "utility/Naming.h"
#include "weaver/Munger.h"
#include "llvm/Analysis/CallGraph.h"
#include "llvm/Support/Debug.h"
//#include "llvm/Transforms/Utils/UnifyFunctionExitNodes.h"
#include <iostream>

using namespace llvm;
using namespace std;

namespace {
  char Reifier::ID=0;//value NOT important; address used as ID for pass

  void initUnusedAdvice(Module* m){
    Module::FunctionListType& functions=m->getFunctionList();
    for(Module::FunctionListType::iterator it=functions.begin();it!=functions.end();it++){
      if(is_advice(&*it)) Munger::addUnusedAdvice(&*it);
    }
  }

  void Reifier::getAnalysisUsage(AnalysisUsage &AU) const{
    AU.addRequired<CallGraph>();
    //    AU.setPreservesAll();
    //  AU.addRequired<UnifyFunctionExitNodes>();
  }

  QueryEngine* Reifier::getReification(){
    return &engine;
  }

  bool Reifier::runOnModule(Module &M) {
    initUnusedAdvice(&M);
    if(Munger::nrOfUnusedAdvice()==0){
      std::cout << "No advice: skipping reification..." << endl;
      return false;
    }

    engine.addCallGraph(getAnalysis<CallGraph>());

    StripDebugVisitor stripper(&engine,false);

    try{
      std::cout << "[STRIPPER] First phase..." << endl;
      stripper.visit(M);
      std::cout << "[STRIPPER] Second phase..." << endl;
      stripper.togglePhase();
      stripper.visit(M);

      std::cout << "[REIFIER] Reifying..." << endl;
      //    QueryEngine::setCurrentModule(&M);
      ReifyingVisitor visitor(&engine);
      visitor.visit(M);
    }catch(PlException& ex){
      std::cerr << "*** ERROR occurred during reifying:\t" << (char *)ex << "\t***" << std::endl;
      //      PlCall("mycount");
      throw;
    }

    return false;//nothing modified in IR
  }
  
  RegisterPass<Reifier> X("reify", "Reifies logical program representation");
  //  RegisterOpt<Reifier> X("reify", "Reifies logical program representation");
}
/*extern "C"  void RunOptimizations(PassManager& mgr,...){//cl::opt<OptimizationLevels>& optLevel){
    mgr.add(new Reifier());
    }*/

ModulePass* createReifierPass() {
  return new Reifier();
}
