/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Aspicere2.
 *
 * The Initial Developer of the Original Code is
 * the Ghislain Hoffman Software Engineering Lab, INTEC, University Ghent.
 * Portions created by the Initial Developer are Copyright (C) 2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Bram Adams <bram_DOT_adams_AT_ugent_DOT_be>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#define DEBUG_TYPE "no"

#include "stripdebug/DebugAnnotation.h"
#include "stripdebug/StripDebugVisitor.h"
#include "llvm/Support/Casting.h"
#include "llvm/Support/Debug.h"
#include "llvm/DerivedTypes.h"
#include "llvm/Module.h"
#include "llvm/Type.h"
#include <iostream>
#include <sstream>

using namespace std;
using namespace llvm;

namespace {
  bool function_annotated_yet=false;
  vector<int> currentNumbers(2);//current line and column number
  vector<string> currentLocations(2);//current directory and file name

  void assertDebugInfo(MetaFactBase* engine,Value* V){
      /**
       * dinfo(id,linenr,colnr,dirname,filename)
       */
    /*      vector<llvm::Value*> ptr_args(1);
      vector<llvm::Type*> type_args(0);
      
      ptr_args[0]=V;
      
      engine->insert(string("dinfo"),ptr_args,type_args,currentNumbers,currentLocations);*/

      //assert debuginfo
    DebugInfo* info=new DebugInfo(currentLocations[0],currentLocations[1],currentNumbers[0],currentNumbers[1]);
      engine->addDebugFact(V,info);

      //assert value pointers
      engine->addValuePointer(V);

      //assert type pointers
      //none
  }

  StripDebugVisitor::StripDebugVisitor(QueryEngine* eng,bool phase):metaBase(eng->getMetaBase()),_phase(phase){
    std::cout << "Constructing StripDebugVisitor..." << endl;
  }

  void StripDebugVisitor::visitCastInst(CastInst &I){
    static string alloca_point("alloca point");
    DEBUG(if(inSecondPhase()) return);

    //std::cout << "[CAST] <" << I.getName() << ">" << endl;
    DEBUG(if(I.getName()==alloca_point) I.getParent()->getInstList().erase(&I));
  }

  void StripDebugVisitor::visitInstruction(Instruction &II){
    if(inSecondPhase()) return;

    if (DbgFuncStartInst *I = dyn_cast<DbgFuncStartInst>(&II)) {
      BasicBlock* bb=I->getParent();
      Function* f=bb->getParent();

      GlobalVariable* SP = cast<GlobalVariable>(I->getSubprogram());
      if (!SP->hasInitializer()) return;
      ConstantStruct *SPStruct = cast<ConstantStruct>(SP->getInitializer());
      ConstantInt* SPInt=cast<ConstantInt>(SPStruct->getOperand(7));//start counting from 0 in %llvm.dbg.subprogram.type
      currentNumbers[0]=SPInt->getSExtValue();
      currentNumbers[1]=0;

      //      GlobalVariable* CU = cast<GlobalVariable>(SPStruct->getOperand(5));
      //      if (!CU->hasInitializer()) return;
      //      ConstantStruct *CUStruct = cast<ConstantStruct>(CU->getInitializer());

      Constant* co=SPStruct->getOperand(6);
      ConstantExpr* CUExpr=cast<ConstantExpr>(co);
      GlobalVariable* CUVar=cast<GlobalVariable>(CUExpr->getOperand(0));
      ConstantStruct* CUStruct = cast<ConstantStruct>(CUVar->getInitializer());
      currentLocations[1]=CUStruct->getOperand(3)->getStringValue();      
      
      string tmpDir=CUStruct->getOperand(4)->getStringValue();//problem: sometimes ending in '/', sometimes not; choose the latter
      unsigned int tmpDirLastIndex=tmpDir.size()-1;
      if(tmpDir[tmpDirLastIndex]=='/') currentLocations[0]=tmpDir.erase(tmpDirLastIndex,1);
      else currentLocations[0]=tmpDir;
      
      assertDebugInfo(metaBase,f);

      f->addAnnotation(new DebugAnnotation(currentLocations[0],currentLocations[1]));
      //      std::cout << "[PTR] " << f->getName() << " in " << currentLocations[0] << "<" << currentLocations[1] << ">" << endl;

      //DEBUG(std::cout << "Stripping DbgFuncStartInst..." << endl);
      DEBUG(I->getParent()->getInstList().erase(I));

    }else if(DbgStopPointInst *I = dyn_cast<DbgStopPointInst>(&II)){

      currentNumbers[0]=I->getLine();
      currentNumbers[1]=I->getColumn();

      string tmpDir=I->getDirectory();//problem: sometimes ending in '/', sometimes not; choose the latter
      unsigned int tmpDirLastIndex=tmpDir.size()-1;
      if(tmpDir[tmpDirLastIndex]=='/') currentLocations[0]=tmpDir.erase(tmpDirLastIndex,1);
      else currentLocations[0]=tmpDir;

      currentLocations[1]=I->getFileName();

      //      if(!function_annotated_yet){
      //	Function* f=bb->getParent();
      //	f->addAnnotation(new DebugAnnotation(I->getDirectory(),I->getFileName()));
	/*DebugAnnotation* d=dynamic_cast<DebugAnnotation*>(f->getAnnotation(DebugAnnotation::debugID));
	  cout << "%%% Added annotation for function " << f->getName() << " in file " << d->getFileName() << " of directory " << d->getDirName() << "..." << endl;*/
      //	function_annotated_yet=true;

      //	assertDebugInfo(engine,f);
      //      }

      //DEBUG(std::cout << "Stripping DbgStopPointInst: file <" << I->getDirectory() << I->getFileName() << "> (" << I->getLine() << ":" << I->getColumn() << ")..." << endl);
      DEBUG(I->getParent()->getInstList().erase(I));

    }else if(DbgRegionStartInst *I = dyn_cast<DbgRegionStartInst>(&II)){

      //      DEBUG(std::cout << "Stripping DbgRegionStartInst..." << endl);
      DEBUG(I->getParent()->getInstList().erase(I));

    }else if(DbgRegionEndInst *I = dyn_cast<DbgRegionEndInst>(&II)){

      //      DEBUG(std::cout << "Stripping DbgRegionEndInst..." << endl);
      DEBUG(I->getParent()->getInstList().erase(I));

    }else if(DbgDeclareInst *I = dyn_cast<DbgDeclareInst>(&II)){

      //      DEBUG(std::cout << "Stripping DbgDeclareInst..." << endl);
      DEBUG(I->getParent()->getInstList().erase(I));

    }else if(CallInst *I = dyn_cast<CallInst>(&II)){

      //      if(enough_memory) assertDebugInfo(engine,I);
      assertDebugInfo(metaBase,I);

      /*      Function* called=I->getCalledFunction();
      if(called){
	//no function pointer
	if(called->getName()=="puts"){
	  puts_calls.push_back(I);
	}
	}*/

    }else if(InvokeInst *I = dyn_cast<InvokeInst>(&II)){

      //      if(enough_memory) assertDebugInfo(engine,I);
      assertDebugInfo(metaBase,I);

      /*      Function* called=I->getCalledFunction();
      if(called){
	//no function pointer
	if(called->getName()=="puts"){
	  puts_invokes.push_back(I);
	}
	}*/

    }
  }

  void StripDebugVisitor::visitModule(llvm::Module &M){
    if(inFirstPhase()){
      //safety net
      currentNumbers[0]=0;
      currentNumbers[1]=0;
      currentLocations[0]="";
      currentLocations[1]="";

      return;
    }
      
    DEBUG(Module::GlobalListType& gList=M.getGlobalList();\
    Value* one=Constant::getNullValue(PointerType::get(Type::Int8Ty));\
\
    for(Module::global_iterator it=M.global_begin();it!=M.global_end();it++){\
      Value* v=cast<Value>(it);\
      string vName=v->getName();\
      if(vName.find("llvm.dbg.")!= string::npos){\
	v->uncheckedReplaceAllUsesWith(one);\
	gList.erase(it);\
      }\
    });//the "unchecked..." brings us in temporarily inconsistent state, but once this for-loop reaches these use places, Value* one will be removed
  }

  void StripDebugVisitor::visitFunction(llvm::Function &F){
    DEBUG(if(inFirstPhase()) return;\
\
    string fName=F.getName();\
    if((fName=="llvm.dbg.stoppoint")||(fName=="llvm.dbg.func.start")||(fName=="llvm.dbg.region.start")||(fName=="llvm.dbg.region.end")||(fName=="llvm.dbg.declare")){\
      F.eraseFromParent();\
    });/*else{DOES NOT WORK: on renaming, an integer is appended automatically
      //LLVM 2.0: all arguments now have their index appended:  "define void @f(i32 %Arg1, i32 %OtherArg2) {...}" instead of "define void @f(i32 %Arg, i32 %OtherArg) {...}"
      //we want to undo it, as we regularly rely on the name of arguments
      int index=0;
      int len=1;//number of digits
      for(Function::arg_iterator it=F.arg_begin();it!=F.arg_end();it++){
	string s=(*it).getName();
	(*it).setName(s.substr(0,s.size()-len));
	
	index++;
	if(index==10) len=2;
      }
      }*/
  }
  
  /*do NOT use these, as they override visitInstruction()!!!
  void StripDebugVisitor::visitCallInst(llvm::CallInst &I){//call
    if(inFirstPhase()){
      Function* called=I.getCalledFunction();
      if(called){
	//no function pointer
	if(called->getName()=="puts"){
	  puts_calls.push_back(&I);
	}
      }
    }
  }

  void StripDebugVisitor::visitInvokeInst(llvm::InvokeInst &I){//call
    if(inFirstPhase()){
      Function* called=I.getCalledFunction();
      if(called){
	//no function pointer
	if(called->getName()=="puts"){
	  puts_invokes.push_back(&I);
	}
      }
    }
  }*/

  /*  void StripDebugVisitor::visitDbgInfoIntrinsic(llvm::DbgInfoIntrinsic &I){
    cout << "Stripping DbgInfoIntrinsic..." << endl;
    I.getParent()->getInstList().erase(&I);
  }

  void StripDebugVisitor::visitIntrinsicInst(llvm::IntrinsicInst &I){
    cout << "Stripping IntrinsicInst..." << endl;
    //    I.getParent()->getInstList().erase(&I);
  }

  void StripDebugVisitor::visitDbgFuncStartInst(llvm::DbgFuncStartInst &I){
    cout << "Stripping DbgRegionStartInst..." << endl;
    I.getParent()->getInstList().erase(&I);
  }

  void StripDebugVisitor::visitDbgStopPointInst(llvm::DbgStopPointInst &I){
    cout << "Stripping DbgStopPointInst: file <" << I.getDirectory() << "/" << I.getFileName() << "> (" << I.getLine() << ":" << I.getColumn() << ")..." << endl;
    I.getParent()->getInstList().erase(&I);
  }

  void StripDebugVisitor::visitDbgRegionStartInst(llvm::DbgRegionStartInst &I){
    cout << "Stripping DbgRegionStartInst..." << endl;
    I.getParent()->getInstList().erase(&I);
  }

  void StripDebugVisitor::visitDbgRegionEndInst(llvm::DbgRegionEndInst &I){
    cout << "Stripping DbgRegionEndInst..." << endl;
    I.getParent()->getInstList().erase(&I);
  }

  void StripDebugVisitor::visitDbgDeclareInst(llvm::DbgDeclareInst &I){
    cout << "Stripping DbgDeclareInst..." << endl;
    I.getParent()->getInstList().erase(&I);
    }*/
}
