#include "utility/Util.h"
#include "llvm/BasicBlock.h"
#include "llvm/DerivedTypes.h"
#include "llvm/Function.h"
#include "llvm/Instructions.h"

using namespace llvm;

Instruction* getNextInstruction(Instruction* ins){
  BasicBlock* parent=ins->getParent();
  BasicBlock::iterator it=parent->begin();
  while(it!=parent->end()){
    if(&(*it)==ins){
      return &*(++it);
    }

    ++it;
  }

  return 0;
}

Instruction* getNextNextInstruction(Instruction* ins){
  BasicBlock* parent=ins->getParent();
  BasicBlock::iterator it=parent->begin();
  while(it!=parent->end()){
    if(&(*it)==ins){
      return &*(++(++it));
    }

    ++it;
  }

  return 0;
}

Instruction* getNextNextNextInstruction(Instruction* ins){
  BasicBlock* parent=ins->getParent();
  BasicBlock::iterator it=parent->begin();
  while(it!=parent->end()){
    if(&(*it)==ins){
      return &*(++(++(++it)));
    }

    ++it;
  }

  return 0;
}

llvm::BasicBlock* getNextBasicBlock(llvm::BasicBlock* bas){
  Function* parent=bas->getParent();
  Function::iterator it=parent->begin();
  while(it!=parent->end()){
    if((&*it)==bas){
      return &*(++it);
    }

    ++it;
  }

  return 0;
}

llvm::Instruction* getNextStoreInstruction(llvm::Instruction* ins){
  BasicBlock* parent=ins->getParent();
  BasicBlock::iterator it=parent->begin();
  while(it!=parent->end()){
    if(&(*it)==ins){
      while((++it)!=parent->end()){
	if(dyn_cast<StoreInst>(&(*it))){
	  return &(*it);
	}
      }

      return 0;
    }

    ++it;
  }

  return 0;
}

llvm::Module* getEnclosingModule(llvm::Value* val){
  GlobalValue* glob=0;
  Instruction* ins=0;

  if((ins=dyn_cast<Instruction>(val))){
    return ins->getParent()->getParent()->getParent();
  }else if((glob=dyn_cast<GlobalValue>(val))){
    return glob->getParent();
  }else return 0;
}

llvm::Function* getEnclosingFunction(llvm::Value* val){
  Function* fun=0;
  Instruction* ins=0;

  if((ins=dyn_cast<Instruction>(val))){
    return ins->getParent()->getParent();
  }else if((fun=dyn_cast<Function>(val))){
    return fun;
  }else return 0;
}

  //needed to avoid that in CSOM huge type structure is shown on screen
  bool displayable_type(Type* type,int limit){
    PointerType* ptr=0;
    StructType* stru=0;

    if((ptr=dyn_cast<PointerType>(type))){
      if(!limit) return false;//only look for pointer-struct-pointer-struct-pointer
      Type* el=(Type*)ptr->getElementType();
      while((ptr=dyn_cast<PointerType>(el))){
	el=(Type*)ptr->getElementType();
      }

      if((stru=dyn_cast<StructType>(el))){
	for(StructType::element_iterator it=stru->element_begin();it!=stru->element_end();it++){
	  if(!displayable_type(*it,limit-1)) return false;
	}
	return true;
      }else return true;
    }else return true;
  }
