/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Aspicere2.
 *
 * The Initial Developer of the Original Code is
 * the Ghislain Hoffman Software Engineering Lab, INTEC, University Ghent.
 * Portions created by the Initial Developer are Copyright (C) 2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Bram Adams <bram_DOT_adams_AT_ugent_DOT_be>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#define DEBUG_TYPE "utils"

#include "stripdebug/CrossAdviceContextAnnotation.h"
#include "utility/Cloning.h"
#include "utility/Naming.h"
#include "utility/Util.h"
#include "weaver/Munger.h"
#include "weaver/Utils.h"
#include "llvm/GlobalVariable.h"
#include "llvm/Module.h"
#include "llvm/Support/Debug.h"
#include "llvm/Type.h"
//#include "llvm/SymbolTable.h"
#include <iostream>

using namespace std;
using namespace llvm;

namespace{
  void recursivelyRemoveAllUses(Instruction* inst){
    int numOfUses=inst->getNumUses();

    if(numOfUses!=0){
      int counter=1;
      for(Value::use_iterator it=inst->use_begin();it!=inst->use_end();it++){
	std::cout << (counter)++;
	it->print(std::cout);
	Instruction* inst=cast<Instruction>(it);
	recursivelyRemoveAllUses(inst);
      }
    }

    inst->eraseFromParent();
  }
}

bool isParameterisedAdvice(llvm::Function* advice){
 for(Function::arg_iterator it=advice->arg_begin();it!=advice->arg_end();it++){
    string typeVarName=extract_variable_name(&*it);//unmangled name if it's a type var

    if(typeVarName!=""){//it's a type variable
      //      cout << "[DEBUG] " << it->getName() << " is a type variable denoting " << typeVarName << ", so " << advice->getName() << " is parameterised advice." << endl;
      return true;
    }/*else{
      cout << "[DEBUG] " << it->getName() << " is no type variable..." << endl;
      }*/
 }

 return false;
}

bool is_vararg_manipulating_function(JoinPoint* jp){
  CallInst* shadow=0;
  
  if((shadow=dyn_cast<CallInst>(jp->getShadow()))){//check for intro
    Function* calledFunction=shadow->getCalledFunction();
    string fName=calledFunction->getName();
    
    if(fName=="llvm.va_start"){
      return true;
    }else if(fName=="llvm.va_end"){
      return true;
    }
  }
  
  return false;
}

/**
 * Clone advice possibly containing type parameters and also fill in a map of dummy types to real, unmangled types.
 */
llvm::Function* cloneParameterisedAdvice(llvm::Function* advice,llvm::Instruction* shadow,Context* context,map<Type*,Type*>& dummyTypeToContextType,vector<Value*>* extra_advice_args,bool shadow_actuals_need_to_be_added){
  //0. a. run through advice args and find out what the type names are; also determine whether the return type is a parameter
  //   b. mapping needed of mangled types to context variable varname's value (a type) by looking at TYPE__varname__TYPE-arg and its mangled type
  Module* module=advice->getParent();
  Type* returnType=(Type*)advice->getReturnType();
  set<string> typeArgumentNames;

  int index=0;
  int len=1;
  for(Function::arg_iterator it=advice->arg_begin();it!=advice->arg_end();it++){
    Type* type=(Type*)it->getType();
    string typeVarName=extract_variable_name(&*it);//unmangled name if it's a type var
    string name(get_name(it,len));

    std::cout << "[CLONING] Variable " << name << " -> " << (displayable_type(type)?type->getDescription():"<too complex to print out>") << endl;

    if(typeVarName!=""){//it's a type variable
      typeArgumentNames.insert(get_name((Argument*)(&*it)));//DANGER: keep it like this to not break Cloning.h's functions? NO
      Type* realType=context->lookupType(typeVarName);
      dummyTypeToContextType[type]=realType;
      std::cout << "[TYPEMAP] " <<  (displayable_type(type)?type->getDescription():"<too complex to print out>") << " -> " <<  (displayable_type(realType)?realType->getDescription():"<too complex to print out>") << endl;
      if(returnType==type){
	returnType=realType;//clone should get the actual bound type
	continue;
      }
    }

    index++;
    if(index==10) len=2;
  }

  //add actuals of advised call as extra argument to around advice-clone
  std::vector<pair<string,Type*> > extraArgs;

  /******************************************************************************************************************
   * QUESTION: is extra_advice_args subsumed because return variable is inserted right behind join point struct?    *
   *           ... or does extra_advice_args have a role when return variable has type parameter as its type?       *
   ******************************************************************************************************************/
  //existing Values: just add it to signature (no AllocaInst needed)
  /*  if(extra_advice_args){
    int j=0;
    for(vector<Value*>::iterator it=extra_advice_args->begin();it!=extra_advice_args->end();it++){
      string argName=append_number_to_string("extra",j++);
      Type* type=(Type*)(*it)->getType();
      cout << "[CLONING] Extra advice arg " << argName << " -> " << type->getDescription() << endl;
      extraArgs.push_back(make_pair(argName,type));
    }
    }*/

  if(shadow_actuals_need_to_be_added){
    unsigned int i=1;
    if(Munger::isCallToExtractedMethod(shadow)) i++;//skip artificial join point struct (body extraction)

    for(;i<shadow->getNumOperands();i++){//use actuals instead of formals: vararg functions possible!!!
      Value* arg=shadow->getOperand(i);
      Type* type=(Type*)arg->getType();
      std::cout << "Found shadow actual of type " << (displayable_type(type)?type->getDescription():"<too complex to print out>") << " (" << module->getTypeName(type) << ")"  << endl;
      
      //args.push_back(arg);
      string argName=append_number_to_string("arg",i);
      new AllocaInst(type,argName,shadow);
      //argPtrs.push_back(new AllocaInst(type,argName,shadow));
      
      //this can happen too in the meantime
      extraArgs.push_back(make_pair(argName,type));
    }
  }

  /*  cout << "[DEBUG] Dumping type map:" << endl;
  for(std::map<llvm::Type*,llvm::Type*>::iterator it=dummyTypeToContextType.begin();it!=dummyTypeToContextType.end();it++){
    cout << it->first << " -> " << it->second << endl;
    }*/

  //1. create fresh advice stub with unique name
  //   use original address of advised call in name? <--> multiple advice at same join point 
  //   => use static counter in Munger
  DenseMap<const Value*, Value*> ValueMap;
  return cloneFunctionWithOtherReturnType(advice,returnType,create_unique_name(advice->getName()),ValueMap,extraArgs,0,dummyTypeToContextType,typeArgumentNames);
}

void insertCrossAdviceContext(llvm::Function* F){
  Annotation* anno=F->getAnnotation(CrossAdviceContextAnnotation::crossID);

  if(anno){
    CrossAdviceContextAnnotation* cAnno=cast<CrossAdviceContextAnnotation>(anno);
    //    if(cAnno->isProcessed()) return;
    vector<Value*> context=cAnno->getAllContext();

    BasicBlock::InstListType& list=F->getEntryBlock().getInstList();
    BasicBlock::iterator itt=F->getEntryBlock().begin();
    for(vector<Value*>::iterator it=context.begin();it!=context.end();it++){
      Value* val=*it;
      Instruction* inst=0;
      if((inst=dyn_cast<Instruction>(val))){
	list.insert(itt,inst);
      }else{
	throw string("Other cross-advice context than Instruction*-objects are NOT supported yet...");
      }
    }

    //    cAnno->setProcessed(true);
  }else return;
}

/**
 * Look if context variable is cross-advice; if so replace all uses of variable by struct member in *advice* (if this already happened, replaceAllUses() will notice that); NOT the calling method, and return null; else return context variable
*/
Value* getActualForContextVariable(JoinPoint* jp,const std::string& varName,Function* advice,llvm::Instruction* locationBeforeWhichToWeave){
  static multimap<Function*,Argument*> adviceToCrossContext;

  CallInst* shadow=cast<CallInst>(jp->getShadow());
  Context* context=jp->getContext();
  Value* res=context->lookupValue(varName);//some extra boilerplating code needed, hence the rest of this method
  Module* module=advice->getParent();
  Context::KindOfContext kind=context->lookupKind(varName);

  if(kind==Context::CROSSADVICE){
    std::pair<std::multimap<Value*,std::pair<llvm::Value*,int> >::iterator,std::multimap<Value*,std::pair<llvm::Value*,int> >::iterator> cross_context=Munger::getCrossAdviceContext(shadow);

    //    if(cross_context.first!=cross_context.second){//variable is cross-advice context
    bool processed=false;

    for(std::multimap<Value*,std::pair<llvm::Value*,int> >::iterator it=cross_context.first;it!=cross_context.second;it++){
      Value* var=it->second.first;//a context variable
      int index=it->second.second;

      std::cout << "[CROSSADVICE] " << res << " <--> " << var << " (" << index << ")" << endl;

      if(var==res){//it's this context variable we possibly need to process
	//first check using map of advice to var if not processed before
	Function::arg_iterator at=advice->arg_begin();
	int len_index=0;
	int len=1;
	for(;at!=advice->arg_end();at++){
	  if(get_name(at,len)==varName) break;

	  len_index++;
	  if(len_index==10) len=2;
	}
	Argument* relevantArgument=&*at;

	bool todo=true;
	std::pair<std::multimap<Function*,Argument*>::iterator,std::multimap<Function*,Argument*>::iterator> cross_context_of_this_advice=adviceToCrossContext.equal_range(advice);
	for(std::multimap<Function*,Argument*>::iterator itt=cross_context_of_this_advice.first;itt!=cross_context_of_this_advice.second;itt++){
	  if(relevantArgument==itt->second){
	    todo=false;//already processed
	    break;
	  }
	}

	if(todo){//not processed yet
	  //allocate variable V with value of index-th element struct at the start of the advice's entry block
	  Instruction* placeToPrependThings=0;

	  placeToPrependThings=&(advice->getEntryBlock().front());
	    
	  //	%tmp1 = getelementptr %struct.newjp* %j, int 0, uint 0		; <[5 x sbyte*]*> [#uses=1]
	  //	%tmp2 = getelementptr [5 x sbyte*]* %tmp1, int 0, int 1		; <sbyte**> [#uses=1]
	  //	%tmp = load sbyte** %tmp2		; <sbyte*> [#uses=1]
	  vector<Value*> index_vector;
	  index_vector.push_back( ConstantInt::get( Type::Int32Ty, 0 ));
	  index_vector.push_back( ConstantInt::get( Type::Int32Ty, 0 ));
	  Instruction* elementPtr=new GetElementPtrInst( advice->arg_begin(),index_vector.begin(),index_vector.end(),create_unique_name("tmp"),placeToPrependThings);

	  index_vector.clear();
	  index_vector.push_back( ConstantInt::get( Type::Int32Ty, 0 ));
	  index_vector.push_back( ConstantInt::get( Type::Int32Ty, index ));
	  elementPtr=new GetElementPtrInst( elementPtr,index_vector.begin(),index_vector.end(),create_unique_name("tmp"),placeToPrependThings);

	  LoadInst* structElement=new LoadInst(elementPtr,"",placeToPrependThings);
	  Instruction* casted=0;

	  //PointerType* ptrType=0;
	  if(relevantArgument->getType()==var->getType()){//get_local_variable_ref
	    casted=new BitCastInst(structElement,PointerType::get(var->getType()),"bit",placeToPrependThings);
	  }else{//intro
	    casted=new BitCastInst(structElement,var->getType(),"bitb",placeToPrependThings);
	  }

	  LoadInst* structElementCastAndLoadedRight=new LoadInst(casted,"",placeToPrependThings);
	  relevantArgument->uncheckedReplaceAllUsesWith(structElementCastAndLoadedRight);


	  
	  /*	  if((ptrType=dyn_cast<PointerType>((Type*)var->getType()))){
	    //	    casted=CastInst::createPointerCast(structElement,var->getType(),"",placeToPrependThings);

	    Type* elType=(Type*)ptrType->getElementType();
	    if(!dyn_cast<StructType>(elType)){
	      LoadInst* structElementCastAndLoadedRight=new LoadInst(casted,"",placeToPrependThings);
	      //replace all uses of var by V
	      relevantArgument->uncheckedReplaceAllUsesWith(structElementCastAndLoadedRight);
	    }else{
	      //	      LoadInst* structElementCastAndLoadedRight=new LoadInst(casted,"",placeToPrependThings);
	      //replace all uses of var by V
	      relevantArgument->uncheckedReplaceAllUsesWith(casted);
	    }
	    }else{*/
	    //	    casted=new BitCastInst(structElement,PointerType::get(var->getType()),"bit",placeToPrependThings);


	    //replace all uses of var by V
	    /*if(relevantArgument->getType()==structElementCastAndLoadedRight->getType()){

	    }else{
	      relevantArgument->uncheckedReplaceAllUsesWith(new LoadInst(structElementCastAndLoadedRight,"",placeToPrependThings));
	      }*/
	    /*	  }*/

	  //  cout << "[MAPPING] " << advice << " to " << res << endl;
	  adviceToCrossContext.insert(make_pair(advice,relevantArgument));
	}

	//return null
	//	if(dyn_cast<PointerType>(var->getType())){
	  /*SequentialType* ty=cast<SequentialType>((Type*)var->getType());
	  Type* elType=(Type*)ty->getElementType();

	  if(dyn_cast<StructType>(elType)){*/
	  //	    res=Constant::getNullValue(var->getType());//var's type is actual's type (in case of pointer to struct)
	    res=Constant::getNullValue(relevantArgument->getType());//var's type is actual's type (in case of pointer to struct)
	    /*}else{
	    res=Constant::getNullValue(elType);//var's type is pointer to actual's type
	    }*/
	    /*	}else{
	  res=Constant::getNullValue(var->getType());//var's type is actual's type	  
	  }*/

	processed=true;	  
	break;
      }
    }

    if(!processed) throw string("Cross-advice context NOT found in provided context...");
  }else if(kind==Context::CONSTANT){
    std::cout << "[CONTEXT] constant: " << (displayable_type((Type*)res->getType())?res->getType()->getDescription():"<too complex to print out>") << " (" << res->getType() << ")" << endl;
    const Type* resType=res->getType();
    if(resType->getTypeID()==Type::ArrayTyID){
      vector<Value*> index_vector;
      index_vector.push_back( ConstantInt::get( Type::Int32Ty, 0 ));
      index_vector.push_back( ConstantInt::get( Type::Int32Ty, 0 ));
      res=new GetElementPtrInst(new GlobalVariable(resType,true,GlobalValue::InternalLinkage,(Constant*)res,"",module),index_vector.begin(),index_vector.end(),"",locationBeforeWhichToWeave);	  
    }else if(!resType->isPrimitiveType() && !resType->isInteger()){//dereference pointer <--> does this work with int* instead of int[]???
      vector<Value*> index_vector;
      index_vector.push_back( ConstantInt::get( Type::Int32Ty, 0 ));
      index_vector.push_back( ConstantInt::get( Type::Int32Ty, 0 ));	  
      res=new GetElementPtrInst(new GlobalVariable(resType,true,GlobalValue::InternalLinkage,(Constant*)res,"",module),index_vector.begin(),index_vector.end(),"",locationBeforeWhichToWeave);	  
    }else{
      res=new LoadInst(new GlobalVariable(resType,true,GlobalValue::InternalLinkage,(Constant*)res,"",module),"",locationBeforeWhichToWeave);
    }
  }else if(kind==Context::GLOBAL){
    std::cout << "[CONTEXT] global value: " <<  (displayable_type((Type*)res->getType())?res->getType()->getDescription():"<too complex to print out>") << " (" << res->getType() << ")" << endl;
    res=new LoadInst((GlobalValue*)res,"",locationBeforeWhichToWeave);
  }else if(kind==Context::ARGUMENT){
    std::cout << "[CONTEXT] argument: " << (displayable_type((Type*)res->getType())?res->getType()->getDescription():"<too complex to print out>") << " (" << res->getType() << ")" << endl;
    //problem here: res can be an Argument of the original Function containing shadow, but as shadow has moved down the cfg res doesn't refer to something of the current enclosing Function
    //=> possible that all proceeds in chain need to pass extra context down -> collect enough info from matches? (cf. abc)
    //<--> SOLUTION: because of extraction of execution join points, the Argument's in question correspond to the shadow's actuals!
    int index=context->index(varName)+1;
    if(Munger::isCallToExtractedMethod(shadow)) index++;//adjust for artificial join point struct (body extraction)
    res=shadow->getOperand(index);
  }else if(kind==Context::ACTUAL){
    //	}else{
    std::cout << "[CONTEXT] actual: " << (displayable_type((Type*)res->getType())?res->getType()->getDescription():"<too complex to print out>") << " (" << res->getType() << ")" << endl;
    //actuals of call: same problem <--> here context IS passed as actuals of various proceed-calls, so just find out the index in the actual list of shadow
    //if(enclosing_function==advice){
    //  for(all users of this advice){
    //    if(res is argument of users's parent Function) capture index of res in arg list
    //    else recursively repeat
    //  }
    //}else{
    //  no problem
    //}
    
    /**************************************************************************************************************************
     * QUESTION: is following also needed?
     *     if(Munger::isCallToExtractedMethod(shadow)) index++;//adjust for artificial join point struct (body extraction)
     **************************************************************************************************************************/
    Function* enclosingFunction=shadow->getParent()->getParent();
    if(is_proceed(enclosingFunction)){
      res=shadow->getOperand(context->index(varName)+1);
    }

  }else if(kind==Context::CROSSFUNCTION){
    std::cout << "[CROSSFUNCTION] " << res << " --> " <<  (displayable_type((Type*)res->getType())?res->getType()->getDescription():"<too complex to print out>") << " (" << res->getType() << ")" << endl;
    //    throw string("Cross-function context not treated yet!");
    vector<Value*> actuals;
    actuals.push_back(context->getStack(varName));
    actuals.push_back(ConstantInt::get(Type::Int32Ty,context->index(varName)));
    res=new LoadInst(new BitCastInst(new CallInst(module->getFunction("__ASPICERE2_stack_peek"),actuals.begin(),actuals.end(),"",locationBeforeWhichToWeave),PointerType::get(context->lookupValue(varName)->getType()),"",locationBeforeWhichToWeave),"",locationBeforeWhichToWeave);
  }else{
    throw string("This kind of context is unknown: "+kind);
  }/*else if(kind==Context::CROSSADVICE){
     res=getActualForContextVariable((JoinPoint*)jp,varName,advice_stub);
     }*/

  return res;
}

vector<Value*> get_context_actuals(JoinPoint* jp,llvm::Function* enclosingFunction,Function* advice,Function* advice_stub,Context* context,std::map<llvm::Type*,llvm::Type*>& dummyTypeToContextType,llvm::Instruction* locationBeforeWhichToWeave){
  vector<Value*> advice_actuals;
  int positions_of_type_args_counter=0;
  std::vector<int> positions_of_type_args;
  Module* module=advice->getParent();
  //  module->getSymbolTable().dump();
  bool jp_struct_processed=false;//after returning has extra return var (not in context) => ignore it (will be added in get_advice_actuals)

  int index=0;
  int len=1;
  for(Function::arg_iterator it=advice->arg_begin();it!=advice->arg_end();it++){
    Type* type=(Type*)it->getType();
    string varName=get_name(it,len);//full variable name
    string typeVarName=extract_variable_name(&*it);//unmangled name if it's a type var
    std::cout << "[CONTEXT] Found context actual " << varName << " of type " << (displayable_type(type)?type->getDescription():"<too complex to print out>") << " (" << module->getTypeName(type) << ")" << endl;
    
    if(typeVarName!=""){//it's a type variable
      //      Type* realType=context->lookupType(typeVarName);
      //      dummyTypeToContextType[type]=realType;
      //      if(returnType==type) returnType=realType;//clone should get the actual bound type

      positions_of_type_args.push_back(positions_of_type_args_counter);
      advice_actuals.push_back(Constant::getNullValue(type));
      std::cout << "ADDED:\t" << varName << endl;
    }else{//normal variable
      Value* val=context->lookupValue(varName);
      if(val){
	///	Context::KindOfContext kind=context->lookupKind(varName);
	//	advice_actuals.push_back(val);
	advice_actuals.push_back(getActualForContextVariable(jp,varName,advice_stub,locationBeforeWhichToWeave));
	std::cout << "ADDED:\t" << varName << endl;
      }else if(!jp_struct_processed){ //JOINPOINT*, which is NOT a part of the context variables
	//	vector<Value*> argPtrs;
	//	vector<Value*> args;
	//	Value* jp_var=generate_joinpoint_struct_prologue(jp,shadow,advice,module,calledFunction,enclosingFunction,argPtrs,args);
	Value* jp_var=Munger::isCrossAdviceContextProcessed(jp->getShadow());
	Instruction* tmp=0;
	if((tmp=dyn_cast<Instruction>(jp_var))){
	  Function* definingFunction=tmp->getParent()->getParent();
	  if(definingFunction==enclosingFunction){//directly use join point struct defined in surrounding Function F instead of F's first argument
	    //	generate_joinpoint_struct_epilogue(jp,jp_var,shadow->getNext(),advice);
	    //	advice_actuals.push_back(Constant::getNullValue(type));//JOINPOINT*
	    advice_actuals.push_back(jp_var);//JOINPOINT*
	  }else{
	    advice_actuals.push_back(&*(enclosingFunction->arg_begin()));//JOINPOINT*
	  }
	}else advice_actuals.push_back(jp_var);//JOINPOINT*
	jp_struct_processed=true;
	std::cout << "ADDED:\t" << varName << endl;
      }else{
	std::cout << "[BAD NEWS] Context variable is null..." << endl;
      }
    }

    positions_of_type_args_counter++;

    index++;
    if(index==10) len=2;
  }

  //remove all type argument uses (null has been passed)
  Function::arg_iterator arg_it=advice_stub->arg_begin();
  //  int arg_counter=0;
  int prev_pos=0;
  for(vector<int>::iterator pos_index=positions_of_type_args.begin();pos_index!=positions_of_type_args.end();pos_index++){
    //    vector<Instruction*> toBeErased;
    int pos=*pos_index;
    for(int i=0;i<pos-prev_pos;i++) arg_it++;
    prev_pos=pos;

    Argument* arg=&*arg_it;
    Type* arg_type=(Type*)arg->getType();
    Type* real_type=dummyTypeToContextType[arg_type];

    /*    for(std::map<llvm::Type*,llvm::Type*>::iterator ot=dummyTypeToContextType.begin();ot!=dummyTypeToContextType.end();ot++){
      std::cout << "HELP: " << (ot->first?ot->first->getDescription():"NULL") << " -- " << (ot->second?ot->second->getDescription():"NULL") << endl;
      }*/

    //    cout << "[DEBUG] " << arg_type->getDescription() << " <--> " << real_type->getDescription() << endl;
    if(real_type!=Type::VoidTy) arg->uncheckedReplaceAllUsesWith(Constant::getNullValue(real_type));
    else{//remove usage of void type parameters
      arg->uncheckedReplaceAllUsesWith(Constant::getNullValue(Type::Int8Ty));
      /*      int counter=1;
      arg->print(cout);
      for(Value::use_iterator it=arg->use_begin();it!=arg->use_end();it++){
	cout << (counter)++;
	it->print(cout);
	Instruction* inst=cast<Instruction>(it);
	recursivelyRemoveAllUses(inst);
	}*/
    }
  }
  
  return advice_actuals;
}

std::vector<llvm::Value*> get_advice_actuals(JoinPoint* jp,llvm::Function* enclosingFunction,llvm::Function* advice,llvm::Function* advice_stub,Context* context,std::map<llvm::Type*,llvm::Type*>& dummyTypeToContextType,llvm::Instruction* locationBeforeWhichToWeave,vector<Value*>* extra_advice_args,bool shadow_actuals_need_to_be_added){

  //add advice actuals for all context variables
  vector<Value*> advice_actuals=get_context_actuals((JoinPoint*)jp,enclosingFunction,advice,advice_stub,context,dummyTypeToContextType,locationBeforeWhichToWeave);

  /*  for(unsigned int i=0;i<advice_actuals.size();i++){
    std::cout << "TEST:\t" << advice_actuals[i]->getType()->getDescription() << endl;
    }*/

  //add extra advice actuals (e.g. return value for after returning)
  if(extra_advice_args){
    vector<Value*>::iterator right_position=advice_actuals.begin();
    right_position++;//behind jp struct
    for(vector<Value*>::iterator it=extra_advice_args->begin();it!=extra_advice_args->end();it++){
      right_position=advice_actuals.insert(right_position,*it);
      right_position++;//behind newly added actual
    }
  }

  //add call shadow arguments to advice actuals
  if(shadow_actuals_need_to_be_added){
    CallInst* shadow=cast<CallInst>(jp->getShadow());

    unsigned int i=1;
    if(Munger::isCallToExtractedMethod(shadow)) i++;//first join point struct arg is exactly the same as the advice-call's (and proceed-call's) one!
    for(;i<shadow->getNumOperands();i++) advice_actuals.push_back(shadow->getOperand(i));
  }

  //debugging advice actuals
  std::vector<Value*>::iterator it=advice_actuals.begin();
  Function::const_arg_iterator I = advice_stub->arg_begin();
  DEBUG(std::cout << "[ACTUAL OF ADVICE CALL] formals <--> actuals:" << endl);
  for (Function::const_arg_iterator E = advice_stub->arg_end();I != E && it!=advice_actuals.end(); ++I,it++){
    DEBUG(std::cout << "[ACTUAL OF ADVICE CALL] " <<  (displayable_type((Type*)I->getType())?I->getType()->getDescription():"<too complex to print out>") << "(" << I->getType() << ") <--> " <<  (displayable_type((Type*)(*it)->getType())?(*it)->getType()->getDescription():"<too complex to print out>") << "(" << (*it)->getType() << ")" << endl);
  }
  if(it!=advice_actuals.end()){
    std::cout << "[ACTUAL OF ADVICE CALL] There are more actuals than formals:" << endl;
    for (;it!=advice_actuals.end(); it++){
      std::cout << "[ACTUAL OF ADVICE CALL] " <<  (displayable_type((Type*)(*it)->getType())?(*it)->getType()->getDescription():"<too complex to print out>") << "(" << (*it)->getType() << ")" << endl;
    }
  }else if(I!=advice_stub->arg_end()){
    std::cout << "[ACTUAL OF ADVICE CALL] There are more formals than actuals:" << endl;
    for (Function::const_arg_iterator E = advice_stub->arg_end();I != E; ++I){
      std::cout << "[ACTUAL OF ADVICE CALL] " <<  (displayable_type((Type*)I->getType())?I->getType()->getDescription():"<too complex to print out>") << "(" << I->getType() << endl;
    }
  }

  return advice_actuals;
}

bool repairTypeParameterisedVariable(llvm::Instruction* instruction,std::map<llvm::Type*,llvm::Type*>& dummyTypeToContextType){
  AllocationInst* alloca=0;
  CastInst* castInst=0;
  LoadInst* loadInst=0;
  StoreInst* storeInst=0;
  CmpInst* cmpInst=0;

  if((alloca=dyn_cast<AllocaInst>(&*instruction))){
    //a. remove all uses of TYPE-parameters: loop over all allocas and replace them with alloca of right type	
    Type* allocaType=(Type*)alloca->getAllocatedType();
    Type* newAllocaType=cloneAndChangeElementType(allocaType,dummyTypeToContextType);
    if(newAllocaType!=allocaType){//var whose type is denoted by type parameter
      //replace old alloca with new one
      if(newAllocaType==Type::VoidTy) newAllocaType=(Type*)(Type::Int8Ty);
      AllocaInst* newAlloca=new AllocaInst(newAllocaType,alloca->getArraySize(),alloca->getAlignment(),"",alloca);
      alloca->uncheckedReplaceAllUsesWith(newAlloca);
      alloca->eraseFromParent();
    }
  }else if((alloca=dyn_cast<MallocInst>(&*instruction))){
    //a. remove all uses of TYPE-parameters: loop over all mallocs and replace them with alloca of right type	
    Type* mallocType=(Type*)alloca->getAllocatedType();
    Type* newMallocType=cloneAndChangeElementType(mallocType,dummyTypeToContextType);
    if(newMallocType!=mallocType){//var whose type is denoted by type parameter
      //replace old malloc with new one
      //      if(newMallocType==Type::VoidTy) newMallocType=Type::SByteTy;
      MallocInst* newMalloc=new MallocInst(newMallocType,alloca->getArraySize(),alloca->getAlignment(),"",alloca);
      alloca->uncheckedReplaceAllUsesWith(newMalloc);
      alloca->eraseFromParent();
    }
  }else if((castInst=dyn_cast<CastInst>(&*instruction))){
    //a. remove all uses of TYPE-parameters: loop over all casts and replace them with alloca of right type	
    Type* castType=(Type*)castInst->getType();
    Type* newCastType=cloneAndChangeElementType(castType,dummyTypeToContextType);
    if(newCastType!=castType){//var whose type is denoted by type parameter
      //replace old cast with new one
      //      if(newCastType==Type::VoidTy) newCastType=Type::SByteTy;
      Value* v=castInst->getOperand(0);
      Type* v_type=(Type*)v->getType();
      CastInst* newCast=0;

      if(v_type->isInteger()){
	newCast=CastInst::createIntegerCast(v,newCastType,((IntegerType*)v_type)->getSignBit(),"",castInst);
      }else if(v_type->isFloatingPoint()){
	newCast=CastInst::createFPCast(v,newCastType,"",castInst);
      }else if(newCastType->getTypeID()==Type::VoidTyID){
	//cast to void => most-probably not used anywhere => do no-op cast to source type
	newCast=CastInst::createPointerCast(v,v_type,"",castInst);
      }else{//pointer
	newCast=CastInst::createPointerCast(v,newCastType,"",castInst);
      }
      castInst->uncheckedReplaceAllUsesWith(newCast);
      castInst->eraseFromParent();
    }else{//maybe cast tries to cast to a dereferenced type parameter
      newCastType=cloneAndChangeElementType(PointerType::get(castType),dummyTypeToContextType);
      if(newCastType!=PointerType::get(castType)){//var whose type is denoted by type parameter
	newCastType=(Type*)cast<PointerType>(newCastType)->getElementType();
	//replace old cast with new one
	//      if(newCastType==Type::VoidTy) newCastType=Type::SByteTy;
	CastInst* newCast=0;
	if(dyn_cast<PointerType>(castInst->getSrcTy())){
	  newCast=CastInst::createPointerCast(castInst->getOperand(0),newCastType,"",castInst);
	}else if(castInst->getSrcTy()->isInteger()){
	  newCast=CastInst::createIntegerCast(castInst->getOperand(0),newCastType,((IntegerType*)castInst->getSrcTy())->getSignBit(),"",castInst);
	}else{//floating point
	  newCast=CastInst::createFPCast(castInst->getOperand(0),newCastType,"",castInst);
	}
	castInst->uncheckedReplaceAllUsesWith(newCast);
	castInst->eraseFromParent();
      }
    }
  }else if((loadInst=dyn_cast<LoadInst>(&*instruction))){
    //a. remove all uses of TYPE-parameters: loop over all loads and replace them with alloca of right type	
    Type* loadType=(Type*)loadInst->getType();
    Type* newLoadType=cloneAndChangeElementType(PointerType::get(loadType),dummyTypeToContextType);//use PointerType::get(...) because type of LoadInst is dereferenced type of operand, so the operand's type is in dummyTypeToContextType, but LoadInst's type is NOT

    if(newLoadType!=PointerType::get(loadType)){//var whose type is denoted by type parameter
      //replace old load with new one
      //      if(newLoadType==Type::VoidTy) newLoadType=Type::SByteTy;
      Value* op=loadInst->getOperand(0);
      LoadInst* newLoad=new LoadInst(op,"",loadInst->isVolatile(),getNextInstruction(loadInst));
      loadInst->uncheckedReplaceAllUsesWith(newLoad);
      loadInst->eraseFromParent();
    }
  }else if((storeInst=dyn_cast<StoreInst>(&*instruction))){
    //a. remove all uses of TYPE-parameters: loop over all stores and replace them with alloca of right type
    Value* firstOperand=storeInst->getOperand(0);
    Type* storeType=(Type*)firstOperand->getType();
    Constant* cons=0;
    if((cons=dyn_cast<Constant>(firstOperand))&&(cons==Constant::getNullValue(storeType))){//only useful if type parameter has constant value zero
      Type* newStoreType=cloneAndChangeElementType(storeType,dummyTypeToContextType);
      if(newStoreType!=storeType){//var whose type is denoted by type parameter
	//replace old store with new one
	if(newStoreType!=Type::VoidTy){
	  StoreInst* newStore=new StoreInst(Constant::getNullValue(newStoreType),storeInst->getOperand(1),storeInst->isVolatile(),storeInst);
	  storeInst->uncheckedReplaceAllUsesWith(newStore);
	}
	storeInst->eraseFromParent();
      }
    }
  }else if((cmpInst=dyn_cast<CmpInst>(&*instruction))){
    Value* firstOperand=cmpInst->getOperand(0);
    Type* cmpType=(Type*)firstOperand->getType();
    std::map<llvm::Type*,llvm::Type*>::iterator it=dummyTypeToContextType.find(cmpType);
    if(it!=dummyTypeToContextType.end()){
      Type* real_type=it->second;
      Constant* cons=0;
      if((cmpType!=real_type)&&(cons=dyn_cast<Constant>(firstOperand))&&(cons==Constant::getNullValue(cmpType))){//only useful if type parameter has constant value zero
	
	//replace old store with new one
	if(real_type!=Type::VoidTy){
	  cmpInst->setOperand(0,Constant::getNullValue(real_type));
	}
      }
    }

    Value* secondOperand=cmpInst->getOperand(1);
    cmpType=(Type*)secondOperand->getType();
    it=dummyTypeToContextType.find(cmpType);
    if(it!=dummyTypeToContextType.end()){
      Type* real_type=it->second;
      Constant* cons=0;
      if((cmpType!=real_type)&&(cons=dyn_cast<Constant>(secondOperand))&&(cons==Constant::getNullValue(cmpType))){//only useful if type parameter has constant value zero
	
	//replace old store with new one
	if(real_type!=Type::VoidTy){
	  cmpInst->setOperand(1,Constant::getNullValue(real_type));
	}
      }
    }

  }else return false;

  return true;
}

void init_markers(Instruction* shadow){
  if(!Munger::getContextMarker(shadow)){
    Instruction* next=getNextInstruction(shadow);
    Instruction* contextMarker=BinaryOperator::create(Instruction::Add,Constant::getNullValue(Type::Int32Ty),Constant::getNullValue(Type::Int32Ty),"context_marker",next);
    Instruction* adviceMarker=BinaryOperator::create(Instruction::Add,Constant::getNullValue(Type::Int32Ty),Constant::getNullValue(Type::Int32Ty),"advice_marker",next);
    Munger::addMarkers(shadow,contextMarker,adviceMarker);
  }
}

/**
 * Adaptation of LLVM 2.0 implementation of Value::replaceAllUsesWith().
 */
void replaceAllUsesAfterWith(llvm::Instruction* shadow,llvm::Instruction* newReturnValue){
  vector<Use*> replacableUses;

  BasicBlock* shadowParent=shadow->getParent();

  assert(newReturnValue && "Value::replaceAllUsesWith(<null>) is invalid!");
  assert(newReturnValue != shadow && "this->replaceAllUsesWith(this) is NOT valid!");
  assert(newReturnValue->getType() == shadow->getType() && "replaceAllUses of value with new value of different type!");
  assert(shadowParent==newReturnValue->getParent() && "arguments of replaceAllUsesAfterWith do not belong to same parent!");

  for(Value::use_iterator it=shadow->use_begin();it!=shadow->use_end();it++){
    User* usr=*it;
    Use& us=it.getUse();
    Instruction* usrIns=0;

    if((usrIns=dyn_cast<Instruction>(usr))){
      if(usrIns->getParent()==shadowParent){
	bool replacableUse=true;
	BasicBlock::iterator it=shadowParent->begin();
	
	while(it!=shadowParent->end()){
	  if(&(*it)==usr){
	    break;
	  }
	  
	  ++it;
	}    
	
	do{
	  if(&(*it)==newReturnValue){
	    replacableUse=false;//the use occurs before the definition of the replacement value!
	    break;
	  }
	  
	  ++it;
	}while(it!=shadowParent->end());
	
	if(replacableUse) replacableUses.push_back(&us);
      }else replacableUses.push_back(&us);
    }else replacableUses.push_back(&us);
  }

  for(unsigned int i=0;i<replacableUses.size();i++){
    Use* U=replacableUses[i];
    
    // Must handle Constants specially, we cannot call replaceUsesOfWith on a
    // constant!
    if (Constant *C = dyn_cast<Constant>(U->getUser())) {
      if (!isa<GlobalValue>(C))
	C->replaceUsesOfWithOnConstant(shadow, newReturnValue, U);
      else
	U->set(newReturnValue);
    } else {
      U->set(newReturnValue);
    }    
  }

}
