/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Aspicere2.
 *
 * The Initial Developer of the Original Code is
 * the Ghislain Hoffman Software Engineering Lab, INTEC, University Ghent.
 * Portions created by the Initial Developer are Copyright (C) 2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Bram Adams <bram_DOT_adams_AT_ugent_DOT_be>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "matcher/Matcher.h"
#include "utility/Naming.h"
#include "weaver/BodyExtracter.h"
#include "weaver/CrossAdviceContextExtracter.h"
#include "weaver/Munger.h"
#include "weaver/Weaver.h"
#include <iostream>

using namespace llvm;
using namespace std;

namespace {
  void pass_cross_advice_context_to_extracted_method_bodies(){
    std::set<llvm::Instruction*> callsToExtractedMethods=Munger::getCallsToExtractedMethod();
    for(std::set<llvm::Instruction*>::iterator it=callsToExtractedMethods.begin();it!=callsToExtractedMethods.end();it++){
      Munger::processCrossAdviceContextOfCallToExtractedMethod(*it);
      (*it)->setOperand(1,Munger::isCrossAdviceContextProcessed(*it));
    }
  }

  void convert_execution_to_call(std::vector<Director*>* matches){
    std::cout << "[WEAVER] Converting execution to call..." << endl;

    BodyExtracter extracter;
    //cout << "[WEAVER] TODO..." << endl;
    extracter.extract(*matches);

    std::map<llvm::Function*,llvm::CallInst*> tmp=extracter.getExtractedFunctions();
    for(std::map<llvm::Function*,llvm::CallInst*>::iterator it=tmp.begin();it!=tmp.end();it++) Munger::addCallToExtractedMethod(it->second);

    pass_cross_advice_context_to_extracted_method_bodies();
  }

  void weave_misc_residues(std::vector<Director*>* matches){
    std::cout << "Weaving miscellaneous residues..." << std::endl;
    vector<Value*> processorArgs(1);

    for(std::vector<Director*>::iterator it=matches->begin();it!=matches->end();it++){
      JoinPoint* jp=(*it)->getJoinPoint();
      JoinPoint::ResidueMap* residues=jp->getMiscResidues();//miscellaneous residues have to be processed before weaving in advice, otherwise query shadow could occur before actual update shadow, as the latter would be centered around the join point shadow, while the former is not affected by it
      if(residues){
	for(JoinPoint::ResidueMap::iterator iter=residues->begin();iter!=residues->end();iter++){
	  //miscellaneous residue => process corresponding shadow
	  processorArgs[0]=cast<CallInst>(iter->first);
	  
	  //process something on other location
	  iter->second->process(processorArgs);
	}
      }
    }
  }

  char Weaver::ID=0;//value NOT important; used as ID of pass

  void Weaver::getAnalysisUsage(AnalysisUsage &AU) const{
    //    AU.setPreservesAll();
    AU.addRequired<Matcher>();
  }

  bool Weaver::runOnModule(Module &M) {
    if(Munger::nrOfUnusedAdvice()==0){
      std::cout << "No advice: skipping weaving..." << endl;
      return false;
    }

    std::cout << "[WEAVER] Waiting for matcher..." << endl;
    Matcher& matcher = getAnalysis<Matcher>();
    std::vector<Director*>* matches=matcher.getMatches();

    if(matches->size()>0){
      Munger::setCrossAdviceContext(matcher.getCrossAdviceContext());
      
      convert_execution_to_call(matches);
      
      CrossAdviceContextExtracter crossExtracter;//adding glue code for introductions now, i.e. AFTER method body extraction
      crossExtracter.visit(M);
      
      std::cout << "[WEAVER] Weaving " << matches->size() << " matches..." << endl;
      weave_misc_residues(matches);

      int counter=1;
      for(std::vector<Director*>::iterator it=matches->begin();it!=matches->end();it++){
	/*      if(counter==10){
		counter=counter;//DEBUG
		}*/
	std::cout << "[WEAVER] Match " << counter++ << "..."  << endl;
	if(!((*it)->isDummy())) (*it)->weave();
	delete (*it);
      }
    }else std::cout << "[WEAVER] 0 matches, omitting weave process..." << endl;

    Munger::cleanUp();//e.g. if name of main-method changed, fix this
    
    delete matches;
    return true;//modified a lot in IR
  }
  
  RegisterPass<Weaver> X("weave", "Weaves advices around join points");
  //  RegisterOpt<Weaver> X("weave", "Weaves advices around join points");

  /*  enum OptimizationLevels {
    OPT_FAST_COMPILE         = 1,
    OPT_SIMPLE               = 2,
    OPT_AGGRESSIVE           = 3,
    OPT_LINK_TIME            = 4,
    OPT_AGGRESSIVE_LINK_TIME = 5
    };*/
}

ModulePass* createWeaverPass() {
  return new Weaver();
}
