/*===-- lib/weaver/predicates.pl - Declaration of basic predicates ------*- prolog -*-===*/
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Aspicere2.
 *
 * The Initial Developer of the Original Code is
 * the Ghislain Hoffman Software Engineering Lab, INTEC, University Ghent.
 * Portions created by the Initial Developer are Copyright (C) 2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Bram Adams <bram_DOT_adams_AT_ugent_DOT_be>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

:- dynamic methodDef/2.
:- dynamic methodDecl/2.
%:- dynamic executionShadow/1.
:- dynamic methodType/2.
:- dynamic methodArg/6.
:- dynamic varDecl/3.
:- dynamic callShadow/3.
:- dynamic callActual/4.
:- dynamic cross_advice_context/3.
:- dynamic variable/3.
%:- dynamic debuginfo/5.
:- multifile match/3.
%:- initialization loadNative.
%:- dynamic make_context/3.

%loadNative:-
%	load_foreign_library('/home/bram/workspace/svn/aspicere2/aspicere2-install/lib/native.so')
%	.

%%%%%%%%%%%
%% PCD's %%
%%%%%%%%%%%

%execution pcd
execution([JpID,'execution'],Name):-
	methodDef(JpID,Name)%,
%	executionShadow(JpID)
	.

%call pcd
invocation([JpID,'call'],Name):-
	callShadow(JpID,MethodID,_),
%	methodDecl(Encl,EnclName),
%	string_to_atom(EnclName,EnclAtom),
%	write('CALL inside '),write(EnclAtom),nl,
%	(
%	  write('Looking for method declaration of '),print(Name),nl,
	methodDecl(MethodID,Name)
%	string_to_atom(Name,NameAtom),
%	  write('FOUND!!!'),nl
%	;
%	  write('Looking for method definition of '),print(Name),nl,
%	  methodDef(MethodID,Name)
%	  write('FOUND!!!'),nl
%	),
%	!
	.

%execution args
args([JpID,_],Bindings):-
%	executionShadow(JpID),
	methodDef(JpID,_),
	unify_execution_bindings(Bindings,JpID,0)
	.

%call args
args([JpID,_],Bindings):-
	callShadow(JpID,_,_),
	unify_call_bindings(Bindings,JpID,0)
	.

unify_execution_bindings([ID|R],JpID,Pos):-
	methodArg(ID,JpID,_,Pos,NextPos,_),
	unify_execution_bindings(R,JpID,NextPos)
	.

unify_execution_bindings([],JpID,Pos):-
	\+methodArg(_,JpID,_,Pos,_,_),
	!
	.

unify_call_bindings([ID|R],JpID,Pos):-
%	write('1: '),write(JpID),write(' at pos '),write(Pos),nl,
	callActual(ID,JpID,Pos,NextPos),
%	write('2'),nl,
	unify_call_bindings(R,JpID,NextPos)
%	write('3'),nl
	.

unify_call_bindings([],JpID,Pos):-
%	write('4: '),write(JpID),write(' at pos '),write(Pos),nl,
	\+callActual(_,JpID,Pos,_),
%	write('5'),nl,
	!
        .

%execution functionname
functionname([JpID,'execution'],Name):-
	execution([JpID,'execution'],Name),
	!
        .

%call functionname
functionname([JpID,'call'],Name):-
	invocation([JpID,'call'],Name),
	!
        .

%execution return type
type([JpID,_],Type):-
%	write('NOA: '),
%	executionShadow(JpID),
	methodDef(JpID,_),
	!,
%	write('NO2: '),
%	methodDef(JpID,Name),
%	write('NO3: '),
	methodType(JpID,Type)%,
%	write('YES1: '),write(Type)
	.

%call return type
type([JpID,_],Type):-
%	write('NOB: '),
	callShadow(JpID,MethodID,_),
	!,
%	write('NO2: '),
%	(
%	  methodDecl(MethodID,Name),
%	  write('NO3a: ')
%	;
%	  methodDef(MethodID,Name)%,
%	  write('NO3b: ')
%	),
	methodType(MethodID,Type)%,
%	write('YES2: '),write(Type),nl
	.

type(ValuePtr,Type):-
%	write('NOA: '),
	type_of_value(ValuePtr,Type)
        .

enclosingMethod([Jp,_],[JpEncl,'execution']):-
	callShadow(Jp,_,JpEncl)
	.

enclosingModule([Jp,'call'],Module):-
%	write('ENCLOSINGMODULE-call: start'),nl,
	enclosingMethod([Jp,_],[JpEncl,_]),
	enclosingModule([JpEncl,'execution'],Module)
%	write('ENCLOSINGMODULE-call: end'),nl
	.

enclosingModule([Jp,'execution'],Module):-
%	write('ENCLOSINGMODULE-exec: start'),nl,
	get_enclosing_module_of_method(Jp,Module)
%	write('ENCLOSINGMODULE-exec: end'),nl
	.

local_continuation([Jp,'continuation'],[Jp,'call']):-
	invocation([Jp,'call'],_)
	.

local_continuation([Jp,'continuation'],[Jp,'execution']):-
	execution([Jp,'execution'],_)
	.

nth_arg([Jp,'execution'],Arg,Name):-
	methodArg(Arg,Jp,_,_,_,Name)
	.

nth_arg_type([JpCall,_],Index,Type):-
	callShadow(JpCall,JpMeth,_),
	methodArg(_,JpMeth,Type,Index,_,_)
	.

nth_actual([JpCall,_],Index,Arg):-
	callActual(Arg,JpCall,Index,_)
	.

within(Jp,FileName):-                                                                                                        
    filename(Jp,FileName).                                                                                                   
                                                                                                                             
withincode(Jp,FName):-                                                                                                       
    enclosingMethod(Jp,JpEncl),                                                                                              
    execution(JpEncl,FName).

%cflow([JpCall,'call'],[JpCall,'call']).
cflow([JpCall,'call'],[Jp,Kind]):-
	write('Cflow of '),write(JpCall),nl,
	traverse_call_graph_from_call(JpCall,res(List)),
	length(List,Len),
	write('Number of query shadows: '),write(Len),nl,
	member(Jp,List),
	(
	    invocation([Jp,Kind],_)
	;
	execution([Jp,Kind],_)
    ),
	write('Found a solution.'),nl
%	called_function(JpCall,CalledFunction),
%	cflow([CalledFunction,'execution'],Jp)
	.

cflow([JpExecution,'execution'],[Jp,Kind]):-
	write('Cflow of '),write(JpExecution),nl,
	traverse_call_graph_from_function(JpExecution,res(List)),
	length(List,Len),
	write('Number of query shadows: '),write(Len),nl,
	member(Jp,List),
	(
	    invocation([Jp,Kind],_)
	;
	execution([Jp,Kind],_)
    ),
	write('Found a solution.'),nl
    .

cflow(_,_):-
	decrement_cflow_index,
	fail
	.
%get_cflow_list(FunctionPtr,List):-
%	traverse_call_graph(FunctionPtr,res(List))
%	.

%store return value of Shadow in Ret (for use in temporal after_returning advice)
store_return_value([Shadow,_],Ret):-
	store_return_value_into_var(Shadow,Ret).


get_local_variable_ref([Shadow,_],Name,VarPtr):-
	get_local_variable_ref_native(Shadow,Name,VarPtr).

%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Auxiliary predicates %%
%%%%%%%%%%%%%%%%%%%%%%%%%%

dirname([Jp,'execution'],DirName):-
%	debug_info(Jp,DirName,_)
	dinfo(Jp,DirName,_,_,_)
	.

dirname([Jp,'call'],DirName):-
	enclosingMethod([Jp,_],Jp_encl),
	dirname(Jp_encl,DirName)
	.

filename([Jp,'execution'],FileName):-
%	debug_info(Jp,_,FileName)
	dinfo(Jp,_,FileName,_,_)
%	execution([Jp,'execution'],Name),
%	atom_codes(NameAtom,Name),
%	atom_codes(FileNameAtom,FileName),
%	write('READ '),write(NameAtom),write(' in '),write(FileNameAtom),nl
	.

filename([Jp,'call'],FileName):-
	enclosingMethod([Jp,_],Jp_encl),
	filename(Jp_encl,FileName)
	.

stringify(Name,StringifiedName):-
%	write('STRINGIFYING '),print(Name),write('...'),nl,
%	string_or_atom_or_char_list_to_atom(Name,NameAtom),
	string_to_atom(Name,NameAtom),
	atom_concat('"',NameAtom,Tmp),
%	atom_concat('"',Name,Tmp),
	string_concat(Tmp,'"',StringifiedNameAtom),
	string_to_atom(StringifiedName,StringifiedNameAtom)
%	write('STRINGIFIED <'),write(Name),write('> to <'),write(StringifiedName),write('>'),nl
	.

is_void(Type):-
	%type_name(Type,"void"),
%	write('OLE'),nl,
	is_void_type(Type),
	!
	.
is_void("void").
is_void('void').

annotation([Jp,_],Name,Attrs):-
%	write('A'),nl,
	dinfo(Jp,Dir,File,Line,_),
%	write('B: '),atom_codes(FileAtom,File),write(FileAtom),write(' - '),atom_codes(DirAtom,Dir),write(DirAtom),write(' - '),write(Line),nl,
	source_annotation(Line,Dir,File,Name,Attrs)
%	write('C'),nl
	.

%assert_all_pointers(_,[]).
%assert_all_pointers(Type,[A|R]):-
%%	write('ASSERT: '),write(Type),write(' '),write([A|R]),nl,
%	assert_pointer(Type,A),
%	assert_all_pointers(Type,R)
%	.

%assert_pointer(Type,Ptr):-
%%	write('ASSERTING: '),write(Ptr),write(' as a '),write(Type),write(' pointer'),nl,
%	assert(ptr(Ptr,Type))
%	.

%assign unique indices to context for a particular shadow ***across all*** advices which match on it (shared when possible): order complies to order of advice variables
assert_cross_advice_context(Shadow,Context):-
	cross_advice_context(Shadow,Context,_),%no duplicate asserts!
	!
	.
assert_cross_advice_context(Shadow,Context):-
%	\+cross_advice_context(Shadow,Context,_),%no duplicate asserts!
	assert_cross_advice_context(Shadow,Context,0)
	.

%each asserted cross advice context needs to have a unique index, starting from zero
assert_cross_advice_context(Shadow,Context,Index):-
	cross_advice_context(Shadow,_,Index),
	Index2 is Index+1,
	assert_cross_advice_context(Shadow,Context,Index2)
	.

assert_cross_advice_context(Shadow,Context,Index):-
	assert(cross_advice_context(Shadow,Context,Index)),
	!
%	write('[ASSERTED] '),write(Shadow),write(' -> '),write(Context),write(' at index '),write(Index),nl
	.

%Tag is the name of the join point property/introduced variable or (another way to look at it) the name of the concern for which the variable is needed
associate([Jp,'call'],Tag,Clone):-
%	write('ASSOCIATE-call: start'),nl,
	enclosingMethod([Jp,_],[JpEncl,_]),
	tie_variable_to_join_point(JpEncl,Clone),
	assert(property([Jp,'call'],Tag,Clone))
%	write('ASSOCIATE-call: end'),nl
	.

associate([Jp,'execution'],Tag,Clone):-
%	write('ASSOCIATE-exec: start'),nl,
	tie_variable_to_join_point(Jp,Clone),
	assert(property([Jp,'execution'],Tag,Clone))
%	write('ASSOCIATE-exec: end'),nl
	.

head([Head,_],Head).

%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Printing and testing %%
%%%%%%%%%%%%%%%%%%%%%%%%%%

print_all_reified_predicates:-
	print_methodDefinition,
	print_methodDeclaration,
%	print_executionShadow,
	print_methodType,
	print_methodArgument,
%	print_variableDeclaration,
	print_callShadow,
	print_callActual
%	print_debuginfo
    .

printFact(_,[]).
printFact(String,[[A|B]|List]):-
	print(String),print('('),print(A),printSub(B),print(').'),nl,
	printFact(String,List)
	.

printSub([]).
printSub([A|List]):-
	write(','),write(A),printSub(List)
	.

print_methodDefinition:-
	findall([A,B],methodDef(A,B),List),
	printFact('methodDef',List)
	.

print_methodDeclaration:-
	findall([A,B],methodDecl(A,B),List),
	printFact('methodDecl',List)
	.
	
%print_executionShadow:-
%	findall([A],executionShadow(A),List),
%	printFact('executionShadow',List)
%	.

print_methodType:-
	findall([A,B],methodType(A,B),List),
	printFact('methodType',List)
	.

print_methodArgument:-
	findall([A,B,C,D,E,F],methodArg(A,B,C,D,E,F),List),
	printFact('methodArg',List)
	.

print_variableDeclaration:-
	findall([A,B,C],varDecl(A,B,C),List),
	printFact('varDecl',List)
	.

print_callShadow:-
	findall([A,B,C],callShadow(A,B,C),List),
	printFact('callShadow',List)
	.

print_callActual:-
	findall([A,B,C,D],callActual(A,B,C,D),List),
	printFact('callActual',List)
	.

%print_debuginfo:-
%	findall([A,B,C,D,E],dinfo(A,B,C,D,E),List),
%	printFact('dinfo',List)
%	.

match_all:-
	write('Starting match_all...'),nl,
	findall([A,B,C,D],(match(A,B,C,D),write('One match less:'),nl,write('\tA='),write(A),nl,write('\tB='),write(B),nl,write('\tC='),write(C),nl,write('\tD='),write(D),nl),List),
%	write('HI:'),nl,write(List),
	printFact('match',List)
	.

mycount:-
	listing
	.

mytest:-
%	write('Testing match...'),nl,
%	findall(Jp,(invocation(Jp,FName), write(1) , write(': ') , atom_codes(FAtom,FName) , write(FAtom) , nl, annotation(Jp,log,[What]), write(2) , nl, type(What,Type), write(3) , nl, type_name(Type,TypeName), a_test(TypeName),write(4) , nl, format_spec(TypeName,Spec), write(5) , nl),List),
%	listing,
%	findall([],(callShadow(_,ID,_),write('*** '),write(ID),nl),List),
%	findall([],((methodDecl(ID,Name);methodDef(ID,Name)),write('-'),atom_codes(Atom,Name),write('- '),write(ID),write(': '),write(Atom),nl),List),
%	findall([],(methodDef(ID,Name),write('+'),atom_codes(Atom,Name),write('+ '),write(ID),write(': '),write(Atom),nl),List),
%	findall([],(callShadow(_,ID,_),write('-'),methodDecl(ID,Name),write('-'),atom_codes(Atom,Name),write('- '),write(ID),write(': '),write(Atom),nl),List),
%	findall([],(callShadow(_,ID,_),write('+'),methodDef(ID,Name),write('+'),atom_codes(Atom,Name),write('+ '),write(ID),write(': '),write(Atom),nl),List),
%	findall([JpID],(invocation([JpID,_],FName),\+callShadow(JpID,_,_),atom_codes(FAtom,FName),write('**'),write(FAtom),nl),List),
%	findall([Jp],(dinfo(Jp,Line,_,_,File1),source_annotation(Line,Dir,File2,_,_),atom_codes(File1Atom,File1),write(File1Atom),write(' <--> '),atom_codes(File2Atom,File2),write(File2Atom),nl),List4),
%	write('jps: '),write(List4),nl,
%	findall([Jp,Name,Attrs],annotation(Jp,Name,Attrs),List3),
%	write('Annotations: '),write(List3),nl,
%	findall([Line,DirAtom,File,Name,AttrAtom],(source_annotation(Line,Dir,File,Name,[Attr]),atom_codes(DirAtom,Dir),atom_codes(AttrAtom,Attr),write('Dir/File: '),write(DirAtom),write('/'),write(File),nl),List3),
%	write('Source Annotations: '),nl,
%	findall([Line,DirAtom,FileAtom,Name,Attr],(source_annotation(Line,Dir,File,Name,[Attr]),atom_codes(DirAtom,Dir),atom_codes(FileAtom,File),write('Dir/File: '),write(DirAtom),write('/'),write(FileAtom),write('('),write(Line),write(')'),nl),List3),
%	write('Source Annotations: '),write(List3),nl,
%	write('Debuginfos: '),nl,
%	findall([Jp,Line,DirAtom,FileAtom],(dinfo(Jp,Line,_,Dir,File),atom_codes(DirAtom,Dir),atom_codes(FileAtom,File),write('Dir/File: '),write(DirAtom),write('/'),write(FileAtom),write('('),write(Line),write(')'),nl),List),
%	write('Debuginfos: '),write(List),nl,
%	findall([Jp],(invocation([Jp,_],_),\+dinfo(Jp,_,_,_,_)),List),
%	write('Invokes: '),write(List),nl,
%	findall([Jp],(methodDef(Jp,_),\+dinfo(Jp,_,_,_,_)),List2),
%	write('Methods: '),write(List2),nl,
%	print_all_reified_predicates,
%	invocation([Jp,_],"transfer"),
%	methodDef(ID,"transfer"),
%	write('Found call to transfer: '),write(Jp),nl,
%	callActual(_,Jp,Pos,_),
%	write('Found actual of call to transfer...'),nl,
%	findall([Pos,Name],(callActual(_,Jp,Pos,_),methodArg(_,ID,_,Pos,_,Name)),List),
%	write(List),
%	methodDecl(_,"main"),
%	write('Decl OK'),nl,
%	methodDef(_,"main"),
%	write('Def OK'),nl,
%	make_context(A,B),
%	write('YES...'),nl
%	match2([['Jp',Jp],['ASPICERE2_ASPECT','logging'],['ASPICERE2_ADVICE',logging_nonvoid],['ASPICERE2_ADVICE_TYPE','around']],Context,Residues),
%	write('***JP: '),write(Jp),nl
%	write('No tests...'),nl
%	match_all,
	nl
	.

match2([['Jp',Jp],['ASPICERE2_ASPECT','logging'],['ASPICERE2_ADVICE',logging_nonvoid],['ASPICERE2_ADVICE_TYPE','around']],Context,Residues):-
  write('Trying out advice <logging_nonvoid> of aspect <logging> for '),write(Jp),write('...'),nl,
  (  invocation(Jp,_),write('A')   , type(Jp,ReturnType),write('B')   , \+is_void(ReturnType),write('C')   , stringify(ReturnType,RName) ),
  write('These are the context variables for match '),write(Jp),write(' of advice <logging_nonvoid> in aspect <logging>:'),nl,
  print_list([['ReturnType',ReturnType],['RName',RName]]),
  make_context(Jp,Context,[['ReturnType',ReturnType],['RName',RName]]),
  write('Collected context...'),nl,
  make_residues(Jp,Residues,[]),
  write('Residues made...'),nl
  .

print_all_call_sites:-
	findall([ID,Name],(invocation([ID,_],Name),callShadow(ID,_,JpEncl),methodDecl(JpEncl,EnclName),string_to_atom(Name,NameAtom),string_to_atom(EnclName,EnclNameAtom),write('yes: '),write(ID),write(' -> '),write(NameAtom),write(' in '),write(EnclNameAtom),nl),_)
	.

print_list([]).
print_list([[A,B]|C]):-
	write('<'),write(A),write('>: <'),write(B),write('>'),nl,
	print_list(C)
	.

%Pattern HAS TO be a string; String doesn't need to
wildcard2(Pattern,String):-
	atom(String),
	!,
	string_to_atom(Pattern,PatternAtom),
	write('1'),nl,
	wildcard_atom(String,PatternAtom,_)
	.
wildcard2(Pattern,String):-
	string_to_atom(String,Atom),
	string_to_atom(Pattern,PatternAtom),
	write('2'),nl,
	wildcard_atom(Atom,PatternAtom,_)
	.