   /*******************************************************/
   /*      "C" Language Integrated Production System      */
   /*                                                     */
   /*               CLIPS Version 6.24  04/21/06          */
   /*                                                     */
   /*                USER FUNCTIONS MODULE                */
   /*******************************************************/

/*************************************************************/
/* Purpose:                                                  */
/*                                                           */
/* Principal Programmer(s):                                  */
/*      Gary D. Riley                                        */
/*                                                           */
/* Contributing Programmer(s):                               */
/*                                                           */
/* Revision History:                                         */
/*                                                           */
/*      6.24: Created file to seperate UserFunctions and     */
/*            EnvUserFunctions from main.c.                  */
/*                                                           */
/*************************************************************/

/***************************************************************************/
/*                                                                         */
/* Permission is hereby granted, free of charge, to any person obtaining   */
/* a copy of this software and associated documentation files (the         */
/* "Software"), to deal in the Software without restriction, including     */
/* without limitation the rights to use, copy, modify, merge, publish,     */
/* distribute, and/or sell copies of the Software, and to permit persons   */
/* to whom the Software is furnished to do so.                             */
/*                                                                         */
/* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS */
/* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF              */
/* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT   */
/* OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY  */
/* CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES */
/* WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN   */
/* ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF */
/* OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.          */
/*                                                                         */
/***************************************************************************/

#include "setup.h"
#include "extnfunc.h"
#include "clips.h"

void UserFunctions(void);
void EnvUserFunctions(void *);

int is_shell_class(void* theEnv) 
{ 
  DATA_OBJECT temp; 
  char* ptrStr=0;

  //pVMObject class=0;
  char* class_name=0;
  char* shell_class_prefix="Shell_Class_";
 
  /*=================================*/ 
  /* Check for exactly one argument. */ 
  /*=================================*/ 
 
  if (ArgCountCheck(theEnv,"is_shell_class",EXACTLY,1) == -1)  
    { return(FALSE); } 
 
  /*=========================================================*/ 
  /* Get the first argument using the ArgTypeCheck function. */ 
  /*=========================================================*/ 
 
  if (ArgTypeCheck(theEnv,"is_shell_class",1,SYMBOL,&temp) == 0) 
    { return(FALSE); } 
 
  /*=====================================*/ 
  /* Determine if the value is positive. */ 
  /*=====================================*/ 
 
  ptrStr=DOToString(temp);
  char* tmp=0;
  if(strncmp(ptrStr,"0x",2)){//plain string
    tmp=ptrStr;
  }else{//wrapped pointer
    void* ptr=0;
    sscanf(ptrStr,"%p",&ptr);    
    tmp=(char*)ptr;
  }


  /*  class=(pVMObject)ptr;

  class_name=SEND(SEND(class, get_name),get_string);
  if(strncmp(class_name,shell_class_prefix,strlen(shell_class_prefix))) return(FALSE);
  else return(TRUE);*/

  if(strcmp(tmp,"aaa")){
    return FALSE;
  }else{
    return TRUE;
  }

  //sprintf(stmt, "%s%d%s%s%s", SHELL_PREFIX, counter++, SHELL_PART_1, inp, SHELL_PART_2);

  //#define SHELL_PREFIX "Shell_Class_"
  //#define SHELL_PART_1 " = ( run: it = ( | tmp | tmp := ("
  //#define SHELL_PART_2 " ). 'it = ' print. ^tmp println ) )"
}
  
/*********************************************************/
/* UserFunctions: Informs the expert system environment  */
/*   of any user defined functions. In the default case, */
/*   there are no user defined functions. To define      */
/*   functions, either this function must be replaced by */
/*   a function with the same name within this file, or  */
/*   this function can be deleted from this file and     */
/*   included in another file.                           */
/*********************************************************/
void UserFunctions()
  {   
    /*    extern int is_shell_class(); 
 
    DefineFunction2("is_shell_class",'b',PTIF is_shell_class, "is_shell_class", 
    "11s");*/
  }
  
/***********************************************************/
/* EnvUserFunctions: Informs the expert system environment */
/*   of any user defined functions. In the default case,   */
/*   there are no user defined functions. To define        */
/*   functions, either this function must be replaced by   */
/*   a function with the same name within this file, or    */
/*   this function can be deleted from this file and       */
/*   included in another file.                             */
/***********************************************************/
#if IBM_TBC
#pragma argsused
#endif
void EnvUserFunctions(
  void *theEnv)
  {
#if MAC_MCW || IBM_MCW || MAC_XCD
#pragma unused(theEnv)
#endif

    //    extern int is_shell_class(void*); 
    EnvDefineFunction2(theEnv,"is_shell_class",'b',PTIEF is_shell_class, "is_shell_class", "11k");//first arg is theEnv (w), anything else string by default (s)
  }

