/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Aspicere2.
 *
 * The Initial Developer of the Original Code is
 * the Ghislain Hoffman Software Engineering Lab, INTEC, University Ghent.
 * Portions created by the Initial Developer are Copyright (C) 2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Bram Adams <bram_DOT_adams_AT_ugent_DOT_be>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "aspicere2.h"
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>

/*Check dead argument elimination.*/
int f(int a,int b,int c){
  return a;
}

void h_before(JOINPOINT* jp,int a,char* b){
  printf("Do nothing...\n");
  /*  jp->nrArgs=2;
  jp->args[0]=&a;
  jp->args[1]=&b;
  jp->returnValue=0;
  jp->fileName="FILE_NAME";
  jp->functionName="FUNCTION_NAME";*/
}

void g_before(int a,char* b,char** c){
  JOINPOINT jp;
  jp.nrArgs=3;
  jp.args=(void**)malloc(3*sizeof(void*));
  jp.args[0]=&a;
  jp.args[1]=&b;
  jp.args[2]=&c;
  jp.returnValue=0;
  jp.fileName="FILE_NAME";
  jp.functionName="FUNCTION_NAME";
  h_before(&jp,a,b);
  free(jp.args);
}

void h_after(JOINPOINT* jp,int a,char* b){
  /*  jp->nrArgs=2;
  jp->args[0]=&a;
  jp->args[1]=&b;
  jp->returnValue=0;
  jp->fileName="FILE_NAME";
  jp->functionName="FUNCTION_NAME";*/
}

void g_after(int a,char* b){
  JOINPOINT jp;
  jp.nrArgs=2;
  jp.args[0]=&a;
  jp.args[1]=&b;
  jp.returnValue=0;//concrete return value
  jp.fileName="FILE_NAME";
  jp.functionName="FUNCTION_NAME";
  h_after(&jp,a,b);
}

int* goal(int a,char* b, void* c){
  return 0;
}

int* forward(int a,char* b, void* c){
  return goal(a,b,c);
}

void goal2(int a,char* b, void* c){
  return;
}

void forward2(int a,char* b, void* c){
  goal2(a,b,c);
}

int va_sum(int count,...){
  int i,sum=0;
  va_list ap;

  va_start(ap,count);
  for(i=0;i<count;i++){
    sum+=va_arg(ap,int);
  }
  va_end(ap);

  va_start(ap,count);
  for(i=0;i<count;i++){
    sum+=va_arg(ap,int);
  }
  va_end(ap);

  return sum;
}

void ff(int* r){
  (*r)++;
}

void after_returning(void){
  int res=f(1,2,3);
  printf("***VOOR***%d\n",res);
  ff(&res);
  printf("***NA***%d\n",res);
  ff(&res);
  printf("***FINAL***%d\n",res);
}

//IMPOSSIBLE: always non-... argument needed
/*int varargtest2(...){
  return 2;
  }*/

void transfer(int amount,char* reknr){
  int res=printf("Wiring %d Euro to account %s.\n",amount,reknr);
  printf("Checking propagation of after_returning propagation: %s\n",((res==666)?"OK":"not OK"));
}

void stringtest(char *s){
  printf("%s\n",s);
}

typedef struct newjp{
  void* context[5];
} newjp;

void doSomething2(int a){
  newjp j;
  j.context[0]=&a;

  void* aa=j.context[1];
}

int main(void){
  int a=f(1,2,3);
  printf("a is: %d\n",a);

  char* s="AAA";
  char* ss="BBB";
  g_before(a,s,&ss);

  after_returning();
  transfer(15,s);
  int res=va_sum(5,1,2,3,4,5);
  printf("SUM: %d\n",res);

  stringtest(s);

  doSomething2(56);

  return 0;
}
