/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Aspicere2.
 *
 * The Initial Developer of the Original Code is
 * the Ghislain Hoffman Software Engineering Lab, INTEC, University Ghent.
 * Portions created by the Initial Developer are Copyright (C) 2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Bram Adams <bram_DOT_adams_AT_ugent_DOT_be>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include <stdio.h>
#include <stdlib.h>
#include "sql.h"

void transfer(int amount,char* reknr);
int monthlyPayment(int lowerID,int upperID);
void displayName(int ID);
int OK(int);
int NOK(int);
void good(int);
void bad(int);

int main (int charc,char** args) {
  int lowerID=7;
  int upperID=11;

  /*int nrFound=monthlyPayment(lowerID,upperID);*/
  printf("GOOD:\n");
  good(6);
  printf("BAD:\n");
  bad(6);
  
  return 0;
}

void transfer(int amount,char* reknr){
  printf("Wiring %d Euro to account %s.\n",amount,reknr);
}

int monthlyPayment(int lowerID,int upperID){
  sqcursor* cursor=_iqcprep("select ID,wage,accountnr from accounting where %d <= ID <= %d",lowerID,upperID);
  sqlda odesc;

  int id;
  int counter=0;
  int amount;
  char* rekNr;

  while(_iqcftch(cursor, &odesc)){
    /*printf("CODE_PAYMENT:\t%d\n",sql_code);*/
    if(sql_code!=0){
      printf("Oops, some error occurred. Abandoning after %d successful fetches out of %d...\n",counter,upperID-lowerID+1);
      exit(0);//counter);//makefile complains
    }

    counter++;
    id=odesc.id;
    amount=odesc.wage;
    rekNr=odesc.accountnr;
    displayName(id);
    transfer(amount,rekNr);
    printf("----------------\n");
  }

  _iqcfin(cursor);

  return counter;
}

void displayName(int ID){
  sqcursor* cursor=_iqcprep("select ID,name from population where ID = %d",ID);
  sqlda odesc;

  char* name;

  /*if(_iqcftch(cursor, &odesc)){*/
    /*printf("CODE_NAME:\t%d\n",sql_code);*/

    _iqcftch(cursor, &odesc);
    printf("ID:\t%d\n", ID);
    if(sql_code!=0){
      printf("Name:\tUNAVAILABLE\n");

    } else {
      name=odesc.name;
      printf("Name:\t%s\n", name);
    }

    _iqcfin(cursor);
}

int OK(int nr){
  printf("OK%d\n",nr);
  return 0;
}

int NOK(int nr){
  printf("NOT OK%d\n",nr);
  return 1;
}

void good(int nr){
  int i=0;

  for(;i<nr;i++){
    OK(i+1);
  }
}

void bad(int nr){
  int i=0;

  for(;i<nr;i++){
    OK(i+1);
  }

  NOK(1);

  for(;i<2*nr;i++){
    OK(i+1);
  }
}
