#!/bin/bash
# ***** BEGIN LICENSE BLOCK *****
# Version: MPL 1.1/GPL 2.0/LGPL 2.1
#
# The contents of this file are subject to the Mozilla Public License Version
# 1.1 (the "License"); you may not use this file except in compliance with
# the License. You may obtain a copy of the License at
# http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS IS" basis,
# WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
# for the specific language governing rights and limitations under the
# License.
#
# The Original Code is Aspicere2.
#
# The Initial Developer of the Original Code is
# the Ghislain Hoffman Software Engineering Lab, INTEC, University Ghent.
# Portions created by the Initial Developer are Copyright (C) 2006
# the Initial Developer. All Rights Reserved.
#
# Contributor(s):
#   Bram Adams <bram_DOT_adams_AT_ugent_DOT_be>
#
# Alternatively, the contents of this file may be used under the terms of
# either the GNU General Public License Version 2 or later (the "GPL"), or
# the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
# in which case the provisions of the GPL or the LGPL are applicable instead
# of those above. If you wish to allow use of your version of this file only
# under the terms of either the GPL or the LGPL, and not to allow others to
# use your version of this file under the terms of the MPL, indicate your
# decision by deleting the provisions above and replace them with the notice
# and other provisions required by the GPL or the LGPL. If you do not delete
# the provisions above, a recipient may use your version of this file under
# the terms of any one of the MPL, the GPL or the LGPL.
#
# ***** END LICENSE BLOCK *****

if [ "$#" -ne "1" ] ; then
  echo "Usage: $0 gdb_or_ddd"
  exit
fi

TOOL=$1

for FILE in `ls *.c`; do
    llvm-gcc -fno-builtin -g -emit-llvm -c ${FILE} -o ${FILE}.trans
done

if [ -f swipl ] 
    then
    #PROLOG=swipl
    OPT_PATH=${ASPICERE2_INSTALL}/lib
else
    #PROLOG=pl
    OPT_PATH=${ASPICERE2_INSTALL}/lib
fi

#pl -f none -F none -g true -t "consult(['../../../lib/matcher/predicates.pl','knowledge.pl','knowledge2.pl,'recovery.ac.pl','logging.ac.pl']),qsave_program('pltmp-27174',[toplevel=prolog,init_file=none])"
#cp -f @PROLOG_ENGINE_LIB_PATH@ @PROLOG_ENGINE_AND_STATE_LIB_PATH@
#cat pltmp-27174 >> @PROLOG_ENGINE_AND_STATE_LIB_PATH@
#chmod 755 @PROLOG_ENGINE_AND_STATE_LIB_PATH@
#rm -f pltmp-27174

export LD_LIBRARY_PATH=${SWI_LIB}:${ASPICERE2_INSTALL}/lib:${LLVM_FRONT}/lib:$LD_LIBRARY_PATH

export PROLOG_STATE_NAME=aspicere2-prolog-state
export PROLOG_STATE_PATH=${ASPICERE2_BUILD}/test/Feature/SPLAT07-tr/${PROLOG_STATE_NAME}

#ddd llvm-ld 
$TOOL --command=gdb.txt llvm-ld

# -internalize -globalopt -constmerge -ipconstprop -deadargelim -inline -prune-eh -globaldce -argpromotion -instcombine -scalarrepl -globalsmodref-aa -licm -load-vn -gcse -dse -instcombine -simplifycfg -globaldce 

#-O1 *.trans -L${SWI_LIB} -L${ASPICERE2_INSTALL}/lib -L${LLVM_FRONT} -load=${ASPICERE2_INSTALL}/lib/reifier -load=${ASPICERE2_INSTALL}/lib/matcher -debug-pass=Details -debug -o db

# debug
#-O1 *.trans -L${SWI_LIB} -L${ASPICERE2_INSTALL}/lib -L${LLVM_FRONT} -load=${ASPICERE2_INSTALL}/lib/weaver -reify -match -debug-pass=Details -debug -o db

# no debug
#-O1 *.trans -L${SWI_LIB} -L${ASPICERE2_INSTALL}/lib -L${LLVM_FRONT} -load=${ASPICERE2_INSTALL}/lib/weaver -reify -match -weave -debug-only=reifier -o db

# no debug
#-O1 main.c.trans sql.c.trans logging.ac.c.trans recovery.ac.c.trans -L${LLVM_FRONT}/lib -L${ASPICERE2_INSTALL}/lib -L${SWI_LIB} -load=${ASPICERE2_INSTALL}/lib/weaver -load=${ASPICERE2_INSTALL}/lib/native -disable-opt -constmerge -globalsmodref-aa -reify -match -weave -internalize -globalopt -constmerge -ipconstprop -deadargelim -inline -prune-eh -globaldce -argpromotion -instcombine -scalarrepl -globalsmodref-aa -licm -load-vn -gcse -dse -instcombine -simplifycfg -globaldce -debug-only=matcher -o db