%-*- prolog -*-
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Aspicere.
 *
 * The Initial Developer of the Original Code is
 * the Software Engineering Lab, INTEC, University Ghent.
 * Portions created by the Initial Developer are Copyright (C) 2004
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Bram Adams <bram.adams@ugent.be>
 *   Kris De Schutter <kris.deschutter@ugent.be>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

error_code("LINKED_ERROR",0).

int_invocation(Jp,FName):-
  invocation(Jp,FName),
  type(Jp,Type),
  type_name(Type,"i32")
  .

/*critical_call(Jp,ErrorCode):-
  int_invocation(Jp),
  annotation(Jp,error,[ErrorName]),
  error(ErrorName,ErrorCode)
  .*/

idiomatic_proc(Jp):-
  execution(Jp,Name),
  filename(Jp,"main.c")
%	atom_codes(NameAtom,Name),
%  write('$$'),write(NameAtom),write(' is idiomatic proc!'),nl
  .

/*find call join point for some function (and 
 enclosing execution join point) and a pointer 
 to the error variable in use*/
idiomatic_call(JpCall,RPtr):-
  int_invocation(JpCall,FName),
  \+wildcard(".*printf",FName),	%better: look at module/dirnames
  enclosingMethod(JpCall,JpEncl),
  idiomatic_proc(JpEncl),
  property(JpEncl,error_var,RPtr)
  .

manual(JpCall):-
  annotation(JpCall,manual,_)
  .

log(JpCall,ErrorCode):-
  annotation(JpCall,log,[ErrorName]),
  error_code(ErrorName,ErrorCode)
  .

/*range(Jp,Arg,LowerBound,UpperBound):-
  annotation(Jp,range,[ArgName,LowerBound,UpperBound]),
  nth_arg(Jp,Arg,ArgName)
  .*/

/*logging_necessary(Jp,1,ErrorCode):-
  critical_call(Jp,ErrorCode),
  !
  .
logging_necessary(_,0,9999).%garbage code*/

/*int around fault_discovery(int ErrorCode,int* RPtr,int LoggingNeeded) on Jp:
  call_with_error_var(JpCall,RPtr)
  && local_continuation(Jp,JpCall)
  && logging_necessary(JpCall,LoggingNeeded,ErrorCode) {
   if(*RPtr==OK) return proceed();
   else if(LoggingNeeded){
     LOG(ErrorCode,*RPtr);
     *RPtr=ErrorCode;//do NOT resume continuation
   }

   return *RPtr;
}*/