#!/bin/bash

for FILE in `ls *.c`; do
    llvm-gcc -g -emit-llvm -c ${FILE} -o ${FILE}.trans
done

if [ -f swipl ] 
    then
    #PROLOG=swipl
    OPT_PATH=${ASPICERE2_INSTALL}/lib
else
    #PROLOG=pl
    OPT_PATH=${ASPICERE2_INSTALL}/lib
fi

#pl -f none -F none -g true -t "consult(['../../../lib/matcher/predicates.pl','knowledge.pl','knowledge2.pl,'recovery.ac.pl','logging.ac.pl']),qsave_program('pltmp-27174',[toplevel=prolog,init_file=none])"
#cp -f @PROLOG_ENGINE_LIB_PATH@ @PROLOG_ENGINE_AND_STATE_LIB_PATH@
#cat pltmp-27174 >> @PROLOG_ENGINE_AND_STATE_LIB_PATH@
#chmod 755 @PROLOG_ENGINE_AND_STATE_LIB_PATH@
#rm -f pltmp-27174

export LD_LIBRARY_PATH=${SWI_LIB}:${ASPICERE2_INSTALL}/lib:${LLVM_FRONT}/lib:$LD_LIBRARY_PATH

export PROLOG_STATE_NAME=aspicere2-prolog-state
export PROLOG_STATE_PATH=${ASPICERE2_BUILD}/test/Feature/SPLAT07/${PROLOG_STATE_NAME}

#ddd llvm-ld 
valgrind --leak-check=full llvm-ld -O1 main.c.trans exception.ac.c.trans -L${LLVM_FRONT}/lib -L${ASPICERE2_INSTALL}/lib -L${SWI_LIB} -load=${ASPICERE2_INSTALL}/lib/weaver -load=${ASPICERE2_INSTALL}/lib/native -disable-opt -constmerge -globalsmodref-aa -mergereturn -reify -match -weave -printm -o db

# -internalize -globalopt -constmerge -ipconstprop -deadargelim -inline -prune-eh -globaldce -argpromotion -instcombine -scalarrepl -globalsmodref-aa -licm -load-vn -gcse -dse -instcombine -simplifycfg -globaldce 

#-O1 *.trans -L${SWI_LIB} -L${ASPICERE2_INSTALL}/lib -L${LLVM_FRONT} -load=${ASPICERE2_INSTALL}/lib/reifier -load=${ASPICERE2_INSTALL}/lib/matcher -debug-pass=Details -debug -o db

# debug
#-O1 *.trans -L${SWI_LIB} -L${ASPICERE2_INSTALL}/lib -L${LLVM_FRONT} -load=${ASPICERE2_INSTALL}/lib/weaver -reify -match -debug-pass=Details -debug -o db

# no debug
#-O1 *.trans -L${SWI_LIB} -L${ASPICERE2_INSTALL}/lib -L${LLVM_FRONT} -load=${ASPICERE2_INSTALL}/lib/weaver -reify -match -weave -debug-only=reifier -o db

# no debug
#-O1 main.c.trans sql.c.trans logging.ac.c.trans recovery.ac.c.trans -L${LLVM_FRONT}/lib -L${ASPICERE2_INSTALL}/lib -L${SWI_LIB} -load=${ASPICERE2_INSTALL}/lib/weaver -load=${ASPICERE2_INSTALL}/lib/native -disable-opt -constmerge -globalsmodref-aa -reify -match -weave -internalize -globalopt -constmerge -ipconstprop -deadargelim -inline -prune-eh -globaldce -argpromotion -instcombine -scalarrepl -globalsmodref-aa -licm -load-vn -gcse -dse -instcombine -simplifycfg -globaldce -debug-only=matcher -o db