/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Aspicere2.
 *
 * The Initial Developer of the Original Code is
 * the Ghislain Hoffman Software Engineering Lab, INTEC, University Ghent.
 * Portions created by the Initial Developer are Copyright (C) 2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Bram Adams <bram_DOT_adams_AT_ugent_DOT_be>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include "sql.h"

void transfer(int amount,char* reknr);
int monthlyPayment(int lowerID,int upperID);
void displayName(int ID);
int va_sum(int count,...);
int va_double_sum(int count,...);
int va_id_sum(int count,...);

int main (int charc,char** args) {
  int lowerID=7;
  int upperID=11;

  int nrFound=monthlyPayment(lowerID,upperID);
  int dsum=0;

  printf("Yes, %d out of %d people have been paid!\n",nrFound,(upperID-lowerID+1));

  dsum=va_sum(5,1,2,3,4,5);
  printf("This should be the sum of 1, 2, 3, 4 and 5, i.e. %d: %s.\n",15,((dsum==15)?"OK":"not OK"));
  dsum=va_double_sum(5,1,2,3,4,5);
  printf("This should be the sum of 1, 2, 3, 4 and 5, i.e. %d, and NOT the double sum: %s.\n",15,((dsum==15)?"OK":"not OK"));
  dsum=va_id_sum(5,1,2,3,4,5);
  printf("This should be the id sum of 5, 1, 2, 3, 4 and 5, i.e. %d: %s.\n",5,((dsum==5)?"OK":"not OK"));
  
  return 0;
}

void transfer(int amount,char* reknr){
  printf("Wiring %d Euro to account %s.\n",amount,reknr);
}

int monthlyPayment(int lowerID,int upperID){
  sqcursor* cursor=_iqcprep("select ID,wage,accountnr from accounting where %d <= ID <= %d",lowerID,upperID);
  sqlda odesc;

  int id;
  int counter=0;
  int amount;
  char* rekNr;

  while(_iqcftch(cursor, &odesc)){
    /*printf("CODE_PAYMENT:\t%d\n",sql_code);*/
    if(sql_code!=0){
      printf("Oops, some error occurred. Abandoning after %d successful fetches out of %d...\n",counter,upperID-lowerID+1);
      //      exit(0);//counter);//makefile complains
      return counter;
    }

    counter++;
    id=odesc.id;
    amount=odesc.wage;
    rekNr=odesc.accountnr;
    displayName(id);
    transfer(amount,rekNr);
    printf("----------------\n");
  }

  _iqcfin(cursor);

  return counter;
}

void displayName(int ID){
  sqcursor* cursor=_iqcprep("select ID,name from population where ID = %d",ID);
  sqlda odesc;

  char* name;

  /*if(_iqcftch(cursor, &odesc)){*/
    /*printf("CODE_NAME:\t%d\n",sql_code);*/

    _iqcftch(cursor, &odesc);
    printf("ID:\t%d\n", ID);
    if(sql_code!=0){
      printf("Name:\tUNAVAILABLE\n");

    } else {
      name=odesc.name;
      printf("Name:\t%s\n", name);
    }

    _iqcfin(cursor);
}

int va_double_sum(int count,...){
  int i,sum=0;
  va_list ap;

  va_start(ap,count);
  for(i=0;i<count;i++){
    sum+=va_arg(ap,int);
    printf("%d\n",sum);
  }
  va_end(ap);

  va_start(ap,count);
  for(i=0;i<count;i++){
    sum+=va_arg(ap,int);
    printf("%d\n",sum);
  }
  va_end(ap);

  return sum;
}

int va_sum(int count,...){
  int i,sum=0;
  va_list ap;

  va_start(ap,count);
  for(i=0;i<count;i++){
    sum+=va_arg(ap,int);
  }
  va_end(ap);

  return sum;
}

int va_id_sum(int count,...){
  return count;
}
