#include "clips.h"
#include "reteutil.h"
#include "rulepsr.h"
#include <stdio.h>
#include <stdlib.h>

static void InterpretActivation(void* env,void *vTheActivation){
	struct activation *theActivation = (struct activation *) vTheActivation;
	struct partialMatch *list;
	struct patternEntity *matchingItem;
	struct fact* the_fact;
	struct multifield * val;
	short int i;
	void* tempVoid;
	char* tempPtr;
	
	list = theActivation->basis;
	
	for (i = 0; i < (int) list->bcount; i++){
	  matchingItem = get_nth_pm_match(list,i)->matchingItem;
		
	  if (matchingItem) break; /* Skip not conditional element */
	}

	the_fact=(struct fact*) matchingItem;
	val=(struct multifield *)(the_fact->theProposition.theFields[0].value);
	tempVoid=GetMFValue(val,3);
	char* s=ValueToString(tempVoid);//DO NOT STORE THIS STRING, COPY IT (clips' GC)!!!
	tempVoid=GetMFValue(val,4);
	tempPtr=ValueToString(tempVoid);
	//	char** ss=(char**)atol(tempPtr);
	sscanf(tempPtr,"%p",&tempVoid);
	char** ss=(char**)tempVoid;
	//	unsigned long dbl=ValueToLong(tempVoid);
	//	char** ss=(char**)((void*)dbl); 

	i++;
	matchingItem = get_nth_pm_match(list,i)->matchingItem;
	the_fact=(struct fact*) matchingItem;
	val=(struct multifield *)(the_fact->theProposition.theFields[0].value);
	tempVoid=GetMFValue(val,3);
	int d=ValueToInteger(tempVoid);
	
	//no need to traverse h-fact

	printf("advice(%s,%p,%d) -> <%s>\n",s,ss,d,*ss);
}

static void* env=0;
static char tempBuffer[100];

void f(int a,char* s,char** ss){
  printf("f(%d,%s,%p) -> <%s>\n",a,s,ss,*ss);  
}

void g(char* s,int a){
  printf("g(%s,%d)\n",s,a);
}

void h(char* s,int a){
	printf("h(%s,%d)\n",s,a);
}

int assert_f(int a,char* s,char** ss){
  sprintf(tempBuffer,"(call f %d %s %p)",a,s,ss);
  AssertString(env,tempBuffer);
  return GetNumberOfActivations(env);
}

int assert_g(char* s,int d){
  sprintf(tempBuffer,"(call g %s %d)",s,d);
  AssertString(env,tempBuffer);
  return GetNumberOfActivations(env);
}

int assert_h(char* s,int d){
	sprintf(tempBuffer,"(call h %s %d)",s,d);
	AssertString(env,tempBuffer);
	return GetNumberOfActivations(env);
}
    
#define F(A,B,C) f(A,B,C);\
  {\
	int i;\
	int rules_fired=assert_f(A,B,C);		\
    struct activation *newActivation=0;\
    for(i=0;i<rules_fired;i++){\
      newActivation=EnvGetNextActivation(env,newActivation);\
      Matches(env,newActivation->theRule);\
      InterpretActivation(env,newActivation);\
      DeleteActivation(env,newActivation,1);\
    }\
  }

#define G(A,B) g(A,B);\
  {\
	int i;\
    int rules_fired=assert_g(A,B);\
    struct activation *newActivation=0;\
    for(i=0;i<rules_fired;i++){\
      newActivation=EnvGetNextActivation(env,newActivation);\
      Matches(env,newActivation->theRule);\
      InterpretActivation(env,newActivation);\
      DeleteActivation(env,newActivation,1);\
    }\
  }

#define H(A,B) h(A,B);\
  {\
	int i;\
    int rules_fired=assert_h(A,B);\
    struct activation *newActivation=0;\
    for(i=0;i<rules_fired;i++){\
      newActivation=EnvGetNextActivation(env,newActivation);\
      Matches(env,newActivation->theRule);\
      InterpretActivation(env,newActivation);\
      DeleteActivation(env,newActivation,1);\
    }\
  }

void init_engine(void){
  env=InitCImage_1();
  EnvSetFactDuplication(env,1);
  //  Clear(env);
	
  //  sprintf(tempBuffer,"(defrule span (most-recent (call h ?s ?d) (most-recent (call g ?s ?d) (call f ? ?s ?ss))) => )");
  //  RouteCommand(env,tempBuffer,TRUE);
  Reset(env);
}

void destroy_engine(void){
  DestroyEnvironment(env);
}

int main(void){
  init_engine();

  char* a="a";
  char* b="b";
  char* c="c";

  F(1,"aaa",&a);
  F(2,"bbb",&b);
  G("aaa",666);

  F(3,"ccc",&c);
  G("ccc",999);
  G("aaa",666);
  
  H("aaa",666);
  F(4,"aaa",&a);
  H("aaa",666);
  G("aaa",666);
  H("aaa",999);//does NOT trigger pcd

  destroy_engine();
	  
  return 0;
}
