#include "clips.h"
#include "rulepsr.h"
#include <stdio.h>
#include <stdlib.h>

void UserFunctions(void);
void EnvUserFunctions(void *);

typedef struct{
  int i;
} block;

typedef struct{
  char* name;
} color;

typedef struct{
  char* name;
} location;

void* getRulePtr(void* env,char* name){
  void* P = EnvFindDefrule(env,name);
  if (!P){
    printf("Rule %s not found...\n",name);
    exit(1);
  }

  return P;
}

int main(void){
  long int rules_fired=0;
  int i=0;
  struct activation *newActivation=0;
  void* P1=0;
  void* P2=0;
  void* P3=0;

  block B1={1};
  block B2={2};
  block B3={3};
  block B4={4};

  color red={"red"};
  color blue={"blue"};

  location table={"table"};
  //  char* clear="(clear)";
  char tempBuffer[100];

  void* env=CreateEnvironment();
  EnvSetFactDuplication(env,1);
  //  RouteCommand(env,clear,TRUE);
  Clear(env);

  sprintf(tempBuffer,"(defrule P1 (on ?x ?y) (left-of ?y ?z) (color ?z %p) => )",&red);
  RouteCommand(env,tempBuffer,TRUE);
  P1=getRulePtr(env,"P1");
  sprintf(tempBuffer,"(defrule P2 (on ?x ?y) (left-of ?y ?z) (color ?x %p) (left-of ?w ?y) => )",&red);
  RouteCommand(env,tempBuffer,TRUE);
  P2=getRulePtr(env,"P2");
  sprintf(tempBuffer,"(defrule P3 (on ?x ?y) (left-of ?y ?z) (color ?x %p) (color ?z %p) => )",&red,&red);
  RouteCommand(env,tempBuffer,TRUE);
  P3=getRulePtr(env,"P3");
  Reset(env);

  sprintf(tempBuffer,"(on %p %p)",&B1,&B2);
  AssertString(env,tempBuffer);
  rules_fired=GetNumberOfActivations(env);
  printf("(on %d %d)\n",B1.i,B2.i);
  if(rules_fired>0){
    printf("P1:\n");
    Matches(env,P1);
    printf("\nP2:\n");
    Matches(env,P2);
    printf("\nP3:\n");
    Matches(env,P3);
  }
  newActivation=0;
  for(i=0;i<rules_fired;i++){
    newActivation=EnvGetNextActivation(env,newActivation);
    struct partialMatch* bindings=newActivation->basis;
    printf("Removing activation...\n");
    DeleteActivation(env,newActivation,1);
  }
  printf("---------------------\n");

  sprintf(tempBuffer,"(on %p %p)",&B1,&B3);
  AssertString(env,tempBuffer);
  rules_fired=GetNumberOfActivations(env);
  printf("(on %d %d)\n",B1.i,B3.i);
  if(rules_fired>0){
    printf("P1:\n");
    Matches(env,P1);
    printf("\nP2:\n");
    Matches(env,P2);
    printf("\nP3:\n");
    Matches(env,P3);
  }
  newActivation=0;
  for(i=0;i<rules_fired;i++){
    newActivation=EnvGetNextActivation(env,newActivation);
    printf("Removing activation...\n");
    DeleteActivation(env,newActivation,1);
  }
  printf("---------------------\n");

  sprintf(tempBuffer,"(color %p %p)",&B1,&red);
  AssertString(env,tempBuffer);
  rules_fired=GetNumberOfActivations(env);
  printf("(color %d %s)\n",B1.i,red.name);
  if(rules_fired>0){
    printf("P1:\n");
    Matches(env,P1);
    printf("\nP2:\n");
    Matches(env,P2);
    printf("\nP3:\n");
    Matches(env,P3);
  }
  newActivation=0;
  for(i=0;i<rules_fired;i++){
    newActivation=EnvGetNextActivation(env,newActivation);
    printf("Removing activation...\n");
    DeleteActivation(env,newActivation,1);
  }
  printf("---------------------\n");

  sprintf(tempBuffer,"(on %p %p)",&B2,&table);
  AssertString(env,tempBuffer);
  rules_fired=GetNumberOfActivations(env);
  printf("(on %d %s)\n",B2.i,table.name);
  if(rules_fired>0){
    printf("P1:\n");
    Matches(env,P1);
    printf("\nP2:\n");
    Matches(env,P2);
    printf("\nP3:\n");
    Matches(env,P3);
  }
  newActivation=0;
  for(i=0;i<rules_fired;i++){
    newActivation=EnvGetNextActivation(env,newActivation);
    printf("Removing activation...\n");
    DeleteActivation(env,newActivation,1);
  }
  printf("---------------------\n");

  sprintf(tempBuffer,"(left-of %p %p)",&B2,&B3);
  AssertString(env,tempBuffer);
  rules_fired=GetNumberOfActivations(env);
  printf("(left-of %d %d)\n",B2.i,B3.i);
  if(rules_fired>0){
    printf("P1:\n");
    Matches(env,P1);
    printf("\nP2:\n");
    Matches(env,P2);
    printf("\nP3:\n");
    Matches(env,P3);
  }
  newActivation=0;
  for(i=0;i<rules_fired;i++){
    newActivation=EnvGetNextActivation(env,newActivation);
    printf("Removing activation...\n");
    DeleteActivation(env,newActivation,1);
  }
  printf("---------------------\n");

  sprintf(tempBuffer,"(color %p %p)",&B2,&blue);
  AssertString(env,tempBuffer);
  rules_fired=GetNumberOfActivations(env);
  printf("(color %d %s)\n",B2.i,blue.name);
  if(rules_fired>0){
    printf("P1:\n");
    Matches(env,P1);
    printf("\nP2:\n");
    Matches(env,P2);
    printf("\nP3:\n");
    Matches(env,P3);
  }
  newActivation=0;
  for(i=0;i<rules_fired;i++){
    newActivation=EnvGetNextActivation(env,newActivation);
    printf("Removing activation...\n");
    DeleteActivation(env,newActivation,1);
  }
  printf("---------------------\n");

  sprintf(tempBuffer,"(left-of %p %p)",&B3,&B4);
  AssertString(env,tempBuffer);
  rules_fired=GetNumberOfActivations(env);
  printf("(left-of %d %d)\n",B3.i,B4.i);
  if(rules_fired>0){
    printf("P1:\n");
    Matches(env,P1);
    printf("\nP2:\n");
    Matches(env,P2);
    printf("\nP3:\n");
    Matches(env,P3);
  }
  newActivation=0;
  for(i=0;i<rules_fired;i++){
    newActivation=EnvGetNextActivation(env,newActivation);
    printf("Removing activation...\n");
    DeleteActivation(env,newActivation,1);
  }
  printf("---------------------\n");

  sprintf(tempBuffer,"(on %p %p)",&B3,&table);
  AssertString(env,tempBuffer);
  rules_fired=GetNumberOfActivations(env);
  printf("(on %d %s)\n",B3.i,table.name);
  if(rules_fired>0){
    printf("P1:\n");
    Matches(env,P1);
    printf("\nP2:\n");
    Matches(env,P2);
    printf("\nP3:\n");
    Matches(env,P3);
  }
  newActivation=0;
  for(i=0;i<rules_fired;i++){
    newActivation=EnvGetNextActivation(env,newActivation);
    printf("Removing activation...\n");
    DeleteActivation(env,newActivation,1);
  }
  printf("---------------------\n");

  sprintf(tempBuffer,"(color %p %p)",&B3,&red);
  AssertString(env,tempBuffer);
  rules_fired=GetNumberOfActivations(env);
  printf("(color %d %s)\n",B3.i,red.name);
  if(rules_fired>0){
    printf("P1:\n");
    Matches(env,P1);
    printf("\nP2:\n");
    Matches(env,P2);
    printf("\nP3:\n");
    Matches(env,P3);
  }
  newActivation=0;
  for(i=0;i<rules_fired;i++){
    newActivation=EnvGetNextActivation(env,newActivation);
    printf("Removing activation...\n");
    DeleteActivation(env,newActivation,1);
  }
  printf("---------------------\n");
  //  ParseDeffacts(env,wmes); DOES not WORK, as second argument has to be name of IO router ("command")


  /*  rules_fired=GetNumberOfActivations(env);
      printf("Nr. of rules fired: %d\n",rules_fired);
      for(i=0;i<rules_fired;i++){
      newActivation=EnvGetNextActivation(env,newActivation);
      PrintActivation(env,WTRACE,newActivation);
      }
      printf("\n");
      newActivation=0;*/

  //int Matches(defrulePtr); //Purpose: Prints the partial matches and activations of a defrule
  //  void *defrulePtr; 

  //int   DeleteActivation(activationPtr);  //Purpose: Removes an activation from the agenda.
  //  void *activationPtr; 

  //int GetAgendaChanged(); FOLLOWED by SetAgendaChanged(0)
 
  //CreateFact or immediately deffacts?
 

 
  /*  printf("RUN\n");

  Run(env,-1);

  rules_fired=GetNumberOfActivations(env);
  printf("Nr. of rules fired: %d\n",rules_fired);
  for(i=0;i<rules_fired;i++){
  newActivation=EnvGetNextActivation(env,newActivation);
  PrintActivation(env,WTRACE,newActivation);
  }
  printf("\n",rules_fired);*/

  //DeallocateEnvironmentData();
  DestroyEnvironment(env);
}
