#include "clips.h"
#include "rulepsr.h"
#include <stdio.h>
#include <stdlib.h>

static void ExamineActivation(void* env,void *vTheActivation){
	struct activation *theActivation = (struct activation *) vTheActivation;
	struct partialMatch *list;
	struct patternEntity *matchingItem;
	short int i,j;
	char* tempPtr;
	double tempDbl;
	int tempInt;
	void* tempVoid;
	
	list = theActivation->basis;
	
	printf("************\n");
	printf("Activation: \n");
	
	for (i = 0; i < (int) list->bcount; i++){
		//DATA_OBJECT rtn;
		matchingItem = get_nth_pm_match(list,i)->matchingItem;
		
		if (matchingItem == NULL) continue; /* Skip not conditional element */
		
		if (matchingItem->theInfo->base.type == FACT_ADDRESS){
			/* matchingItem is a fact */
			printf("[FACT] ");
			matchingItem->theInfo->base.longPrintFunction(env,WTRACE,matchingItem);
			//FactPNGetVar1(env,matchingItem,&rtn);
			struct fact* the_fact=(struct fact*) matchingItem;
			
			if(the_fact->theProposition.theFields[0].type==MULTIFIELD){
				struct multifield * val=(struct multifield *)(the_fact->theProposition.theFields[0].value);
				//	int end = GetpDOEnd(val); 
				//	void* multifieldPtr = GetpValue(val); 
				void* multifieldPtr = val;
				//	for (j = GetpDOBegin(val); j <= end; j++) 
				for(j=0;j<=val->multifieldLength;j++){ 
					tempVoid=GetMFValue(multifieldPtr,j);
					if(!tempVoid) continue;

					printf(" (%d) ",j);
				
					if (GetMFType(multifieldPtr,j) == EXTERNAL_ADDRESS) { 
						tempPtr = ValueToString(tempVoid); 
						printf(" => <%s>\n",tempPtr);	
					}else if((GetMFType(multifieldPtr,j) == SYMBOL)||(GetMFType(multifieldPtr,j) == STRING)){
						tempPtr = ValueToString(tempVoid); 
						printf(" ==> <%s>\n",tempPtr);							
					}else if(GetMFType(multifieldPtr,j) == FLOAT){					
						tempDbl = ValueToDouble(tempVoid); 
						printf(" ===> <%f>\n",tempDbl);
					}else if(GetMFType(multifieldPtr,j) == INTEGER){
						tempInt = ValueToInteger(tempVoid); 
						printf(" ====> <%d>\n",tempInt);
					}else{
						printf(" =====> [%d]\n",GetMFType(multifieldPtr,j));	
					}
				}
			}else{
				printf("NO\n");
			}
			//	   FactSlotValue(env,matchingItem,"implied",&rtn);
			//	   int t=GetType(rtn);
			
		}else if (matchingItem->theInfo->base.type == INSTANCE_ADDRESS){
			/* matchingItem is an instance */
			printf("[INSTANCE] Should NEVER get here!\n");
			exit(1);
		}
	}
	
	printf("************\n");
}

static void InterpretActivation(void* env,void *vTheActivation){
	struct activation *theActivation = (struct activation *) vTheActivation;
	struct partialMatch *list;
	struct patternEntity *matchingItem;
	struct fact* the_fact;
	struct multifield * val;
	short int i;
	void* tempVoid;
	char* tempPtr;
	
	list = theActivation->basis;
	
	for (i = 0; i < (int) list->bcount; i++){
	  matchingItem = get_nth_pm_match(list,i)->matchingItem;
		
	  if (matchingItem) break; /* Skip not conditional element */
	}

	the_fact=(struct fact*) matchingItem;
	val=(struct multifield *)(the_fact->theProposition.theFields[0].value);
	tempVoid=GetMFValue(val,3);
	char* s=ValueToString(tempVoid);//DO NOT STORE THIS STRING, COPY IT (clips' GC)!!!
	tempVoid=GetMFValue(val,4);
	tempPtr=ValueToString(tempVoid);
	//	char** ss=(char**)atol(tempPtr);
	sscanf(tempPtr,"%p",&tempVoid);
	char** ss=(char**)tempVoid;
	//	unsigned long dbl=ValueToLong(tempVoid);
	//	char** ss=(char**)((void*)dbl); 

	i++;
	matchingItem = get_nth_pm_match(list,i)->matchingItem;
	the_fact=(struct fact*) matchingItem;
	val=(struct multifield *)(the_fact->theProposition.theFields[0].value);
	tempVoid=GetMFValue(val,3);
	int d=ValueToInteger(tempVoid);
	
	//no need to traverse h-fact

	printf("advice(%s,%p,%d) -> <%s>\n",s,ss,d,*ss);
}

static void* env=0;
static char tempBuffer[100];

void f(int a,char* s,char** ss){
  printf("f(%d,%s,%p) -> <%s>\n",a,s,ss,*ss);
}

void g(char* s,int a){
  printf("g(%s,%d)\n",s,a);
}

void h(char* s,int a){
	printf("h(%s,%d)\n",s,a);
}

int assert_f(int a,char* s,char** ss){
  sprintf(tempBuffer,"(call f %d %s %p)",a,s,ss);
  AssertString(env,tempBuffer);
  return GetNumberOfActivations(env);
}

int assert_g(char* s,int d){
  sprintf(tempBuffer,"(call g %s %d)",s,d);
  AssertString(env,tempBuffer);
  return GetNumberOfActivations(env);
}

int assert_h(char* s,int d){
	sprintf(tempBuffer,"(call h %s %d)",s,d);
	AssertString(env,tempBuffer);
	return GetNumberOfActivations(env);
}
    
#define F(A,B,C) f(A,B,C);\
  assert_f(A,B,C);

#define G(A,B) g(A,B);\
assert_g(A,B);

#define H(A,B) h(A,B);\
  {\
	int i;\
    int rules_fired=assert_h(A,B);\
    struct activation *newActivation=0;\
    for(i=0;i<rules_fired;i++){\
      newActivation=EnvGetNextActivation(env,newActivation);\
      Matches(env,newActivation->theRule);\
      InterpretActivation(env,newActivation);\
      DeleteActivation(env,newActivation,1);\
    }\
  }

void init_engine(void){
  env=CreateEnvironment();
  EnvSetFactDuplication(env,1);
  Clear(env);
	
  sprintf(tempBuffer,"(defrule span (call f ? ?s ?ss) (call g ?s ?d) (call h ?s ?d) => )");
  RouteCommand(env,tempBuffer,TRUE);
  Reset(env);
}

void destroy_engine(void){
  DestroyEnvironment(env);
}

int main(void){
  init_engine();

  char* a="a";
  char* b="b";
  char* c="c";

  F(1,"aaa",&a);
  F(2,"bbb",&b);
  G("aaa",666);

  F(3,"ccc",&c);
  G("ccc",999);
  
  H("aaa",666);
  F(4,"aaa",&a);
  H("aaa",666);
  H("aaa",999);//does NOT trigger pcd

  destroy_engine();

  return 0;
}
