#include "clips.h"
#include "rulepsr.h"
#include <stdio.h>
#include <stdlib.h>

void UserFunctions(void);
void EnvUserFunctions(void *);

typedef struct{
  int i;
} block;

typedef struct{
  char* name;
} color;

typedef struct{
  char* name;
} location;

void* getRulePtr(void* env,char* name){
  void* P = EnvFindDefrule(env,name);
  if (!P){
    printf("Rule %s not found...\n",name);
    exit(1);
  }

  return P;
}

int main(void){
  long int rules_fired=0;
  int i=0;
  struct activation *newActivation=0;
  void* P1=0;
  char tempBuffer[100];

  void* env=CreateEnvironment();
  EnvSetFactDuplication(env,1);
  //  RouteCommand(env,clear,TRUE);
  Clear(env);

  sprintf(tempBuffer,"(defrule example (pattern 1) (or (pattern 2a) (pattern 2b)) (not (pattern 3)) (pattern 4) =>)");
  RouteCommand(env,tempBuffer,TRUE);
  P1=getRulePtr(env,"example");
  Reset(env);

  sprintf(tempBuffer,"(pattern 1)");
  AssertString(env,tempBuffer);
  rules_fired=GetNumberOfActivations(env);
  printf("(pattern 1)\n");
  if(rules_fired>0){
    printf("example:\n");
    Matches(env,P1);
  }
  newActivation=0;
  for(i=0;i<rules_fired;i++){
    newActivation=EnvGetNextActivation(env,newActivation);
    struct partialMatch* bindings=newActivation->basis;
    printf("Removing activation...\n");
    DeleteActivation(env,newActivation,1);
  }
  printf("---------------------\n");

  sprintf(tempBuffer,"(pattern 2a)");
  AssertString(env,tempBuffer);
  rules_fired=GetNumberOfActivations(env);
  printf("(pattern 2a)\n");
  if(rules_fired>0){
    printf("example:\n");
    Matches(env,P1);
  }
  newActivation=0;
  for(i=0;i<rules_fired;i++){
    newActivation=EnvGetNextActivation(env,newActivation);
    printf("Removing activation...\n");
    DeleteActivation(env,newActivation,1);
  }
  printf("---------------------\n");

  sprintf(tempBuffer,"(pattern 4)");
  AssertString(env,tempBuffer);
  rules_fired=GetNumberOfActivations(env);
  printf("(pattern 4)\n");
  if(rules_fired>0){
    printf("example:\n");
    Matches(env,P1);
  }
  newActivation=0;
  for(i=0;i<rules_fired;i++){
    newActivation=EnvGetNextActivation(env,newActivation);
    printf("Removing activation...\n");
    DeleteActivation(env,newActivation,1);
  }
  printf("---------------------\n");

  //  ParseDeffacts(env,wmes); DOES not WORK, as second argument has to be name of IO router ("command")


  /*  rules_fired=GetNumberOfActivations(env);
      printf("Nr. of rules fired: %d\n",rules_fired);
      for(i=0;i<rules_fired;i++){
      newActivation=EnvGetNextActivation(env,newActivation);
      PrintActivation(env,WTRACE,newActivation);
      }
      printf("\n");
      newActivation=0;*/

  //int Matches(defrulePtr); //Purpose: Prints the partial matches and activations of a defrule
  //  void *defrulePtr; 

  //int   DeleteActivation(activationPtr);  //Purpose: Removes an activation from the agenda.
  //  void *activationPtr; 

  //int GetAgendaChanged(); FOLLOWED by SetAgendaChanged(0)
 
  //CreateFact or immediately deffacts?
 

 
  /*  printf("RUN\n");

  Run(env,-1);

  rules_fired=GetNumberOfActivations(env);
  printf("Nr. of rules fired: %d\n",rules_fired);
  for(i=0;i<rules_fired;i++){
  newActivation=EnvGetNextActivation(env,newActivation);
  PrintActivation(env,WTRACE,newActivation);
  }
  printf("\n",rules_fired);*/

  //DeallocateEnvironmentData();
  DestroyEnvironment(env);
}
