/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen.expr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jaxen.Context;
import org.jaxen.ContextSupport;
import org.jaxen.JaxenException;
import org.jaxen.Navigator;
import org.jaxen.UnresolvableException;
import org.jaxen.expr.DefaultStep;
import org.jaxen.expr.NameStep;
import org.jaxen.expr.PredicateSet;
import org.jaxen.expr.Visitor;
import org.jaxen.expr.iter.IterableAxis;
import org.jaxen.util.IdentityHashMap;

public class DefaultNameStep
extends DefaultStep
implements NameStep {
    private static final Object PRESENT = new Object();
    private String prefix;
    private String localName;
    private boolean matchesAnyName;
    boolean hasPrefix;

    public DefaultNameStep(IterableAxis axis, String prefix, String localName, PredicateSet predicateSet) {
        super(axis, predicateSet);
        this.prefix = prefix;
        this.localName = localName;
        this.matchesAnyName = "*".equals(localName);
        this.hasPrefix = this.prefix != null && this.prefix.length() > 0;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getLocalName() {
        return this.localName;
    }

    public boolean isMatchesAnyName() {
        return this.matchesAnyName;
    }

    public String getText() {
        StringBuffer buf = new StringBuffer(64);
        buf.append(this.getAxisName()).append("::");
        if (this.getPrefix() != null && this.getPrefix().length() > 0) {
            buf.append(this.getPrefix()).append(':');
        }
        return buf.append(this.getLocalName()).append(super.getText()).toString();
    }

    /*
     * Unable to fully structure code
     */
    public List evaluate(Context context) throws JaxenException {
        block13: {
            block11: {
                contextNodeSet = context.getNodeSet();
                contextSize = contextNodeSet.size();
                if (contextSize == 0) {
                    return Collections.EMPTY_LIST;
                }
                support = context.getContextSupport();
                v0 = namedAccess = this.matchesAnyName == false && this.getIterableAxis().supportsNamedAccess(support) != false;
                if (contextSize == 1) {
                    contextNode = contextNodeSet.get(0);
                    if (namedAccess) {
                        uri = support.translateNamespacePrefixToUri(this.prefix);
                        axisNodeIter = this.getIterableAxis().namedAccessIterator(contextNode, support, this.localName, this.prefix, uri);
                        if (axisNodeIter == null || !axisNodeIter.hasNext()) {
                            return Collections.EMPTY_LIST;
                        }
                        newNodeSet = new ArrayList<E>();
                        while (axisNodeIter.hasNext()) {
                            newNodeSet.add(axisNodeIter.next());
                        }
                        return this.getPredicateSet().evaluatePredicates(newNodeSet, support);
                    }
                    axisNodeIter = this.axisIterator(contextNode, support);
                    if (axisNodeIter == null || !axisNodeIter.hasNext()) {
                        return Collections.EMPTY_LIST;
                    }
                    eachAxisNode = null;
                    newNodeSet = new ArrayList<Object>();
                    while (axisNodeIter.hasNext()) {
                        eachAxisNode = axisNodeIter.next();
                        if (!this.matches(eachAxisNode, support)) continue;
                        newNodeSet.add(eachAxisNode);
                    }
                    return this.getPredicateSet().evaluatePredicates(newNodeSet, support);
                }
                unique = new IdentityHashMap();
                interimSet = new ArrayList<E>();
                newNodeSet = new ArrayList<E>();
                eachContextNode = null;
                eachAxisNode = null;
                if (!namedAccess) break block11;
                uri = support.translateNamespacePrefixToUri(this.prefix);
                i = 0;
                while (i < contextSize) {
                    block12: {
                        eachContextNode = contextNodeSet.get(i);
                        axisNodeIter = this.getIterableAxis().namedAccessIterator(eachContextNode, support, this.localName, this.prefix, uri);
                        if (axisNodeIter != null && axisNodeIter.hasNext()) ** GOTO lbl49
                        break block12;
lbl-1000:
                        // 1 sources

                        {
                            eachAxisNode = axisNodeIter.next();
                            if (unique.put(eachAxisNode, DefaultNameStep.PRESENT) != null) continue;
                            interimSet.add(eachAxisNode);
lbl49:
                            // 3 sources

                            ** while (axisNodeIter.hasNext())
                        }
lbl50:
                        // 1 sources

                        newNodeSet.addAll(this.getPredicateSet().evaluatePredicates(interimSet, support));
                        interimSet.clear();
                    }
                    ++i;
                }
                break block13;
            }
            i = 0;
            while (i < contextSize) {
                block14: {
                    eachContextNode = contextNodeSet.get(i);
                    axisNodeIter = this.axisIterator(eachContextNode, support);
                    if (axisNodeIter != null && axisNodeIter.hasNext()) ** GOTO lbl68
                    break block14;
lbl-1000:
                    // 1 sources

                    {
                        eachAxisNode = axisNodeIter.next();
                        if (!this.matches(eachAxisNode, support) || unique.put(eachAxisNode, DefaultNameStep.PRESENT) != null) continue;
                        interimSet.add(eachAxisNode);
lbl68:
                        // 3 sources

                        ** while (axisNodeIter.hasNext())
                    }
lbl69:
                    // 1 sources

                    newNodeSet.addAll(this.getPredicateSet().evaluatePredicates(interimSet, support));
                    interimSet.clear();
                }
                ++i;
            }
        }
        return newNodeSet;
    }

    public boolean matches(Object node, ContextSupport contextSupport) throws JaxenException {
        Navigator nav = contextSupport.getNavigator();
        String myUri = null;
        String nodeName = null;
        String nodeUri = null;
        if (nav.isElement(node)) {
            nodeName = nav.getElementName(node);
            nodeUri = nav.getElementNamespaceUri(node);
        } else {
            if (nav.isText(node)) {
                return false;
            }
            if (nav.isAttribute(node)) {
                if (this.getAxis() != 9) {
                    return false;
                }
                nodeName = nav.getAttributeName(node);
                nodeUri = nav.getAttributeNamespaceUri(node);
            } else {
                if (nav.isDocument(node)) {
                    return false;
                }
                if (nav.isNamespace(node)) {
                    if (this.matchesAnyName && this.getAxis() != 10) {
                        return false;
                    }
                    nodeName = nav.getNamespacePrefix(node);
                } else {
                    return false;
                }
            }
        }
        if (this.hasPrefix) {
            myUri = contextSupport.translateNamespacePrefixToUri(this.prefix);
            if (myUri == null) {
                throw new UnresolvableException("Cannot resolve namespace prefix '" + this.prefix + "'");
            }
        } else if (this.matchesAnyName) {
            return true;
        }
        if (this.hasNamespace(myUri) != this.hasNamespace(nodeUri)) {
            return false;
        }
        if (this.matchesAnyName || nodeName.equals(this.getLocalName())) {
            return this.matchesNamespaceURIs(myUri, nodeUri);
        }
        return false;
    }

    private boolean hasNamespace(String uri) {
        return uri != null && uri.length() > 0;
    }

    protected boolean matchesNamespaceURIs(String uri1, String uri2) {
        if (uri1 == uri2) {
            return true;
        }
        if (uri1 == null) {
            return uri2.length() == 0;
        }
        if (uri2 == null) {
            return uri1.length() == 0;
        }
        return uri1.equals(uri2);
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return "[(DefaultNameStep): " + this.getPrefix() + ":" + this.getLocalName() + "[" + super.toString() + "]]";
    }
}

