/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.AugmentedSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.OutputURIResolver;
import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.StandardErrorListener;
import net.sf.saxon.TransformerFactoryImpl;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.CharacterMapExpander;
import net.sf.saxon.event.Emitter;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SaxonOutputKeys;
import net.sf.saxon.event.Sender;
import net.sf.saxon.event.StandardOutputResolver;
import net.sf.saxon.event.Stripper;
import net.sf.saxon.event.TransformerReceiver;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.instruct.ApplyTemplates;
import net.sf.saxon.instruct.Bindery;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.GlobalParameterSet;
import net.sf.saxon.instruct.GlobalVariable;
import net.sf.saxon.instruct.InstructionDetails;
import net.sf.saxon.instruct.ParameterSet;
import net.sf.saxon.instruct.Procedure;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.instruct.Template;
import net.sf.saxon.instruct.TerminationException;
import net.sf.saxon.om.AllElementStripper;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.DocumentPool;
import net.sf.saxon.om.ExternalObjectModel;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.om.StrippedDocument;
import net.sf.saxon.sort.IntHashMap;
import net.sf.saxon.tinytree.TinyBuilder;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trace.InstructionInfoProvider;
import net.sf.saxon.trace.TraceEventMulticaster;
import net.sf.saxon.trace.TraceListener;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.KeyManager;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.RuleManager;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.TreeBuilder;
import net.sf.saxon.value.DateTimeValue;
import org.xml.sax.SAXParseException;

public class Controller
extends Transformer
implements InstructionInfoProvider {
    private Configuration config;
    private DocumentInfo principalSourceDocument;
    private Bindery bindery;
    private NamePool namePool;
    private Emitter messageEmitter;
    private RuleManager ruleManager;
    private Properties outputProperties;
    private GlobalParameterSet parameters;
    private PreparedStylesheet preparedStylesheet;
    private TraceListener traceListener;
    private boolean tracingPaused;
    private URIResolver standardURIResolver;
    private URIResolver userURIResolver;
    private Result principalResult;
    private String principalResultURI;
    private OutputURIResolver outputURIResolver;
    private ErrorListener errorListener;
    private Executable executable;
    private int treeModel = 1;
    private Template initialTemplate = null;
    private HashSet allOutputDestinations;
    private DocumentPool sourceDocumentPool;
    private HashMap userDataTable;
    private DateTimeValue currentDateTime;
    private boolean dateTimePreset = false;
    private int initialMode = -1;
    private NodeInfo lastRememberedNode = null;
    private int lastRememberedNumber = -1;
    private ClassLoader classLoader;

    public Controller(Configuration configuration) {
        this.config = configuration;
        this.executable = new Executable();
        this.executable.setConfiguration(configuration);
        this.executable.setHostLanguage(configuration.getHostLanguage());
        this.sourceDocumentPool = new DocumentPool();
        this.reset();
    }

    public Controller(Configuration configuration, Executable executable) {
        this.config = configuration;
        this.executable = executable;
        this.sourceDocumentPool = new DocumentPool();
        this.reset();
    }

    public void reset() {
        Object object;
        this.bindery = new Bindery();
        this.namePool = NamePool.getDefaultNamePool();
        this.standardURIResolver = this.config.getSystemURIResolver();
        this.userURIResolver = this.config.getURIResolver();
        this.outputURIResolver = this.config.getOutputURIResolver();
        this.errorListener = this.config.getErrorListener();
        if (this.errorListener instanceof StandardErrorListener) {
            object = ((StandardErrorListener)this.errorListener).getErrorOutput();
            this.errorListener = ((StandardErrorListener)this.errorListener).makeAnother(this.executable.getHostLanguage());
            ((StandardErrorListener)this.errorListener).setErrorOutput((PrintStream)object);
            ((StandardErrorListener)this.errorListener).setRecoveryPolicy(this.config.getRecoveryPolicy());
        }
        this.userDataTable = new HashMap(20);
        this.traceListener = null;
        this.tracingPaused = false;
        object = this.config.getTraceListener();
        if (object != null) {
            this.addTraceListener((TraceListener)object);
        }
        this.setTreeModel(this.config.getTreeModel());
        this.principalSourceDocument = null;
        this.messageEmitter = null;
        this.outputProperties = null;
        this.parameters = null;
        this.principalResult = null;
        this.principalResultURI = null;
        this.initialTemplate = null;
        this.allOutputDestinations = null;
        this.currentDateTime = null;
        this.dateTimePreset = false;
        this.initialMode = -1;
        this.lastRememberedNode = null;
        this.lastRememberedNumber = -1;
        this.classLoader = null;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void setInitialMode(String string) {
        if (string == null) {
            return;
        }
        if (string.equals("")) {
            return;
        }
        this.initialMode = this.namePool.allocateClarkName(string);
    }

    public void setOutputProperties(Properties properties) {
        if (properties == null) {
            this.outputProperties = null;
        } else {
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                this.setOutputProperty(string, properties.getProperty(string));
            }
        }
    }

    public Properties getOutputProperties() {
        if (this.outputProperties == null) {
            if (this.executable == null) {
                return new Properties();
            }
            this.outputProperties = this.executable.getDefaultOutputProperties();
        }
        Properties properties = new Properties();
        Enumeration<?> enumeration = this.outputProperties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            properties.put(string, this.outputProperties.getProperty(string));
        }
        return properties;
    }

    public void setOutputProperty(String string, String string2) {
        if (this.outputProperties == null) {
            this.outputProperties = this.getOutputProperties();
        }
        try {
            SaxonOutputKeys.checkOutputProperty(string, string2, this.getConfiguration().getNameChecker());
        }
        catch (DynamicError dynamicError) {
            throw new IllegalArgumentException(dynamicError.getMessage());
        }
        this.outputProperties.put(string, string2);
    }

    public String getOutputProperty(String string) {
        try {
            SaxonOutputKeys.checkOutputProperty(string, null, this.getConfiguration().getNameChecker());
        }
        catch (DynamicError dynamicError) {
            throw new IllegalArgumentException(dynamicError.getMessage());
        }
        if (this.outputProperties == null) {
            if (this.executable == null) {
                return null;
            }
            this.outputProperties = this.executable.getDefaultOutputProperties();
        }
        return this.outputProperties.getProperty(string);
    }

    public void setBaseOutputURI(String string) {
        this.principalResultURI = string;
    }

    public String getBaseOutputURI() {
        return this.principalResultURI;
    }

    public Result getPrincipalResult() {
        return this.principalResult;
    }

    public boolean checkUniqueOutputDestination(String string) {
        if (this.allOutputDestinations == null) {
            this.allOutputDestinations = new HashSet(20);
        }
        if (this.allOutputDestinations.contains(string)) {
            return false;
        }
        this.allOutputDestinations.add(string);
        return true;
    }

    public void setInitialTemplate(String string) throws XPathException {
        int n = this.namePool.allocateClarkName(string);
        Template template = this.getExecutable().getNamedTemplate(n);
        if (template == null) {
            DynamicError dynamicError = new DynamicError("There is no named template with expanded name " + string);
            dynamicError.setErrorCode("XTDE0040");
            throw dynamicError;
        }
        this.initialTemplate = template;
    }

    public PipelineConfiguration makePipelineConfiguration() {
        PipelineConfiguration pipelineConfiguration = new PipelineConfiguration();
        pipelineConfiguration.setConfiguration(this.getConfiguration());
        pipelineConfiguration.setErrorListener(this.getErrorListener());
        pipelineConfiguration.setURIResolver(this.userURIResolver == null ? this.standardURIResolver : this.userURIResolver);
        pipelineConfiguration.setController(this);
        if (this.getExecutable() != null) {
            pipelineConfiguration.setLocationProvider(this.getExecutable().getLocationMap());
        }
        return pipelineConfiguration;
    }

    public Emitter makeMessageEmitter() throws XPathException {
        String string = this.config.getMessageEmitterClass();
        Object object = this.config.getInstance(string, this.getClassLoader());
        if (!(object instanceof Emitter)) {
            throw new DynamicError(string + " is not an Emitter");
        }
        this.setMessageEmitter((Emitter)object);
        return this.messageEmitter;
    }

    public void setMessageEmitter(Emitter emitter) {
        this.messageEmitter = emitter;
        this.messageEmitter.setPipelineConfiguration(this.makePipelineConfiguration());
    }

    public Emitter getMessageEmitter() {
        return this.messageEmitter;
    }

    public CharacterMapExpander makeCharacterMapExpander(String string) throws XPathException {
        CharacterMapExpander characterMapExpander = null;
        IntHashMap intHashMap = this.getExecutable().getCharacterMapIndex();
        if (string != null && intHashMap != null) {
            ArrayList<IntHashMap> arrayList = new ArrayList<IntHashMap>(5);
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                int n = this.namePool.getFingerprintForExpandedName(string2);
                IntHashMap intHashMap2 = (IntHashMap)intHashMap.get(n);
                if (intHashMap2 == null) {
                    throw new DynamicError("Character map '" + string2 + "' has not been defined");
                }
                arrayList.add(intHashMap2);
            }
            if (arrayList.size() > 0) {
                characterMapExpander = new CharacterMapExpander();
                characterMapExpander.setCharacterMaps(arrayList);
            }
        }
        return characterMapExpander;
    }

    public int getRecoveryPolicy() {
        if (this.errorListener instanceof StandardErrorListener) {
            return ((StandardErrorListener)this.errorListener).getRecoveryPolicy();
        }
        return 1;
    }

    public void setErrorListener(ErrorListener errorListener) {
        this.errorListener = errorListener;
    }

    public ErrorListener getErrorListener() {
        return this.errorListener;
    }

    public void recoverableError(XPathException xPathException) throws DynamicError {
        try {
            if (this.executable.getHostLanguage() == 51) {
                this.reportFatalError(xPathException);
                throw xPathException;
            }
            this.errorListener.error(xPathException);
        }
        catch (TransformerException transformerException) {
            DynamicError dynamicError = DynamicError.makeDynamicError(transformerException);
            dynamicError.setHasBeenReported();
            throw dynamicError;
        }
    }

    public void reportFatalError(XPathException xPathException) {
        if (!xPathException.hasBeenReported()) {
            try {
                this.getErrorListener().fatalError(xPathException);
            }
            catch (TransformerException transformerException) {
                // empty catch block
            }
            xPathException.setHasBeenReported();
        }
    }

    public Executable getExecutable() {
        return this.executable;
    }

    public DocumentPool getDocumentPool() {
        return this.sourceDocumentPool;
    }

    public void clearDocumentPool() {
        this.sourceDocumentPool = new DocumentPool();
    }

    public void setPrincipalSourceDocument(DocumentInfo documentInfo) {
        this.principalSourceDocument = documentInfo;
    }

    public Bindery getBindery() {
        return this.bindery;
    }

    public DocumentInfo getPrincipalSourceDocument() {
        return this.principalSourceDocument;
    }

    public void setURIResolver(URIResolver uRIResolver) {
        this.userURIResolver = uRIResolver;
    }

    public URIResolver getURIResolver() {
        return this.userURIResolver;
    }

    public URIResolver getStandardURIResolver() {
        return this.standardURIResolver;
    }

    public void setOutputURIResolver(OutputURIResolver outputURIResolver) {
        this.outputURIResolver = outputURIResolver == null ? StandardOutputResolver.getInstance() : outputURIResolver;
    }

    public OutputURIResolver getOutputURIResolver() {
        return this.outputURIResolver;
    }

    public KeyManager getKeyManager() {
        return this.executable.getKeyManager();
    }

    public NamePool getNamePool() {
        return this.namePool;
    }

    public void setTreeModel(int n) {
        this.treeModel = n;
    }

    public Builder makeBuilder() {
        Builder builder = this.treeModel == 1 ? new TinyBuilder() : new TreeBuilder();
        builder.setTiming(this.config.isTiming());
        builder.setLineNumbering(this.config.isLineNumbering());
        builder.setPipelineConfiguration(this.makePipelineConfiguration());
        return builder;
    }

    public Stripper makeStripper(Receiver receiver) {
        if (this.config.isStripsAllWhiteSpace()) {
            if (receiver == null) {
                return AllElementStripper.getInstance();
            }
            AllElementStripper allElementStripper = new AllElementStripper();
            allElementStripper.setUnderlyingReceiver(receiver);
            return allElementStripper;
        }
        Stripper stripper = this.executable == null ? new Stripper(new Mode(-4)) : this.executable.newStripper();
        stripper.setPipelineConfiguration(this.makePipelineConfiguration());
        if (receiver != null) {
            stripper.setUnderlyingReceiver(receiver);
        }
        return stripper;
    }

    public void registerDocument(DocumentInfo documentInfo, String string) {
        this.sourceDocumentPool.add(documentInfo, string);
    }

    public void setRuleManager(RuleManager ruleManager) {
        this.ruleManager = ruleManager;
    }

    public RuleManager getRuleManager() {
        return this.ruleManager;
    }

    public TraceListener getTraceListener() {
        return this.traceListener;
    }

    public final boolean isTracing() {
        return this.traceListener != null && !this.tracingPaused;
    }

    public final void pauseTracing(boolean bl) {
        this.tracingPaused = bl;
    }

    public void addTraceListener(TraceListener traceListener) {
        this.traceListener = TraceEventMulticaster.add(this.traceListener, traceListener);
    }

    public void removeTraceListener(TraceListener traceListener) {
        this.traceListener = TraceEventMulticaster.remove(this.traceListener, traceListener);
    }

    public void setPreparedStylesheet(PreparedStylesheet preparedStylesheet) {
        this.preparedStylesheet = preparedStylesheet;
        this.executable = preparedStylesheet.getExecutable();
    }

    public void setExecutable(Executable executable) {
        this.executable = executable;
    }

    public void initializeController() throws XPathException {
        this.setRuleManager(this.executable.getRuleManager());
        if (this.traceListener != null) {
            this.traceListener.open();
        }
        this.bindery = new Bindery();
        this.executable.initialiseBindery(this.bindery);
        this.defineGlobalParameters(this.bindery);
    }

    public void defineGlobalParameters(Bindery bindery) throws XPathException {
        this.executable.checkAllRequiredParamsArePresent(this.parameters);
        bindery.defineGlobalParameters(this.parameters);
    }

    public Object getUserData(Object object, String string) {
        String string2 = object.hashCode() + " " + string;
        return this.userDataTable.get(string2);
    }

    public void setUserData(Object object, String string, Object object2) {
        String string2 = object.hashCode() + " " + string;
        if (object2 == null) {
            this.userDataTable.remove(string2);
        } else {
            this.userDataTable.put(string2, object2);
        }
    }

    public void transform(Source source, Result result) throws TransformerException {
        if (this.preparedStylesheet == null) {
            throw new DynamicError("Stylesheet has not been prepared");
        }
        if (!this.dateTimePreset) {
            this.currentDateTime = null;
        }
        try {
            Object object;
            NodeInfo nodeInfo = null;
            boolean bl = true;
            int n = this.config.getSchemaValidationMode();
            Object object2 = source;
            if (source instanceof AugmentedSource) {
                int n2;
                object = ((AugmentedSource)source).getWrapDocument();
                if (object != null) {
                    bl = (Boolean)object;
                }
                if ((n2 = ((AugmentedSource)source).getSchemaValidation()) != 0) {
                    n = n2;
                }
                if (n == 1 || n == 2) {
                    bl = false;
                }
                object2 = ((AugmentedSource)source).getContainedSource();
            }
            if ((object = this.config.getSourceResolver().resolveSource((Source)object2, this.config)) != null) {
                object2 = object;
            }
            if (bl && (object2 instanceof NodeInfo || object2 instanceof DOMSource)) {
                nodeInfo = this.prepareInputTree((Source)object2);
                this.registerDocument(nodeInfo.getDocumentRoot(), object2.getSystemId());
            } else if (source == null) {
                if (this.initialTemplate == null) {
                    throw new DynamicError("Either a source document or an initial template must be specified");
                }
            } else {
                Builder builder = this.makeBuilder();
                Sender sender = new Sender(this.makePipelineConfiguration());
                Receiver receiver = builder;
                if (this.config.isStripsAllWhiteSpace() || this.executable.stripsWhitespace() || n == 1 || n == 2) {
                    receiver = this.makeStripper(builder);
                }
                if (this.executable.stripsInputTypeAnnotations()) {
                    receiver = this.config.getAnnotationStripper(receiver);
                }
                sender.send(source, receiver);
                DocumentInfo documentInfo = (DocumentInfo)builder.getCurrentRoot();
                this.registerDocument(documentInfo, source.getSystemId());
                nodeInfo = documentInfo;
            }
            this.transformDocument(nodeInfo, result);
        }
        catch (TerminationException terminationException) {
            throw terminationException;
        }
        catch (XPathException xPathException) {
            Throwable throwable = xPathException.getException();
            if (throwable != null && throwable instanceof SAXParseException) {
                SAXParseException sAXParseException = (SAXParseException)throwable;
                if ((throwable = sAXParseException.getException()) instanceof RuntimeException) {
                    this.reportFatalError(xPathException);
                }
            } else {
                this.reportFatalError(xPathException);
            }
            throw xPathException;
        }
    }

    public NodeInfo prepareInputTree(Source source) {
        NodeInfo nodeInfo = Controller.unravel(source, this.getConfiguration());
        if (this.executable.stripsWhitespace()) {
            DocumentInfo documentInfo = nodeInfo.getDocumentRoot();
            StrippedDocument strippedDocument = new StrippedDocument(documentInfo, this.makeStripper(null));
            nodeInfo = strippedDocument.wrap(nodeInfo);
        }
        return nodeInfo;
    }

    public static NodeInfo unravel(Source source, Configuration configuration) {
        List list = configuration.getExternalObjectModels();
        for (int i = 0; i < list.size(); ++i) {
            ExternalObjectModel externalObjectModel = (ExternalObjectModel)list.get(i);
            NodeInfo nodeInfo = externalObjectModel.unravel(source, configuration);
            if (nodeInfo == null) continue;
            return nodeInfo;
        }
        if (source instanceof NodeInfo) {
            return (NodeInfo)source;
        }
        return null;
    }

    public void transformDocument(NodeInfo nodeInfo, Result result) throws TransformerException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if (this.executable == null) {
            throw new DynamicError("Stylesheet has not been compiled");
        }
        boolean bl = result instanceof StreamResult && ((StreamResult)result).getOutputStream() == null;
        this.principalResult = result;
        if (this.principalResultURI == null) {
            this.principalResultURI = result.getSystemId();
        }
        XPathContextMajor xPathContextMajor = this.newXPathContext();
        xPathContextMajor.setOrigin(this);
        if (nodeInfo != null) {
            if (nodeInfo instanceof DocumentInfo) {
                object4 = (DocumentInfo)nodeInfo;
            } else {
                object4 = nodeInfo.getDocumentRoot();
                if (object4 == null) {
                    throw new DynamicError("Source tree must have a document node as its root");
                }
            }
            this.principalSourceDocument = object4;
            if (object4.getConfiguration() == null) {
                throw new TransformerException("The supplied source document must be associated with a Configuration");
            }
            if (object4.getNamePool() != this.preparedStylesheet.getTargetNamePool()) {
                throw new DynamicError("Source document and stylesheet must use the same name pool");
            }
            object3 = SingletonIterator.makeIterator((Item)object4);
            object3.next();
            xPathContextMajor.setCurrentIterator((SequenceIterator)object3);
        }
        this.initializeController();
        if (this.getConfiguration().getTraceListener() != null) {
            this.preEvaluateGlobals(xPathContextMajor);
        }
        object4 = this.executable.getDefaultOutputProperties();
        if (this.outputProperties != null) {
            object3 = this.outputProperties.propertyNames();
            while (object3.hasMoreElements()) {
                object2 = (String)object3.nextElement();
                object = this.outputProperties.getProperty((String)object2);
                ((Properties)object4).put(object2, object);
            }
        }
        if ((object3 = ((Properties)object4).getProperty("{http://saxon.sf.net/}next-in-chain")) != null) {
            object2 = ((Properties)object4).getProperty("{http://saxon.sf.net/}next-in-chain-base-uri");
            result = this.prepareNextStylesheet((String)object3, (String)object2, result);
        }
        xPathContextMajor.changeOutputDestination((Properties)object4, result, true, 3, null);
        xPathContextMajor.getReceiver().startDocument(0);
        if (this.initialTemplate == null) {
            object2 = SingletonIterator.makeIterator(nodeInfo);
            xPathContextMajor.setCurrentIterator((SequenceIterator)object2);
            DocumentInfo documentInfo = this.principalSourceDocument = nodeInfo == null ? null : nodeInfo.getDocumentRoot();
            if (this.principalSourceDocument == null) {
                throw new DynamicError("Source tree must be rooted at a document node");
            }
            for (object = ApplyTemplates.applyTemplates(xPathContextMajor.getCurrentIterator(), this.getRuleManager().getMode(this.initialMode), null, null, xPathContextMajor, false, 0); object != null; object = object.processLeavingTail(xPathContextMajor)) {
            }
        } else {
            object2 = this.initialTemplate;
            object = xPathContextMajor.newContext();
            ((XPathContextMajor)object).setOrigin(this);
            ((XPathContextMajor)object).openStackFrame(((Procedure)object2).getStackFrameMap());
            ((XPathContextMajor)object).setLocalParameters(new ParameterSet());
            ((XPathContextMajor)object).setTunnelParameters(new ParameterSet());
            for (TailCall tailCall = ((Template)object2).expand((XPathContext)object); tailCall != null; tailCall = tailCall.processLeavingTail((XPathContext)object)) {
            }
        }
        if (this.traceListener != null) {
            this.traceListener.close();
        }
        xPathContextMajor.getReceiver().endDocument();
        xPathContextMajor.getReceiver().close();
        if (bl && result instanceof StreamResult && (object2 = ((StreamResult)result).getOutputStream()) != null) {
            try {
                ((OutputStream)object2).close();
            }
            catch (IOException iOException) {
                throw new DynamicError(iOException);
            }
        }
    }

    public void preEvaluateGlobals(XPathContext xPathContext) throws XPathException {
        IntHashMap intHashMap = this.getExecutable().getCompiledGlobalVariables();
        Iterator iterator = intHashMap.valueIterator();
        while (iterator.hasNext()) {
            GlobalVariable globalVariable = (GlobalVariable)iterator.next();
            globalVariable.evaluateVariable(xPathContext);
        }
    }

    public Result prepareNextStylesheet(String string, String string2, Result result) throws TransformerException {
        Source source = null;
        if (this.userURIResolver != null) {
            source = this.userURIResolver.resolve(string, string2);
        }
        if (source == null) {
            source = this.standardURIResolver.resolve(string, string2);
        }
        TransformerFactoryImpl transformerFactoryImpl = new TransformerFactoryImpl();
        transformerFactoryImpl.setConfiguration(this.config);
        Templates templates = transformerFactoryImpl.newTemplates(source);
        TransformerReceiver transformerReceiver = new TransformerReceiver((Controller)templates.newTransformer());
        transformerReceiver.setSystemId(this.principalResultURI);
        transformerReceiver.setPipelineConfiguration(this.makePipelineConfiguration());
        transformerReceiver.setResult(result);
        return transformerReceiver;
    }

    public void setParameter(String string, Object object) {
        if (this.parameters == null) {
            this.parameters = new GlobalParameterSet();
        }
        int n = this.namePool.allocateClarkName(string);
        this.parameters.put(n, object);
    }

    public void clearParameters() {
        this.parameters = null;
    }

    public Object getParameter(String string) {
        if (this.parameters == null) {
            return null;
        }
        int n = this.namePool.allocateClarkName(string);
        return this.parameters.get(n);
    }

    public void setCurrentDateTime(DateTimeValue dateTimeValue) throws XPathException {
        if (this.currentDateTime == null) {
            if (dateTimeValue.getComponent(7) == null) {
                throw new DynamicError("No timezone is present in supplied value of current date/time");
            }
            this.currentDateTime = dateTimeValue;
            this.dateTimePreset = true;
        }
    }

    public DateTimeValue getCurrentDateTime() {
        if (this.currentDateTime == null) {
            this.currentDateTime = new DateTimeValue(new GregorianCalendar(), true);
        }
        return this.currentDateTime;
    }

    public XPathContextMajor newXPathContext() {
        return new XPathContextMajor(this);
    }

    public void setRememberedNumber(NodeInfo nodeInfo, int n) {
        this.lastRememberedNode = nodeInfo;
        this.lastRememberedNumber = n;
    }

    public int getRememberedNumber(NodeInfo nodeInfo) {
        if (this.lastRememberedNode == nodeInfo) {
            return this.lastRememberedNumber;
        }
        return -1;
    }

    public InstructionInfo getInstructionInfo() {
        InstructionDetails instructionDetails = new InstructionDetails();
        instructionDetails.setConstructType(2000);
        return instructionDetails;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }
}

