/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import net.sf.saxon.Err;
import net.sf.saxon.event.NoOpenStartTagException;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.ExpressionLocation;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;

public final class ComplexContentOutputter
extends SequenceReceiver {
    private NamePool pool;
    private Receiver receiver;
    private int pendingStartTag = -2;
    private int level = -1;
    private Boolean elementIsInNullNamespace;
    private int[] pendingAttCode = new int[20];
    private int[] pendingAttType = new int[20];
    private CharSequence[] pendingAttValue = new String[20];
    private int[] pendingAttLocation = new int[20];
    private int[] pendingAttProp = new int[20];
    private int pendingAttListSize = 0;
    private int[] pendingNSList = new int[20];
    private int pendingNSListSize = 0;
    private int currentSimpleType = -1;
    private int startElementProperties;
    private int startElementLocationId;
    private boolean declaresDefaultNamespace;
    private boolean allowDuplicateAttributes;

    public void setPipelineConfiguration(PipelineConfiguration pipelineConfiguration) {
        super.setPipelineConfiguration(pipelineConfiguration);
        this.allowDuplicateAttributes = pipelineConfiguration.getController().getExecutable().getHostLanguage() == 50;
    }

    public NamePool getNamePool() {
        if (this.pool == null) {
            this.pool = super.getNamePool();
        }
        return this.pool;
    }

    public void setSystemId(String string) {
    }

    public String getSystemId() {
        return null;
    }

    public void setReceiver(Receiver receiver) {
        this.receiver = receiver;
    }

    public void open() throws XPathException {
        this.receiver.open();
        this.previousAtomic = false;
    }

    public void startDocument(int n) throws XPathException {
        ++this.level;
        if (this.level == 0) {
            this.receiver.startDocument(n);
        } else if (this.pendingStartTag >= 0) {
            this.startContent();
            this.pendingStartTag = -2;
        }
        this.previousAtomic = false;
    }

    public void endDocument() throws XPathException {
        if (this.level == 0) {
            this.receiver.endDocument();
        }
        --this.level;
    }

    public void characters(CharSequence charSequence, int n, int n2) throws XPathException {
        this.previousAtomic = false;
        if (charSequence == null) {
            return;
        }
        int n3 = charSequence.length();
        if (n3 == 0) {
            return;
        }
        if (this.pendingStartTag >= 0) {
            this.startContent();
        }
        this.receiver.characters(charSequence, n, n2);
    }

    public void startElement(int n, int n2, int n3, int n4) throws XPathException {
        ++this.level;
        if (this.pendingStartTag >= 0) {
            this.startContent();
        }
        this.startElementProperties = n4;
        this.startElementLocationId = n3;
        this.pendingAttListSize = 0;
        this.pendingNSListSize = 0;
        this.pendingStartTag = n;
        this.elementIsInNullNamespace = null;
        this.currentSimpleType = n2;
        this.previousAtomic = false;
    }

    public void namespace(int n, int n2) throws XPathException {
        if (this.pendingStartTag < 0) {
            throw NoOpenStartTagException.makeNoOpenStartTagException(13, this.getNamePool().getPrefixFromNamespaceCode(n), this.getPipelineConfiguration().getConfiguration().getHostLanguage(), this.level <= 0 || this.pendingStartTag == -2, this.getPipelineConfiguration().isSerializing() && this.level <= 0);
        }
        boolean bl = (n2 & 0x20) != 0;
        for (int i = 0; i < this.pendingNSListSize; ++i) {
            if (n == this.pendingNSList[i]) {
                return;
            }
            if (n >> 16 != this.pendingNSList[i] >> 16) continue;
            if (bl) {
                DynamicError dynamicError = new DynamicError("Cannot create two namespace nodes with the same name");
                dynamicError.setErrorCode("XTDE0430");
                throw dynamicError;
            }
            return;
        }
        if (n >> 16 == 0 && (n & 0xFFFF) != 0) {
            this.declaresDefaultNamespace = true;
            if (this.elementIsInNullNamespace == null) {
                this.elementIsInNullNamespace = this.getNamePool().getURI(this.pendingStartTag) == "";
            }
            if (this.elementIsInNullNamespace.booleanValue()) {
                DynamicError dynamicError = new DynamicError("Cannot output a namespace node for the default namespace when the element is in no namespace");
                dynamicError.setErrorCode("XTDE0440");
                throw dynamicError;
            }
        }
        if (this.pendingNSListSize + 1 > this.pendingNSList.length) {
            int[] nArray = new int[this.pendingNSListSize * 2];
            System.arraycopy(this.pendingNSList, 0, nArray, 0, this.pendingNSListSize);
            this.pendingNSList = nArray;
        }
        this.pendingNSList[this.pendingNSListSize++] = n;
        this.previousAtomic = false;
    }

    public void attribute(int n, int n2, CharSequence charSequence, int n3, int n4) throws XPathException {
        if (this.pendingStartTag < 0) {
            NoOpenStartTagException noOpenStartTagException = NoOpenStartTagException.makeNoOpenStartTagException(2, this.getNamePool().getDisplayName(n), this.getPipelineConfiguration().getConfiguration().getHostLanguage(), this.level <= 0 || this.pendingStartTag == -2, this.getPipelineConfiguration().isSerializing() && this.level <= 0);
            noOpenStartTagException.setLocator(new ExpressionLocation(this.getPipelineConfiguration().getLocationProvider(), n3));
            throw noOpenStartTagException;
        }
        for (int i = 0; i < this.pendingAttListSize; ++i) {
            if ((this.pendingAttCode[i] & 0xFFFFF) != (n & 0xFFFFF)) continue;
            if (this.allowDuplicateAttributes) {
                this.pendingAttType[i] = n2;
                this.pendingAttValue[i] = charSequence;
                this.pendingAttLocation[i] = n3;
                this.pendingAttProp[i] = n4;
                return;
            }
            DynamicError dynamicError = new DynamicError("Cannot create an element having two attributes with the same name: " + Err.wrap(this.getNamePool().getDisplayName(n), 2));
            dynamicError.setErrorCode("XQDY0025");
            throw dynamicError;
        }
        if (this.pendingAttListSize >= this.pendingAttCode.length) {
            int[] nArray = new int[this.pendingAttListSize * 2];
            int[] nArray2 = new int[this.pendingAttListSize * 2];
            String[] stringArray = new String[this.pendingAttListSize * 2];
            int[] nArray3 = new int[this.pendingAttListSize * 2];
            int[] nArray4 = new int[this.pendingAttListSize * 2];
            System.arraycopy(this.pendingAttCode, 0, nArray, 0, this.pendingAttListSize);
            System.arraycopy(this.pendingAttType, 0, nArray2, 0, this.pendingAttListSize);
            System.arraycopy(this.pendingAttValue, 0, stringArray, 0, this.pendingAttListSize);
            System.arraycopy(this.pendingAttLocation, 0, nArray3, 0, this.pendingAttListSize);
            System.arraycopy(this.pendingAttProp, 0, nArray4, 0, this.pendingAttListSize);
            this.pendingAttCode = nArray;
            this.pendingAttType = nArray2;
            this.pendingAttValue = stringArray;
            this.pendingAttLocation = nArray3;
            this.pendingAttProp = nArray4;
        }
        this.pendingAttCode[this.pendingAttListSize] = n;
        this.pendingAttType[this.pendingAttListSize] = n2;
        this.pendingAttValue[this.pendingAttListSize] = charSequence;
        this.pendingAttLocation[this.pendingAttListSize] = n3;
        this.pendingAttProp[this.pendingAttListSize] = n4;
        ++this.pendingAttListSize;
        this.previousAtomic = false;
    }

    private int checkProposedPrefix(int n, int n2) throws XPathException {
        NamePool namePool = this.getNamePool();
        int n3 = namePool.getNamespaceCode(n);
        if (n3 == -1) {
            n3 = namePool.allocateNamespaceCode(n);
        }
        int n4 = n3 >> 16;
        for (int i = 0; i < this.pendingNSListSize; ++i) {
            if (n4 != this.pendingNSList[i] >> 16) continue;
            if ((n3 & 0xFFFF) == (this.pendingNSList[i] & 0xFFFF)) {
                return n;
            }
            String string = this.getSubstitutePrefix(n3, n2);
            int n5 = namePool.allocate(string, namePool.getURI(n), namePool.getLocalName(n));
            this.namespace(namePool.allocateNamespaceCode(n5), 0);
            return n5;
        }
        this.namespace(n3, 0);
        return n;
    }

    private String getSubstitutePrefix(int n, int n2) {
        String string = this.getNamePool().getPrefixFromNamespaceCode(n);
        return string + '_' + n2;
    }

    public void endElement() throws XPathException {
        if (this.pendingStartTag >= 0) {
            this.startContent();
        }
        this.receiver.endElement();
        --this.level;
        this.previousAtomic = false;
    }

    public void comment(CharSequence charSequence, int n, int n2) throws XPathException {
        if (this.pendingStartTag >= 0) {
            this.startContent();
        }
        this.receiver.comment(charSequence, n, n2);
        this.previousAtomic = false;
    }

    public void processingInstruction(String string, CharSequence charSequence, int n, int n2) throws XPathException {
        if (this.pendingStartTag >= 0) {
            this.startContent();
        }
        this.receiver.processingInstruction(string, charSequence, n, n2);
        this.previousAtomic = false;
    }

    public void append(Item item, int n, int n2) throws XPathException {
        if (item == null) {
            return;
        }
        if (item instanceof AtomicValue) {
            if (this.previousAtomic) {
                this.characters(" ", n, 0);
            }
            this.characters(item.getStringValueCS(), n, 0);
            this.previousAtomic = true;
        } else if (((NodeInfo)item).getNodeKind() == 9) {
            Item item2;
            AxisIterator axisIterator = ((NodeInfo)item).iterateAxis((byte)3);
            while ((item2 = axisIterator.next()) != null) {
                this.append(item2, n, n2);
            }
        } else {
            ((NodeInfo)item).copy(this, n2, true, n);
            this.previousAtomic = false;
        }
    }

    public void close() throws XPathException {
        this.receiver.close();
        this.previousAtomic = false;
    }

    public void startContent() throws XPathException {
        int n;
        if (this.pendingStartTag < 0) {
            return;
        }
        int n2 = this.startElementProperties;
        int n3 = this.pendingStartTag;
        if (this.declaresDefaultNamespace || (n3 >> 20 & 0xFF) != 0) {
            n3 = this.checkProposedPrefix(this.pendingStartTag, 0);
            n2 = this.startElementProperties | 0x40;
        }
        this.receiver.startElement(n3, this.currentSimpleType, this.startElementLocationId, n2);
        for (n = 0; n < this.pendingAttListSize; ++n) {
            int n4 = this.pendingAttCode[n];
            if ((n4 >> 20 & 0xFF) == 0) continue;
            this.pendingAttCode[n] = this.checkProposedPrefix(n4, n + 1);
        }
        for (n = 0; n < this.pendingNSListSize; ++n) {
            this.receiver.namespace(this.pendingNSList[n], 0);
        }
        for (n = 0; n < this.pendingAttListSize; ++n) {
            this.receiver.attribute(this.pendingAttCode[n], this.pendingAttType[n], this.pendingAttValue[n], this.pendingAttLocation[n], this.pendingAttProp[n]);
        }
        this.receiver.startContent();
        this.pendingAttListSize = 0;
        this.pendingNSListSize = 0;
        this.pendingStartTag = -1;
        this.previousAtomic = false;
    }
}

