/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.io.IOException;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.AugmentedSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.StandardErrorHandler;
import net.sf.saxon.event.DocumentSender;
import net.sf.saxon.event.NamePoolConverter;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.ReceivingContentHandler;
import net.sf.saxon.om.ExternalObjectModel;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pull.PullProvider;
import net.sf.saxon.pull.PullPushCopier;
import net.sf.saxon.pull.PullSource;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class Sender {
    PipelineConfiguration pipe;

    public Sender(PipelineConfiguration pipelineConfiguration) {
        this.pipe = pipelineConfiguration;
    }

    public void send(Source source, Receiver receiver) throws XPathException {
        this.send(source, receiver, false);
    }

    public void send(Source source, Receiver receiver, boolean bl) throws XPathException {
        Source source2;
        Object object;
        int n;
        Object object2;
        Configuration configuration = this.pipe.getConfiguration();
        receiver.setPipelineConfiguration(this.pipe);
        receiver.setSystemId(source.getSystemId());
        int n2 = 13;
        int n3 = configuration.getSchemaValidationMode();
        if (bl) {
            n3 |= 0x10000;
        }
        XMLReader xMLReader = null;
        if (source instanceof AugmentedSource) {
            n2 = ((AugmentedSource)source).getStripSpace();
            int n4 = ((AugmentedSource)source).getSchemaValidation();
            if (n4 != 0) {
                n3 = n4;
            }
            xMLReader = ((AugmentedSource)source).getXMLReader();
            object2 = ((AugmentedSource)source).getFilters();
            if (object2 != null) {
                for (n = object2.size() - 1; n >= 0; --n) {
                    object = (ProxyReceiver)object2.get(n);
                    ((ProxyReceiver)object).setPipelineConfiguration(this.pipe);
                    ((ProxyReceiver)object).setSystemId(source.getSystemId());
                    ((ProxyReceiver)object).setUnderlyingReceiver(receiver);
                    receiver = object;
                }
            }
            source = ((AugmentedSource)source).getContainedSource();
        }
        if (source instanceof NodeInfo) {
            int n5;
            NodeInfo nodeInfo = (NodeInfo)source;
            object2 = nodeInfo.getBaseURI();
            n = n3 & 0xFF;
            if (n != 3) {
                receiver = configuration.getDocumentValidator(receiver, (String)object2, configuration.getNamePool(), n, 10, null);
            }
            if ((n5 = nodeInfo.getNodeKind()) != 9 && n5 != 1) {
                throw new IllegalArgumentException("Sender can only handle document or element nodes");
            }
            receiver.setSystemId((String)object2);
            this.sendDocumentInfo(nodeInfo, receiver);
            return;
        }
        if (source instanceof PullSource) {
            this.sendPullSource((PullSource)source, receiver, n3);
            return;
        }
        if (source instanceof SAXSource) {
            this.sendSAXSource((SAXSource)source, receiver, n3, n2);
            return;
        }
        if (source instanceof StreamSource) {
            StreamSource streamSource = (StreamSource)source;
            object2 = source.getSystemId();
            InputSource inputSource = new InputSource((String)object2);
            inputSource.setCharacterStream(streamSource.getReader());
            inputSource.setByteStream(streamSource.getInputStream());
            boolean bl2 = false;
            if (xMLReader == null) {
                xMLReader = configuration.getSourceParser();
                bl2 = true;
            }
            SAXSource sAXSource = new SAXSource(xMLReader, inputSource);
            sAXSource.setSystemId(source.getSystemId());
            this.sendSAXSource(sAXSource, receiver, n3, n2);
            if (bl2) {
                configuration.reuseSourceParser(xMLReader);
            }
            return;
        }
        if ((n3 & 0xFF) != 3) {
            receiver = configuration.getDocumentValidator(receiver, source.getSystemId(), configuration.getNamePool(), n3, n2, null);
        }
        if ((source2 = configuration.getSourceResolver().resolveSource(source, configuration)) instanceof StreamSource || source2 instanceof SAXSource || source2 instanceof NodeInfo || source2 instanceof PullSource) {
            this.send(source2, receiver, bl);
        }
        object2 = configuration.getExternalObjectModels();
        for (n = 0; n < object2.size(); ++n) {
            object = (ExternalObjectModel)object2.get(n);
            boolean bl3 = object.sendSource(source, receiver, this.pipe);
            if (!bl3) continue;
            return;
        }
        if (source instanceof DOMSource) {
            throw new DynamicError("DOMSource cannot be processed: check that saxon8-dom.jar is on the classpath");
        }
        throw new DynamicError("A source of type " + source.getClass().getName() + " is not supported in this environment");
    }

    private void sendDocumentInfo(NodeInfo nodeInfo, Receiver object) throws XPathException {
        Object object2;
        NamePool namePool = this.pipe.getConfiguration().getNamePool();
        if (nodeInfo.getNamePool() != namePool) {
            object2 = new NamePoolConverter(nodeInfo.getNamePool(), namePool);
            ((NamePoolConverter)object2).setUnderlyingReceiver((Receiver)object);
            ((ProxyReceiver)object2).setPipelineConfiguration(object.getPipelineConfiguration());
            object = object2;
        }
        object2 = new DocumentSender(nodeInfo);
        ((DocumentSender)object2).send((Receiver)object);
    }

    private void sendSAXSource(SAXSource sAXSource, Receiver receiver, int n, int n2) throws XPathException {
        Object object;
        boolean bl;
        XMLReader xMLReader = sAXSource.getXMLReader();
        boolean bl2 = false;
        Configuration configuration = this.pipe.getConfiguration();
        boolean bl3 = bl = configuration.getXMLVersion() == 10;
        if (xMLReader == null) {
            object = new SAXSource();
            ((SAXSource)object).setInputSource(sAXSource.getInputSource());
            ((SAXSource)object).setSystemId(sAXSource.getSystemId());
            xMLReader = configuration.getSourceParser();
            ((SAXSource)object).setXMLReader(xMLReader);
            sAXSource = object;
            bl2 = true;
            if (!configuration.mustCheckForXML11Input()) {
                bl = false;
            }
        } else if (configuration.mustCheckForXML11Input()) {
            try {
                boolean bl4 = xMLReader.getFeature("http://xml.org/sax/features/xml-1.1");
                if (bl4) {
                    bl = true;
                }
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                // empty catch block
            }
        }
        xMLReader.setErrorHandler(new StandardErrorHandler(this.pipe.getErrorListener()));
        try {
            xMLReader.setFeature("http://xml.org/sax/features/namespaces", true);
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            throw new DynamicError("The SAX2 parser does not recognize the 'namespaces' feature");
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            throw new DynamicError("The SAX2 parser does not support setting the 'namespaces' feature to true");
        }
        try {
            xMLReader.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            throw new DynamicError("The SAX2 parser does not recognize the 'namespace-prefixes' feature");
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            throw new DynamicError("The SAX2 parser does not support setting the 'namespace-prefixes' feature to false");
        }
        if ((n & 0xFF) != 3) {
            receiver = configuration.getDocumentValidator(receiver, sAXSource.getSystemId(), configuration.getNamePool(), n, n2, null);
        }
        object = new ReceivingContentHandler();
        ((ReceivingContentHandler)object).setReceiver(receiver);
        ((ReceivingContentHandler)object).setPipelineConfiguration(this.pipe);
        if (n2 == 11) {
            ((ReceivingContentHandler)object).setIgnoreIgnorableWhitespace(true);
        } else if (n2 == 10) {
            ((ReceivingContentHandler)object).setIgnoreIgnorableWhitespace(false);
        }
        xMLReader.setContentHandler((ContentHandler)object);
        xMLReader.setDTDHandler((DTDHandler)object);
        try {
            xMLReader.setProperty("http://xml.org/sax/properties/lexical-handler", object);
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            // empty catch block
        }
        try {
            xMLReader.parse(sAXSource.getInputSource());
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException.getException();
            if (exception instanceof XPathException) {
                throw (XPathException)exception;
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            DynamicError dynamicError = new DynamicError(sAXException);
            dynamicError.setHasBeenReported();
            throw dynamicError;
        }
        catch (IOException iOException) {
            throw new DynamicError(iOException);
        }
        if (bl2) {
            configuration.reuseSourceParser(xMLReader);
        }
    }

    private void sendPullSource(PullSource pullSource, Receiver receiver, int n) throws XPathException {
        if (n != 3 && n != 4) {
            throw new DynamicError("Validation is not currently supported with a PullSource");
        }
        receiver.open();
        PullProvider pullProvider = pullSource.getPullProvider();
        pullProvider.setPipelineConfiguration(this.pipe);
        receiver.setPipelineConfiguration(this.pipe);
        PullPushCopier pullPushCopier = new PullPushCopier(pullProvider, receiver);
        pullPushCopier.copy();
        receiver.close();
    }
}

