/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.Properties;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.trans.XPathException;

public class XMLIndenter
extends ProxyReceiver {
    private int level = 0;
    private int indentSpaces = 3;
    private String indentChars = "\n                                                          ";
    private boolean sameline = false;
    private boolean afterStartTag = false;
    private boolean afterEndTag = true;
    private boolean allWhite = true;
    private int line = 0;
    private int column = 0;
    private int suppressedAtLevel = -1;
    private int xmlspace;

    public void setOutputProperties(Properties properties) {
        String string = properties.getProperty("{http://saxon.sf.net/}indent-spaces");
        if (string == null) {
            this.indentSpaces = 3;
        } else {
            try {
                this.indentSpaces = Integer.parseInt(string.trim());
            }
            catch (NumberFormatException numberFormatException) {
                this.indentSpaces = 3;
            }
        }
        String string2 = properties.getProperty("omit-xml-declaration");
        this.afterEndTag = string2 == null || !string2.trim().equals("yes") || properties.getProperty("doctype-system") != null;
    }

    public void open() throws XPathException {
        super.open();
        this.xmlspace = 386;
    }

    public void startElement(int n, int n2, int n3, int n4) throws XPathException {
        if (this.afterStartTag || this.afterEndTag) {
            this.indent();
        }
        super.startElement(n, n2, n3, n4);
        ++this.level;
        this.sameline = true;
        this.afterStartTag = true;
        this.afterEndTag = false;
        this.allWhite = true;
        this.line = 0;
    }

    public void attribute(int n, int n2, CharSequence charSequence, int n3, int n4) throws XPathException {
        if ((n & 0xFFFFF) == this.xmlspace && charSequence.equals("preserve") && this.suppressedAtLevel < 0) {
            this.suppressedAtLevel = this.level;
        }
        super.attribute(n, n2, charSequence, n3, n4);
    }

    public void endElement() throws XPathException {
        --this.level;
        if (this.afterEndTag && !this.sameline) {
            this.indent();
        }
        super.endElement();
        this.sameline = false;
        this.afterEndTag = true;
        this.afterStartTag = false;
        this.allWhite = true;
        this.line = 0;
        if (this.level == this.suppressedAtLevel - 1) {
            this.suppressedAtLevel = -1;
        }
    }

    public void processingInstruction(String string, CharSequence charSequence, int n, int n2) throws XPathException {
        if (this.afterEndTag) {
            this.indent();
        }
        super.processingInstruction(string, charSequence, n, n2);
        this.afterStartTag = false;
        this.afterEndTag = false;
    }

    public void characters(CharSequence charSequence, int n, int n2) throws XPathException {
        for (int i = 0; i < charSequence.length(); ++i) {
            char c = charSequence.charAt(i);
            if (c == '\n') {
                this.sameline = false;
                ++this.line;
                this.column = 0;
            }
            if (!Character.isWhitespace(c)) {
                this.allWhite = false;
            }
            ++this.column;
        }
        super.characters(charSequence, n, n2);
        if (!this.allWhite) {
            this.afterStartTag = false;
            this.afterEndTag = false;
        }
    }

    public void comment(CharSequence charSequence, int n, int n2) throws XPathException {
        if (this.afterEndTag) {
            this.indent();
        }
        super.comment(charSequence, n, n2);
        this.afterStartTag = false;
        this.afterEndTag = false;
    }

    private void indent() throws XPathException {
        if (this.suppressedAtLevel >= 0) {
            return;
        }
        int n = this.level * this.indentSpaces;
        if (this.line > 0 && (n -= this.column) <= 0) {
            return;
        }
        while (n >= this.indentChars.length()) {
            this.indentChars = this.indentChars + "                      ";
        }
        int n2 = this.line == 0 ? 0 : 1;
        super.characters(this.indentChars.subSequence(n2, n2 + n + 1), 0, 4);
        this.sameline = false;
    }
}

