/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.io.PrintStream;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.ParentNodeExpression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Axis;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.CombinedNodeTest;
import net.sf.saxon.pattern.ContentTypeTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.EmptySequence;

public final class AxisExpression
extends ComputedExpression {
    private byte axis;
    private NodeTest test;
    private ItemType itemType = null;
    int computedCardinality = -1;

    public AxisExpression(byte by, NodeTest nodeTest) {
        this.axis = by;
        this.test = nodeTest;
    }

    public Expression simplify(StaticContext staticContext) {
        ComputedExpression computedExpression = this;
        if (this.axis == 9 && (this.test == null || this.test instanceof AnyNodeTest)) {
            computedExpression = new ParentNodeExpression();
            ExpressionTool.copyLocationInfo(this, computedExpression);
        }
        return computedExpression;
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        block26: {
            if (itemType == null) {
                StaticError staticError = new StaticError("Axis step " + this.toString() + " cannot be used here: the context item is undefined");
                staticError.setIsTypeError(true);
                staticError.setErrorCode("XPDY0002");
                staticError.setLocator(this);
                throw staticError;
            }
            if (itemType instanceof AtomicType) {
                StaticError staticError = new StaticError("Axis step " + this.toString() + " cannot be used here: the context item is an atomic value");
                staticError.setIsTypeError(true);
                staticError.setErrorCode("XPTY0020");
                staticError.setLocator(this);
                throw staticError;
            }
            if (itemType instanceof NodeTest) {
                int n = itemType.getPrimitiveType();
                if (n != 0 && Axis.isAlwaysEmpty(this.axis, n)) {
                    staticContext.issueWarning("The " + Axis.axisName[this.axis] + " axis starting at " + (n == 1 || n == 2 ? "an " : "a ") + NodeKindTest.toString(n) + " node will never select anything", this);
                    return EmptySequence.getInstance();
                }
                if (this.test != null) {
                    SchemaType schemaType;
                    int n2 = this.test.getPrimitiveType();
                    if (n2 != 0 && !Axis.containsNodeKind(this.axis, n2)) {
                        staticContext.issueWarning("The " + Axis.axisName[this.axis] + " axis will never select any " + NodeKindTest.toString(n2) + " nodes", this);
                        return EmptySequence.getInstance();
                    }
                    if (this.axis == 12 && n2 != 0 && n != 0 && n2 != n) {
                        staticContext.issueWarning("The self axis will never select any " + NodeKindTest.toString(n) + " nodes when starting at " + (n == 1 || n == 2 ? "an " : "a ") + NodeKindTest.toString(n2) + " node", this);
                        return EmptySequence.getInstance();
                    }
                    if (this.axis == 12) {
                        this.itemType = itemType;
                    }
                    if ((schemaType = ((NodeTest)itemType).getContentType()) == AnyType.getInstance()) {
                        return this;
                    }
                    int n3 = this.test.getFingerprint();
                    if (schemaType.isSimpleType()) {
                        if (!(this.axis != 3 && this.axis != 2 && this.axis != 4 && this.axis != 5 || n2 != 1 && n2 != 2 && n2 != 9)) {
                            staticContext.issueWarning("The " + Axis.axisName[this.axis] + " axis will never select any " + NodeKindTest.toString(n2) + " nodes when starting at a node with simple type " + schemaType.getDescription(), this);
                        }
                    } else if (!(!((ComplexType)schemaType).isSimpleContent() || this.axis != 3 && this.axis != 4 && this.axis != 5 || n2 != 1 && n2 != 9)) {
                        staticContext.issueWarning("The " + Axis.axisName[this.axis] + " axis will never select any " + NodeKindTest.toString(n2) + " nodes when starting at a node with type " + schemaType.getDescription() + ", as this type requires simple content", this);
                    } else if (((ComplexType)schemaType).isEmptyContent() && (this.axis == 3 || this.axis == 4 || this.axis == 5)) {
                        staticContext.issueWarning("The " + Axis.axisName[this.axis] + " axis will never select any " + " nodes when starting at a node with type " + schemaType.getDescription() + ", as this type requires empty content", this);
                    } else if (this.axis == 2 && n3 != -1) {
                        try {
                            SchemaType schemaType2 = ((ComplexType)schemaType).getAttributeUseType(n3);
                            if (schemaType2 == null) {
                                String string = staticContext.getNamePool().getDisplayName(n3);
                                staticContext.issueWarning("The complex type " + schemaType.getDescription() + " does not allow an attribute named " + string, this);
                                break block26;
                            }
                            this.itemType = new CombinedNodeTest(this.test, 23, new ContentTypeTest(2, schemaType2, staticContext.getConfiguration()));
                        }
                        catch (SchemaException schemaException) {}
                    } else if (this.axis == 3 && n2 == 1 && n3 != -1) {
                        try {
                            SchemaType schemaType3 = ((ComplexType)schemaType).getElementParticleType(n3);
                            if (schemaType3 == null) {
                                String string = staticContext.getNamePool().getDisplayName(n3);
                                staticContext.issueWarning("The complex type " + schemaType.getDescription() + " does not allow a child element named " + string, this);
                            } else {
                                this.itemType = new CombinedNodeTest(this.test, 23, new ContentTypeTest(1, schemaType3, staticContext.getConfiguration()));
                                this.computedCardinality = ((ComplexType)schemaType).getElementParticleCardinality(n3);
                                this.resetStaticProperties();
                            }
                        }
                        catch (SchemaException schemaException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        return this;
    }

    public Expression optimize(Optimizer optimizer, StaticContext staticContext, ItemType itemType) {
        return this;
    }

    public boolean equals(Object object) {
        if (!(object instanceof AxisExpression)) {
            return false;
        }
        if (this.axis != ((AxisExpression)object).axis) {
            return false;
        }
        if (this.test == null) {
            return ((AxisExpression)object).test == null;
        }
        return this.test.toString().equals(((AxisExpression)object).test.toString());
    }

    public int hashCode() {
        int n = 9375162 + this.axis << 20;
        if (this.test != null) {
            n ^= this.test.getPrimitiveType() << 16;
            n ^= this.test.getFingerprint();
        }
        return n;
    }

    public int getIntrinsicDependencies() {
        return 2;
    }

    public int computeSpecialProperties() {
        return 0xC10000 | (Axis.isForwards[this.axis] ? 131072 : 262144) | (Axis.isPeerAxis[this.axis] ? 524288 : 0) | (Axis.isSubtreeAxis[this.axis] ? 0x100000 : 0) | (this.axis == 2 || this.axis == 8 ? 0x200000 : 0);
    }

    public final ItemType getItemType(TypeHierarchy typeHierarchy) {
        if (this.itemType != null) {
            return this.itemType;
        }
        short s = Axis.principalNodeType[this.axis];
        switch (s) {
            case 2: 
            case 13: {
                return NodeKindTest.makeNodeKindTest(s);
            }
        }
        if (this.test == null) {
            return AnyNodeTest.getInstance();
        }
        return this.test;
    }

    public final int computeCardinality() {
        if (this.computedCardinality != -1) {
            return this.computedCardinality;
        }
        if (this.axis == 2 && this.test instanceof NameTest) {
            return 24576;
        }
        if (this.axis == 12) {
            return 24576;
        }
        return 57344;
    }

    public byte getAxis() {
        return this.axis;
    }

    public NodeTest getNodeTest() {
        return this.test;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        Item item = xPathContext.getContextItem();
        try {
            if (this.test == null) {
                return ((NodeInfo)item).iterateAxis(this.axis);
            }
            return ((NodeInfo)item).iterateAxis(this.axis, this.test);
        }
        catch (NullPointerException nullPointerException) {
            DynamicError dynamicError = new DynamicError("The context item for axis step " + this.toString() + " is undefined");
            dynamicError.setErrorCode("XPDY0002");
            dynamicError.setXPathContext(xPathContext);
            dynamicError.setLocator(this);
            dynamicError.setIsTypeError(true);
            throw dynamicError;
        }
        catch (ClassCastException classCastException) {
            DynamicError dynamicError = new DynamicError("The context item for axis step " + this.toString() + " is not a node");
            dynamicError.setErrorCode("XPTY0020");
            dynamicError.setXPathContext(xPathContext);
            dynamicError.setLocator(this);
            dynamicError.setIsTypeError(true);
            throw dynamicError;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            this.dynamicError(unsupportedOperationException.getMessage(), xPathContext);
            return null;
        }
    }

    public void display(int n, NamePool namePool, PrintStream printStream) {
        printStream.println(ExpressionTool.indent(n) + this.toString());
    }

    public String toString() {
        return Axis.axisName[this.axis] + "::" + (this.test == null ? "node()" : this.test.toString());
    }
}

