/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.event.LocationProvider;
import net.sf.saxon.expr.Assignation;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.InstructionDetails;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.sort.IntHashSet;
import net.sf.saxon.sort.IntIterator;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trace.InstructionInfoProvider;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.StringValue;

public abstract class ComputedExpression
implements Serializable,
Expression,
InstructionInfoProvider,
Container {
    protected int staticProperties = -1;
    protected int locationId = -1;
    private Container parentExpression;
    private int[] slotsUsed;

    public Container getParentExpression() {
        return this.parentExpression;
    }

    public void setParentExpression(Container container) {
        if (this == container) {
            throw new AssertionError((Object)"Incestuous relationship!");
        }
        this.parentExpression = container;
    }

    public void adoptChildExpression(Expression expression) {
        if (expression instanceof ComputedExpression) {
            ComputedExpression computedExpression = (ComputedExpression)expression;
            if (computedExpression.getParentExpression() == this) {
                return;
            }
            computedExpression.setParentExpression(this);
            if (this.locationId == -1) {
                ExpressionTool.copyLocationInfo(expression, this);
            } else if (((ComputedExpression)expression).locationId == -1) {
                ExpressionTool.copyLocationInfo(this, expression);
            }
        }
        if (this.staticProperties != -1) {
            this.resetStaticProperties();
        }
    }

    public int getImplementationMethod() {
        if (Cardinality.allowsMany(this.getCardinality())) {
            return 2;
        }
        return 1;
    }

    public void setLocationId(int n) {
        this.locationId = n;
    }

    public final int getLocationId() {
        return this.locationId;
    }

    public int getLineNumber() {
        if (this.locationId == -1) {
            if (this.parentExpression != null) {
                return this.parentExpression.getLineNumber();
            }
            return -1;
        }
        return this.locationId & 0xFFFFF;
    }

    public int getColumnNumber() {
        return -1;
    }

    public String getSystemId() {
        if (this.locationId == -1) {
            if (this.parentExpression != null) {
                return this.parentExpression.getSystemId();
            }
            return null;
        }
        Executable executable = this.getExecutable();
        if (executable == null) {
            if (this.parentExpression == null) {
                return null;
            }
            if (this.parentExpression instanceof LocationProvider) {
                return ((LocationProvider)((Object)this.parentExpression)).getSystemId(this.locationId);
            }
            return this.parentExpression.getSystemId();
        }
        return executable.getLocationMap().getSystemId(this.locationId);
    }

    public final String getPublicId() {
        return null;
    }

    public Executable getExecutable() {
        Container container = this.getParentExpression();
        if (container == null) {
            return null;
        }
        if (container == this) {
            throw new IllegalStateException("Expression cannot contain itself");
        }
        return container.getExecutable();
    }

    public LocationProvider getLocationProvider() {
        Executable executable = this.getExecutable();
        if (executable != null) {
            return executable.getLocationMap();
        }
        if (this.getParentExpression() instanceof LocationProvider) {
            return (LocationProvider)((Object)this.getParentExpression());
        }
        return null;
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        return this;
    }

    public Expression promote(PromotionOffer promotionOffer) throws XPathException {
        return this;
    }

    public final Expression doPromotion(Expression expression, PromotionOffer promotionOffer) throws XPathException {
        Expression expression2 = expression.promote(promotionOffer);
        if (expression2 != expression) {
            this.adoptChildExpression(expression2);
            this.resetStaticProperties();
        }
        return expression2;
    }

    public final int getSpecialProperties() {
        if (this.staticProperties == -1) {
            this.computeStaticProperties();
        }
        return this.staticProperties & 0xFF0000;
    }

    public final void computeStaticProperties() {
        this.staticProperties = this.computeDependencies() | this.computeCardinality() | this.computeSpecialProperties();
    }

    public final void resetStaticProperties() {
        this.staticProperties = -1;
        if (this.parentExpression instanceof ComputedExpression) {
            ((ComputedExpression)this.parentExpression).resetStaticProperties();
        }
    }

    protected abstract int computeCardinality();

    public int computeSpecialProperties() {
        return 0;
    }

    public int getCardinality() {
        if (this.staticProperties == -1) {
            this.computeStaticProperties();
        }
        return this.staticProperties & 0xE000;
    }

    public int getDependencies() {
        if (this.staticProperties == -1) {
            this.computeStaticProperties();
        }
        return this.staticProperties & 0x1FF;
    }

    public int computeDependencies() {
        int n = this.getIntrinsicDependencies();
        Iterator iterator = this.iterateSubExpressions();
        while (iterator.hasNext()) {
            n |= (short)((Expression)iterator.next()).getDependencies();
        }
        return n;
    }

    public int getIntrinsicDependencies() {
        return 0;
    }

    public Iterator iterateSubExpressions() {
        return Collections.EMPTY_LIST.iterator();
    }

    public void suppressValidation(int n) {
    }

    public void checkPermittedContents(SchemaType schemaType, StaticContext staticContext, boolean bl) throws XPathException {
    }

    public boolean markTailFunctionCalls() {
        return false;
    }

    public int[] getSlotsUsed() {
        if (this.slotsUsed != null) {
            return this.slotsUsed;
        }
        IntHashSet intHashSet = new IntHashSet(10);
        ComputedExpression.gatherSlotsUsed(this, intHashSet);
        this.slotsUsed = new int[intHashSet.size()];
        int n = 0;
        IntIterator intIterator = intHashSet.iterator();
        while (intIterator.hasNext()) {
            this.slotsUsed[n++] = intIterator.next();
        }
        Arrays.sort(this.slotsUsed);
        return this.slotsUsed;
    }

    private static void gatherSlotsUsed(Expression expression, IntHashSet intHashSet) {
        if (expression instanceof VariableReference) {
            int n;
            Binding binding = ((VariableReference)expression).getBinding();
            if (!binding.isGlobal() && (n = binding.getLocalSlotNumber()) != -1 && !intHashSet.contains(n)) {
                intHashSet.add(n);
            }
        } else {
            Iterator iterator = expression.iterateSubExpressions();
            while (iterator.hasNext()) {
                Expression expression2 = (Expression)iterator.next();
                ComputedExpression.gatherSlotsUsed(expression2, intHashSet);
            }
        }
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        return this.iterate(xPathContext).next();
    }

    public String evaluateAsString(XPathContext xPathContext) throws XPathException {
        StringValue stringValue;
        Item item = this.evaluateItem(xPathContext);
        if (item instanceof AtomicValue && !((AtomicValue)item).hasBuiltInType()) {
            item = ((AtomicValue)item).getPrimitiveValue();
        }
        if ((stringValue = (StringValue)item) == null) {
            return "";
        }
        return stringValue.getStringValue();
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        Item item = this.evaluateItem(xPathContext);
        return SingletonIterator.makeIterator(item);
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) throws XPathException {
        return ExpressionTool.effectiveBooleanValue(this.iterate(xPathContext));
    }

    public void process(XPathContext xPathContext) throws XPathException {
        int n = this.getImplementationMethod();
        if ((n & 1) != 0) {
            Item item = this.evaluateItem(xPathContext);
            Instruction.appendItem(item, xPathContext.getReceiver(), this.locationId);
        } else if ((n & 2) != 0) {
            SequenceIterator sequenceIterator = this.iterate(xPathContext);
            try {
                Item item;
                while ((item = sequenceIterator.next()) != null) {
                    Instruction.appendItem(item, xPathContext.getReceiver(), this.locationId);
                }
            }
            catch (XPathException xPathException) {
                if (xPathException.getLocator() == null) {
                    xPathException.setLocator(this);
                }
                throw xPathException;
            }
        } else {
            this.dynamicError("process() is not implemented in the subclass " + this.getClass(), xPathContext);
        }
    }

    protected void dynamicError(String string, XPathContext xPathContext) throws DynamicError {
        DynamicError dynamicError = new DynamicError(string, this.getSourceLocator());
        dynamicError.setXPathContext(xPathContext);
        throw dynamicError;
    }

    protected void dynamicError(String string, String string2, XPathContext xPathContext) throws DynamicError {
        DynamicError dynamicError = new DynamicError(string, this.getSourceLocator());
        dynamicError.setXPathContext(xPathContext);
        dynamicError.setErrorCode(string2);
        throw dynamicError;
    }

    protected void typeError(String string, XPathContext xPathContext) throws DynamicError {
        DynamicError dynamicError = new DynamicError(string, this.getSourceLocator());
        dynamicError.setIsTypeError(true);
        dynamicError.setXPathContext(xPathContext);
        throw dynamicError;
    }

    protected void typeError(String string, String string2, XPathContext xPathContext) throws DynamicError {
        DynamicError dynamicError = new DynamicError(string, this.getSourceLocator());
        dynamicError.setIsTypeError(true);
        dynamicError.setErrorCode(string2);
        dynamicError.setXPathContext(xPathContext);
        throw dynamicError;
    }

    private SourceLocator getSourceLocator() {
        return ExpressionTool.getLocator(this);
    }

    public InstructionInfo getInstructionInfo() {
        InstructionDetails instructionDetails = new InstructionDetails();
        instructionDetails.setConstructType(this.getConstructType());
        instructionDetails.setProperty("expression", this);
        instructionDetails.setSystemId(this.getSystemId());
        instructionDetails.setLineNumber(this.getLineNumber());
        instructionDetails.setColumnNumber(this.getColumnNumber());
        if (this instanceof Assignation) {
            instructionDetails.setObjectNameCode(((Assignation)this).getVariableNameCode());
        }
        return instructionDetails;
    }

    protected int getConstructType() {
        return 2098;
    }

    public boolean hasBadParentPointer() {
        Iterator iterator = this.iterateSubExpressions();
        while (iterator.hasNext()) {
            Expression expression = (Expression)iterator.next();
            if (!(expression instanceof ComputedExpression)) continue;
            if (this != expression.getParentExpression()) {
                System.err.println("Bad parent pointer to " + expression.getParentExpression() + " found in " + expression);
                return true;
            }
            if (!((ComputedExpression)expression).hasBadParentPointer()) continue;
            System.err.println("Found in " + expression);
            return true;
        }
        return false;
    }
}

