/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.CollectionURIResolver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;

public class Collection
extends SystemFunction {
    private String expressionBaseURI = null;

    public void checkArguments(StaticContext staticContext) throws XPathException {
        if (this.expressionBaseURI == null) {
            super.checkArguments(staticContext);
            this.expressionBaseURI = staticContext.getBaseURI();
        }
    }

    public Expression preEvaluate(StaticContext staticContext) {
        return this;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        String string = this.getNumberOfArguments() == 0 ? null : this.argument[0].evaluateItem(xPathContext).getStringValue();
        CollectionURIResolver collectionURIResolver = xPathContext.getConfiguration().getCollectionURIResolver();
        SequenceIterator sequenceIterator = collectionURIResolver.resolve(string, this.expressionBaseURI, xPathContext);
        if (sequenceIterator == null) {
            return EmptyIterator.getInstance();
        }
        return sequenceIterator;
    }
}

