/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.CollatingFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.sort.AtomicComparer;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.IntegerValue;

public class IndexOf
extends CollatingFunction {
    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        AtomicComparer atomicComparer = this.getAtomicComparer(2, xPathContext);
        SequenceIterator sequenceIterator = this.argument[0].iterate(xPathContext);
        AtomicValue atomicValue = (AtomicValue)this.argument[1].evaluateItem(xPathContext);
        TypeHierarchy typeHierarchy = xPathContext.getConfiguration().getNamePool().getTypeHierarchy();
        return new IndexIterator(sequenceIterator, atomicValue, typeHierarchy, atomicComparer);
    }

    private class IndexIterator
    implements SequenceIterator {
        SequenceIterator base;
        AtomicValue value;
        AtomicComparer comparer;
        int index = 0;
        int position = 0;
        Item current = null;
        int primitiveTypeRequired;
        TypeHierarchy typeHierarchy;

        public IndexIterator(SequenceIterator sequenceIterator, AtomicValue atomicValue, TypeHierarchy typeHierarchy, AtomicComparer atomicComparer) {
            this.base = sequenceIterator;
            this.value = atomicValue;
            this.comparer = atomicComparer;
            this.typeHierarchy = typeHierarchy;
            this.primitiveTypeRequired = atomicValue.getPrimitiveValue().getItemType(typeHierarchy).getPrimitiveType();
        }

        public Item next() throws XPathException {
            AtomicValue atomicValue;
            while ((atomicValue = (AtomicValue)this.base.next()) != null) {
                ++this.index;
                if (!Type.isComparable(this.primitiveTypeRequired, atomicValue.getPrimitiveValue().getItemType(this.typeHierarchy).getPrimitiveType())) continue;
                try {
                    if (!this.comparer.comparesEqual(atomicValue, this.value)) continue;
                    this.current = new IntegerValue(this.index);
                    ++this.position;
                    return this.current;
                }
                catch (ClassCastException classCastException) {
                }
            }
            this.current = null;
            this.position = -1;
            return null;
        }

        public Item current() {
            return this.current;
        }

        public int position() {
            return this.position;
        }

        public SequenceIterator getAnother() throws XPathException {
            return new IndexIterator(this.base.getAnother(), this.value, this.typeHierarchy, this.comparer);
        }

        public int getProperties() {
            return 0;
        }
    }
}

