/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.StringTokenizer;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;

public class NormalizeSpace
extends SystemFunction {
    public Expression simplify(StaticContext staticContext) throws XPathException {
        return this.simplifyArguments(staticContext);
    }

    public int getIntrinsicDependencies() {
        int n = super.getIntrinsicDependencies();
        if (this.argument.length == 0) {
            n |= 2;
        }
        return n;
    }

    public Expression preEvaluate(StaticContext staticContext) throws XPathException {
        if (this.argument.length == 0) {
            return this;
        }
        return ExpressionTool.eagerEvaluate(this, staticContext.makeEarlyEvaluationContext());
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        if (this.argument.length == 0) {
            return StringValue.makeStringValue(NormalizeSpace.normalize(xPathContext.getContextItem().getStringValueCS()));
        }
        AtomicValue atomicValue = (AtomicValue)this.argument[0].evaluateItem(xPathContext);
        if (atomicValue == null) {
            return StringValue.EMPTY_STRING;
        }
        return StringValue.makeStringValue(NormalizeSpace.normalize(atomicValue.getStringValueCS()));
    }

    public static CharSequence normalize(CharSequence charSequence) {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(charSequence.length());
        StringTokenizer stringTokenizer = new StringTokenizer(((Object)charSequence).toString());
        while (stringTokenizer.hasMoreTokens()) {
            fastStringBuffer.append(stringTokenizer.nextToken());
            if (!stringTokenizer.hasMoreTokens()) continue;
            fastStringBuffer.append(' ');
        }
        return fastStringBuffer.condense();
    }
}

