/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.util.ArrayList;
import java.util.Stack;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.ErrorExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.instruct.Bindery;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.GeneralVariable;
import net.sf.saxon.instruct.InstructionDetails;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.instruct.UserFunction;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;

public class GlobalVariable
extends GeneralVariable
implements Container {
    private Executable executable;
    private SlotManager stackFrameMap = null;

    public Executable getExecutable() {
        return this.executable;
    }

    public void setExecutable(Executable executable) {
        this.executable = executable;
    }

    public void setContainsLocals(SlotManager slotManager) {
        this.stackFrameMap = slotManager;
    }

    public boolean isGlobal() {
        return true;
    }

    public void lookForCycles(Stack stack) throws StaticError {
        if (stack.contains(this)) {
            int n = stack.indexOf(this);
            stack.push(this);
            String string = "Circular definition of global variable. ";
            NamePool namePool = this.executable.getConfiguration().getNamePool();
            for (int i = n; i < stack.size() - 1; ++i) {
                Container container;
                if (stack.get(i + 1) instanceof GlobalVariable) {
                    container = (GlobalVariable)stack.get(i + 1);
                    if (i == n) {
                        string = string + '$' + this.getVariableName() + " uses $" + ((GeneralVariable)container).getVariableName();
                        continue;
                    }
                    string = string + ", which uses $" + ((GeneralVariable)container).getVariableName();
                    continue;
                }
                if (!(stack.get(i + 1) instanceof UserFunction)) continue;
                container = (UserFunction)stack.get(i + 1);
                string = string + ", which calls " + namePool.getDisplayName(((UserFunction)container).getFunctionNameCode()) + "()";
            }
            string = string + '.';
            StaticError staticError = new StaticError(string);
            staticError.setErrorCode("XQST0054");
            staticError.setLocator(this);
            throw staticError;
        }
        if (this.select != null) {
            Object object;
            int n;
            stack.push(this);
            ArrayList arrayList = new ArrayList(10);
            ExpressionTool.gatherReferencedVariables(this.select, arrayList);
            for (n = 0; n < arrayList.size(); ++n) {
                object = (Binding)arrayList.get(n);
                if (!(object instanceof GlobalVariable)) continue;
                ((GlobalVariable)object).lookForCycles(stack);
            }
            arrayList.clear();
            ExpressionTool.gatherCalledFunctions(this.select, arrayList);
            for (n = 0; n < arrayList.size(); ++n) {
                object = (UserFunction)arrayList.get(n);
                if (stack.contains(object)) continue;
                GlobalVariable.lookForFunctionCycles((UserFunction)object, stack);
            }
            stack.pop();
        }
    }

    private static void lookForFunctionCycles(UserFunction userFunction, Stack stack) throws StaticError {
        Object object;
        int n;
        Expression expression = userFunction.getBody();
        stack.push(userFunction);
        ArrayList arrayList = new ArrayList(10);
        ExpressionTool.gatherReferencedVariables(expression, arrayList);
        for (n = 0; n < arrayList.size(); ++n) {
            object = (Binding)arrayList.get(n);
            if (!(object instanceof GlobalVariable)) continue;
            ((GlobalVariable)object).lookForCycles(stack);
        }
        arrayList.clear();
        ExpressionTool.gatherCalledFunctions(expression, arrayList);
        for (n = 0; n < arrayList.size(); ++n) {
            object = (UserFunction)arrayList.get(n);
            if (stack.contains(object)) continue;
            GlobalVariable.lookForFunctionCycles((UserFunction)object, stack);
        }
        stack.pop();
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws XPathException {
        return null;
    }

    public ValueRepresentation getSelectValue(XPathContext xPathContext) throws XPathException {
        if (this.select == null) {
            throw new AssertionError((Object)"*** No select expression for global variable!!");
        }
        XPathContextMajor xPathContextMajor = xPathContext.newCleanContext();
        xPathContextMajor.setOrigin(this);
        AxisIterator axisIterator = SingletonIterator.makeIterator(xPathContextMajor.getController().getPrincipalSourceDocument());
        axisIterator.next();
        xPathContextMajor.setCurrentIterator(axisIterator);
        if (this.stackFrameMap != null) {
            xPathContextMajor.openStackFrame(this.stackFrameMap);
        }
        return ExpressionTool.lazyEvaluate(this.select, xPathContextMajor, this.referenceCount);
    }

    public ValueRepresentation evaluateVariable(XPathContext xPathContext) throws XPathException {
        Controller controller = xPathContext.getController();
        Bindery bindery = controller.getBindery();
        ValueRepresentation valueRepresentation = bindery.getGlobalVariableValue(this);
        if (valueRepresentation != null) {
            return valueRepresentation;
        }
        try {
            bindery.setExecuting(this, true);
            ValueRepresentation valueRepresentation2 = this.getSelectValue(xPathContext);
            bindery.defineGlobalVariable(this, valueRepresentation2);
            bindery.setExecuting(this, false);
            return valueRepresentation2;
        }
        catch (XPathException xPathException) {
            bindery.setExecuting(this, false);
            if (xPathException instanceof XPathException.Circularity) {
                DynamicError dynamicError = new DynamicError("Circular definition of variable " + this.getVariableName());
                int n = xPathContext.getController().getExecutable().getHostLanguage();
                dynamicError.setErrorCode(n == 51 ? "XQST0054" : "XTDE0640");
                dynamicError.setXPathContext(xPathContext);
                this.select = new ErrorExpression(dynamicError);
                dynamicError.setLocator(this);
                throw dynamicError;
            }
            throw xPathException;
        }
    }

    public InstructionInfo getInstructionInfo() {
        InstructionDetails instructionDetails = new InstructionDetails();
        instructionDetails.setConstructType(185);
        instructionDetails.setObjectNameCode(this.getVariableFingerprint());
        instructionDetails.setProperty("expression", this);
        instructionDetails.setSystemId(this.getSystemId());
        instructionDetails.setLineNumber(this.getLineNumber());
        instructionDetails.setColumnNumber(this.getColumnNumber());
        return instructionDetails;
    }
}

