/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pull;

import net.sf.saxon.pull.PullFilter;
import net.sf.saxon.pull.PullProvider;
import net.sf.saxon.trans.XPathException;

public class PullTracer
extends PullFilter {
    public PullTracer(PullProvider pullProvider) {
        super(pullProvider);
    }

    public int next() throws XPathException {
        this.currentEvent = super.next();
        this.traceEvent(this.currentEvent);
        return this.currentEvent;
    }

    private void traceEvent(int n) {
        PullProvider pullProvider = this.getUnderlyingProvider();
        switch (n) {
            case 2: {
                System.err.println("START_DOCUMENT");
                break;
            }
            case 4: {
                System.err.println("START_ELEMENT " + pullProvider.getNameCode());
                break;
            }
            case 8: {
                System.err.println("TEXT");
                break;
            }
            case 9: {
                System.err.println("COMMENT");
                break;
            }
            case 10: {
                System.err.println("PROCESSING_INSTRUCTION");
                break;
            }
            case 5: {
                System.err.println("END_ELEMENT " + pullProvider.getNameCode());
                break;
            }
            case 3: {
                System.err.println("END_DOCUMENT");
                break;
            }
            case -1: {
                System.err.println("END_OF_INPUT");
                break;
            }
            case 1: {
                try {
                    System.err.println("ATOMIC VALUE: " + pullProvider.getStringValue());
                    break;
                }
                catch (XPathException xPathException) {
                    // empty catch block
                }
            }
        }
    }
}

