/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import java.io.Serializable;
import java.text.CollationKey;
import java.text.Collator;
import java.util.Comparator;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.sort.CodepointCollator;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;

public class AtomicSortComparer
implements Comparator,
Serializable {
    private Comparator collator;
    private XPathContext conversionContext;
    private static StringValue NaN = new StringValue("NaN");

    public AtomicSortComparer(Comparator comparator, XPathContext xPathContext) {
        this.collator = comparator;
        if (comparator == null) {
            this.collator = CodepointCollator.getInstance();
        }
        this.conversionContext = xPathContext;
    }

    public int compare(Object object, Object object2) {
        if (object instanceof AtomicValue && !((AtomicValue)object).hasBuiltInType()) {
            object = ((AtomicValue)object).getPrimitiveValue();
        }
        if (object2 instanceof AtomicValue && !((AtomicValue)object2).hasBuiltInType()) {
            object2 = ((AtomicValue)object2).getPrimitiveValue();
        }
        if (object instanceof UntypedAtomicValue) {
            return ((UntypedAtomicValue)object).compareTo(object2, this.collator, this.conversionContext);
        }
        if (object2 instanceof UntypedAtomicValue) {
            return -((UntypedAtomicValue)object2).compareTo(object, this.collator, this.conversionContext);
        }
        if (object instanceof DoubleValue && Double.isNaN(((DoubleValue)object).getDoubleValue())) {
            if (object2 instanceof DoubleValue && Double.isNaN(((DoubleValue)object2).getDoubleValue())) {
                return 0;
            }
            return -1;
        }
        if (object2 instanceof DoubleValue && Double.isNaN(((DoubleValue)object2).getDoubleValue())) {
            return 1;
        }
        if (object instanceof CalendarValue && object2 instanceof CalendarValue) {
            return ((CalendarValue)object).compareTo((CalendarValue)object2, this.conversionContext);
        }
        if (object instanceof Comparable) {
            return ((Comparable)object).compareTo(object2);
        }
        if (object instanceof StringValue && object2 instanceof StringValue) {
            return this.collator.compare(((StringValue)object).getStringValue(), ((StringValue)object2).getStringValue());
        }
        if (object instanceof AtomicValue && object2 instanceof AtomicValue) {
            throw new ClassCastException("Objects are not comparable (" + ((AtomicValue)object).getItemType(null) + ", " + ((AtomicValue)object2).getItemType(null) + ')');
        }
        throw new ClassCastException("Objects are not comparable (" + object.getClass() + ", " + object2.getClass() + ')');
    }

    public ComparisonKey getComparisonKey(AtomicValue atomicValue) {
        AtomicValue atomicValue2 = atomicValue.getPrimitiveValue();
        Configuration configuration = this.conversionContext.getConfiguration();
        TypeHierarchy typeHierarchy = configuration.getNamePool().getTypeHierarchy();
        if (atomicValue2 instanceof NumericValue) {
            if (((NumericValue)atomicValue2).isNaN()) {
                return new ComparisonKey(646, NaN);
            }
            return new ComparisonKey(646, atomicValue2);
        }
        if (atomicValue2 instanceof StringValue) {
            if (this.collator instanceof Collator) {
                return new ComparisonKey(513, ((Collator)this.collator).getCollationKey(((StringValue)atomicValue2).getStringValue()));
            }
            return new ComparisonKey(513, atomicValue2);
        }
        if (atomicValue2 instanceof CalendarValue) {
            CalendarValue calendarValue = (CalendarValue)atomicValue2;
            if (calendarValue.hasTimezone()) {
                return new ComparisonKey(atomicValue2.getItemType(typeHierarchy).getPrimitiveType(), atomicValue2);
            }
            calendarValue = calendarValue.copy();
            calendarValue.setTimezoneInMinutes(configuration.getImplicitTimezone());
            return new ComparisonKey(calendarValue.getItemType(typeHierarchy).getPrimitiveType(), calendarValue);
        }
        return new ComparisonKey(atomicValue2.getItemType(typeHierarchy).getPrimitiveType(), atomicValue2);
    }

    public static class ComparisonKey {
        int category;
        Object value;

        public ComparisonKey(int n, AtomicValue atomicValue) {
            this.category = n;
            this.value = atomicValue;
        }

        public ComparisonKey(int n, CollationKey collationKey) {
            this.category = n;
            this.value = collationKey;
        }

        public boolean equals(Object object) {
            if (object instanceof ComparisonKey) {
                ComparisonKey comparisonKey = (ComparisonKey)object;
                return this.category == comparisonKey.category && this.value.equals(comparisonKey.value);
            }
            throw new ClassCastException("Cannot compare a ComparisonKey to an object of a different class");
        }

        public int hashCode() {
            return this.value.hashCode() ^ this.category;
        }
    }
}

